/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Locale;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingRequestHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String HEALTHCHECK_FILE_PARAM = "healthcheckFile";
    private String healthFileName = null;
    private Path healthcheck = null;

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        String action;
        switch (action = request.getParams().get("action", "").strip().toLowerCase(Locale.ROOT)) {
            case "enable": 
            case "disable": {
                return PermissionNameProvider.Name.CONFIG_EDIT_PERM;
            }
        }
        return PermissionNameProvider.Name.HEALTH_PERM;
    }

    @Override
    public void init(NamedList<?> args) {
        super.init(args);
        Object tmp = args.get(HEALTHCHECK_FILE_PARAM);
        this.healthFileName = null == tmp ? null : tmp.toString();
    }

    @Override
    public void inform(SolrCore core) {
        if (null != this.healthFileName) {
            this.healthcheck = Path.of(this.healthFileName, new String[0]);
            if (!this.healthcheck.isAbsolute()) {
                this.healthcheck = Path.of(core.getDataDir(), this.healthFileName);
                this.healthcheck = this.healthcheck.toAbsolutePath();
            }
            if (!Files.isWritable(this.healthcheck.getParent())) {
                log.warn("Directory for configured healthcheck file is not writable by solr, PingRequestHandler will not be able to control enable/disable: {}", (Object)this.healthcheck.getParent().toAbsolutePath());
            }
        }
    }

    public boolean isPingDisabled() {
        return null != this.healthcheck && !Files.exists(this.healthcheck, new LinkOption[0]);
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        Boolean distrib = params.getBool("distrib");
        if (distrib == null) {
            ModifiableSolrParams mparams = new ModifiableSolrParams(params);
            mparams.set("distrib", false);
            req.setParams((SolrParams)mparams);
        }
        String actionParam = params.get("action");
        ACTIONS action = null;
        if (actionParam == null) {
            action = ACTIONS.PING;
        } else {
            try {
                action = ACTIONS.valueOf(actionParam.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException iae) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + actionParam);
            }
        }
        switch (action) {
            case PING: {
                if (this.isPingDisabled()) {
                    SolrException e = new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Service disabled");
                    rsp.setException((Exception)((Object)e));
                    return;
                }
                this.handlePing(req, rsp);
                break;
            }
            case ENABLE: {
                this.handleEnable(true);
                break;
            }
            case DISABLE: {
                this.handleEnable(false);
                break;
            }
            case STATUS: {
                if (this.healthcheck == null) {
                    SolrException e = new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "healthcheck not configured");
                    rsp.setException((Exception)((Object)e));
                    break;
                }
                rsp.add("status", this.isPingDisabled() ? "disabled" : "enabled");
            }
        }
    }

    protected void handlePing(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String qt;
        SolrParams params = req.getParams();
        SolrCore core = req.getCore();
        SolrRequestHandler handler = core.getRequestHandler(qt = params.get("qt"));
        if (handler == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown RequestHandler (qt): " + qt);
        }
        if (handler instanceof PingRequestHandler) {
            if (params.getBool("isShard", false)) {
                handler = core.getRequestHandler(null);
                ModifiableSolrParams wparams = new ModifiableSolrParams(params);
                wparams.remove("qt");
                req.setParams((SolrParams)wparams);
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot execute the PingRequestHandler recursively");
            }
        }
        Exception ex = null;
        if (params.getBool("isShard", false)) {
            try {
                core.execute(handler, req, rsp);
                ex = rsp.getException();
            }
            catch (Exception e) {
                ex = e;
            }
            if (ex != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Ping query caused exception: " + ex.getMessage(), (Throwable)ex);
            }
        } else {
            try {
                SolrQueryResponse pingrsp = new SolrQueryResponse();
                core.execute(handler, req, pingrsp);
                ex = pingrsp.getException();
                NamedList<Object> headers = rsp.getResponseHeader();
                if (headers != null) {
                    headers.add("zkConnected", pingrsp.getResponseHeader().get("zkConnected"));
                }
            }
            catch (Exception e) {
                ex = e;
            }
            if (ex != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Ping query caused exception: " + ex.getMessage(), (Throwable)ex);
            }
            rsp.add("status", "OK");
        }
    }

    protected void handleEnable(boolean enable) throws SolrException {
        if (this.healthcheck == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No healthcheck file defined.");
        }
        if (enable) {
            try {
                Files.write(this.healthcheck, Instant.now().toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to write healthcheck flag file", (Throwable)e);
            }
        }
        try {
            Files.deleteIfExists(this.healthcheck);
        }
        catch (Throwable cause) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Did not successfully delete healthcheck file: " + this.healthcheck.toAbsolutePath(), cause);
        }
    }

    @Override
    public String getDescription() {
        return "Reports application health to a load-balancer";
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    protected static enum ACTIONS {
        STATUS,
        ENABLE,
        DISABLE,
        PING;

    }
}

