/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils.translation;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;

public class ExtensionsFileFilter
implements FilenameFilter {
    private List<String> extensions;

    public ExtensionsFileFilter(List<String> extensions) {
        this.extensions = extensions == null ? new ArrayList<String>() : new ArrayList<String>(extensions);
    }

    @Override
    public boolean accept(File dir, String name) {
        boolean accepted = false;
        if (name != null) {
            if (this.extensions.size() == 0) {
                accepted = true;
            } else {
                for (String ext : this.extensions) {
                    if (!name.endsWith(ext)) continue;
                    accepted = true;
                    break;
                }
            }
        }
        return accepted;
    }
}

