/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.utils;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class SignatureOutputStream
extends FilterOutputStream {
    private Signature signature;

    public SignatureOutputStream(OutputStream stream, String algorithm, PublicKey publicKey) throws NoSuchAlgorithmException {
        super(stream);
        try {
            this.signature = Signature.getInstance(algorithm);
            this.signature.initVerify(publicKey);
        }
        catch (InvalidKeyException e) {
            System.out.println("Internal Error at signature:" + e.getMessage());
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.signature.update((byte)b);
        }
        catch (SignatureException e) {
            throw new IOException("Signature update failed: " + e.getMessage());
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.signature.update(b, off, len);
        }
        catch (SignatureException e) {
            throw new IOException("Signature update failed: " + e.getMessage());
        }
        this.out.write(b, off, len);
    }

    public boolean verify(byte[] sign) throws SignatureException {
        return this.signature.verify(sign);
    }
}

