/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.graphics;

import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.visualization.AnimationGIF;
import net.yacy.visualization.RasterPlotter;

public class EncodedImage {
    private ByteBuffer image;
    private String extension;
    private boolean isStatic;

    public EncodedImage(byte[] imageData, String format, boolean isStatic) {
        if (imageData == null) {
            throw new IllegalArgumentException("imageData parameter is null");
        }
        if (format == null) {
            throw new IllegalArgumentException("format parameter is null");
        }
        this.image = new ByteBuffer(imageData);
        this.extension = format;
        this.isStatic = isStatic;
    }

    public EncodedImage(RasterPlotter sourceImage, String targetExt, boolean isStatic) {
        this.image = "png".equals(targetExt) ? sourceImage.exportPng() : RasterPlotter.exportImage(sourceImage.getImage(), targetExt);
        this.extension = targetExt;
        this.isStatic = isStatic;
    }

    public EncodedImage(BufferedImage bi, String targetExt, boolean isStatic) {
        this.extension = targetExt;
        this.image = RasterPlotter.exportImage(bi, targetExt);
        if (this.image == null || this.image.length() == 0) {
            BufferedImage converted = EncodedImage.convertToRGB(bi);
            this.image = RasterPlotter.exportImage(converted, targetExt);
        }
        this.isStatic = isStatic;
    }

    public EncodedImage(AnimationGIF sourceImage, boolean isStatic) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(sourceImage.get());
            bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.image = new ByteBuffer(bos.toByteArray());
        this.extension = "gif";
        this.isStatic = isStatic;
    }

    public ByteBuffer getImage() {
        return this.image;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public static BufferedImage convertToRGB(BufferedImage image) {
        BufferedImage converted = image;
        if (image.getType() != 1 && image.getType() != 2) {
            int targetType = image.getColorModel() != null && image.getColorModel().hasAlpha() ? 2 : 1;
            BufferedImage target = new BufferedImage(image.getWidth(), image.getHeight(), targetType);
            ColorConvertOp convertOP = new ColorConvertOp(null);
            converted = convertOP.filter(image, target);
        }
        return converted;
    }
}

