/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.workflow;

import net.yacy.kelondro.workflow.InstantBusyThread;

public abstract class OneTimeBusyThread
extends InstantBusyThread {
    public OneTimeBusyThread(String jobName, long startupDelay) {
        super(jobName, Long.MIN_VALUE, Long.MIN_VALUE);
        this.setStartupSleep(startupDelay);
        this.setIdleSleep(-1L);
        this.setBusySleep(-1L);
        this.setMemPreReqisite(0L);
        this.setLoadPreReqisite(Double.MAX_VALUE);
    }

    public OneTimeBusyThread(String jobName) {
        this(jobName, 0L);
    }

    public static OneTimeBusyThread startFromRunnable(final Runnable task, long startupDelay) {
        if (task == null) {
            throw new IllegalArgumentException("Runnable task must not be null");
        }
        OneTimeBusyThread busyThread = new OneTimeBusyThread(task.getClass().getName() + ".run", startupDelay){

            @Override
            public boolean jobImpl() throws Exception {
                task.run();
                return true;
            }
        };
        busyThread.start();
        return busyThread;
    }
}

