/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.io.ByteCount;

public final class ByteCountInputStream
extends FilterInputStream {
    private boolean finished = false;
    protected long byteCount;
    private String byteCountAccountName = null;

    protected ByteCountInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public ByteCountInputStream(InputStream inputStream, String accountName) {
        this(inputStream, 0, accountName);
    }

    public ByteCountInputStream(InputStream inputStream, int initByteCount, String accountName) {
        super(inputStream);
        this.byteCount = initByteCount;
        this.byteCountAccountName = accountName;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        int readCount = super.read(b);
        if (readCount > 0) {
            this.byteCount += (long)readCount;
        }
        return readCount;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        try {
            int readCount = super.read(b, off, len);
            if (readCount > 0) {
                this.byteCount += (long)readCount;
            }
            return readCount;
        }
        catch (IOException e) {
            throw new IOException(e.getMessage() + "; b.length = " + b.length + ", off = " + off + ", len = " + len);
        }
    }

    @Override
    public final int read() throws IOException {
        ++this.byteCount;
        return super.read();
    }

    @Override
    public final long skip(long len) throws IOException {
        long skipCount = super.skip(len);
        if (skipCount > 0L) {
            this.byteCount += skipCount;
        }
        return skipCount;
    }

    public final long getCount() {
        return this.byteCount;
    }

    public final String getAccountName() {
        return this.byteCountAccountName;
    }

    @Override
    public final synchronized void close() throws IOException {
        try {
            super.close();
        }
        catch (OutOfMemoryError e) {
            ConcurrentLog.logException(e);
        }
        this.finish();
    }

    public final void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        ByteCount.addAccountCount(this.byteCountAccountName, this.byteCount);
    }
}

