/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.kelondro.io.AbstractReader;
import net.yacy.kelondro.io.Writer;

public abstract class AbstractWriter
extends AbstractReader
implements Writer {
    private static final byte cr = 13;
    private static final byte lf = 10;

    @Override
    public abstract void setLength(long var1) throws IOException;

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public final void writeShort(int v) throws IOException {
        byte[] b = new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v & 0xFF)};
        this.write(b);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.write(AbstractWriter.int2array(v));
    }

    public static final byte[] int2array(int v) {
        byte[] b = new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v & 0xFF)};
        return b;
    }

    @Override
    public final void writeLong(long v) throws IOException {
        byte[] b = new byte[]{(byte)(v >>> 56 & 0xFFL), (byte)(v >>> 48 & 0xFFL), (byte)(v >>> 40 & 0xFFL), (byte)(v >>> 32 & 0xFFL), (byte)(v >>> 24 & 0xFFL), (byte)(v >>> 16 & 0xFFL), (byte)(v >>> 8 & 0xFFL), (byte)(v & 0xFFL)};
        this.write(b);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public final void writeLine(String line) throws IOException {
        byte[] b = new byte[line.length() + 2];
        System.arraycopy(UTF8.getBytes(line), 0, b, 0, line.length());
        b[b.length - 2] = 13;
        b[b.length - 1] = 10;
        this.write(b);
    }

    public final void writeLine(byte[] line) throws IOException {
        byte[] b = new byte[line.length + 2];
        System.arraycopy(line, 0, b, 0, line.length);
        b[b.length - 2] = 13;
        b[b.length - 1] = 10;
        this.write(b);
    }

    @Override
    public final void writeMap(Map<String, String> map, String comment) throws IOException {
        this.seek(0L);
        Iterator<Map.Entry<String, String>> iter = map.entrySet().iterator();
        ByteBuffer bb = new ByteBuffer(map.size() * 40);
        bb.append("# ").append(comment).append("\r\n");
        while (iter.hasNext()) {
            Map.Entry<String, String> entry2 = iter.next();
            bb.append(entry2.getKey()).append('=');
            if (entry2.getValue() != null) {
                bb.append(entry2.getValue());
            }
            bb.append("\r\n");
        }
        bb.append("# EOF\r\n");
        this.write(bb.getBytes());
        bb.close();
    }

    @Override
    public final HashMap<String, String> readMap() throws IOException {
        String line;
        this.seek(0L);
        byte[] b = this.readFully();
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(b)));
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = br.readLine()) != null) {
            int pos;
            if ("# EOF".equals(line = line.trim())) {
                return map;
            }
            if (line.isEmpty() || line.charAt(0) == '#' || (pos = line.indexOf(61)) < 0) continue;
            map.put(line.substring(0, pos), line.substring(pos + 1));
        }
        return map;
    }

    @Override
    public final void deleteOnExit() {
        if (this.file != null) {
            this.file.deleteOnExit();
        }
    }
}

