/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowCollection;
import net.yacy.kelondro.index.RowSet;
import net.yacy.kelondro.util.MergeIterator;
import net.yacy.kelondro.util.StackIterator;

public final class RAMIndex
implements Index,
Iterable<Row.Entry> {
    private static final Map<String, RAMIndex> objectTracker = Collections.synchronizedSortedMap(new TreeMap());
    private final String name;
    private final Row rowdef;
    private RowSet index0;
    private RowSet index1;
    private final Row.EntryComparator entryComparator;

    public RAMIndex(String name, Row rowdef) {
        this.name = name;
        this.rowdef = rowdef;
        this.entryComparator = new Row.EntryComparator(rowdef.objectOrder);
        this.reset();
        objectTracker.put(name, this);
    }

    private RAMIndex(String name, Row rowdef, RowSet index0, RowSet index1, Row.EntryComparator entryComparator) {
        this.name = name;
        this.rowdef = rowdef;
        this.index0 = index0;
        this.index1 = index1;
        this.entryComparator = entryComparator;
        objectTracker.put(name, this);
    }

    public static final Iterator<Map.Entry<String, RAMIndex>> objects() {
        return objectTracker.entrySet().iterator();
    }

    public RAMIndex clone() {
        return new RAMIndex(this.name + ".clone", this.rowdef, this.index0.clone(), this.index1.clone(), this.entryComparator);
    }

    @Override
    public void clear() {
        this.reset();
    }

    @Override
    public void optimize() {
        if (this.index0 != null) {
            this.index0.optimize();
        }
        if (this.index1 != null) {
            this.index1.optimize();
        }
    }

    public final synchronized void reset() {
        this.index0 = null;
        this.index0 = new RowSet(this.rowdef);
        this.index1 = null;
    }

    public final synchronized void reset(int initialspace) throws SpaceExceededException {
        this.index0 = null;
        this.index0 = new RowSet(this.rowdef, initialspace);
        this.index1 = null;
    }

    @Override
    public final Row row() {
        return this.index0.row();
    }

    protected final void finishInitialization() {
        if (this.index1 == null) {
            this.index0.sort();
            this.index0.uniq();
            this.index0.trim();
            this.index1 = new RowSet(this.rowdef);
        }
    }

    @Override
    public final synchronized byte[] smallestKey() {
        byte[] b0 = this.index0.smallestKey();
        if (b0 == null) {
            return null;
        }
        if (this.index1 == null) {
            return b0;
        }
        byte[] b1 = this.index0.smallestKey();
        if (b1 == null || this.rowdef.objectOrder.compare(b1, b0) > 0) {
            return b0;
        }
        return b1;
    }

    @Override
    public final synchronized byte[] largestKey() {
        byte[] b0 = this.index0.largestKey();
        if (b0 == null) {
            return null;
        }
        if (this.index1 == null) {
            return b0;
        }
        byte[] b1 = this.index0.largestKey();
        if (b1 == null || this.rowdef.objectOrder.compare(b0, b1) > 0) {
            return b0;
        }
        return b1;
    }

    @Override
    public final synchronized Row.Entry get(byte[] key, boolean forceclone) {
        assert (key != null);
        this.finishInitialization();
        assert (this.index0.isSorted());
        Row.Entry indexentry = this.index0.get(key, forceclone);
        if (indexentry != null) {
            return indexentry;
        }
        return this.index1.get(key, forceclone);
    }

    @Override
    public Map<byte[], Row.Entry> getMap(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        TreeMap<byte[], Row.Entry> map = new TreeMap<byte[], Row.Entry>(this.row().objectOrder);
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            map.put(key, entry2);
        }
        return map;
    }

    @Override
    public List<Row.Entry> getList(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>(keys.size());
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            list2.add(entry2);
        }
        return list2;
    }

    @Override
    public final synchronized boolean has(byte[] key) {
        assert (key != null);
        this.finishInitialization();
        assert (this.index0.isSorted());
        if (this.index0.has(key)) {
            return true;
        }
        return this.index1.has(key);
    }

    @Override
    public final synchronized Row.Entry replace(Row.Entry entry2) throws SpaceExceededException {
        assert (entry2 != null);
        this.finishInitialization();
        assert (this.index0.isSorted());
        byte[] key = entry2.getPrimaryKeyBytes();
        if (this.index0.has(key)) {
            return this.index0.replace(entry2);
        }
        return this.index1.replace(entry2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean put(Row.Entry entry2) throws SpaceExceededException {
        assert (entry2 != null);
        if (entry2 == null) {
            return true;
        }
        RAMIndex rAMIndex = this;
        synchronized (rAMIndex) {
            this.finishInitialization();
            assert (this.index0.isSorted());
            byte[] key = entry2.getPrimaryKeyBytes();
            if (this.index0.has(key)) {
                this.index0.put(entry2);
                return false;
            }
            return this.index1.put(entry2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addUnique(Row.Entry entry2) throws SpaceExceededException {
        assert (entry2 != null);
        if (entry2 == null) {
            return;
        }
        RAMIndex rAMIndex = this;
        synchronized (rAMIndex) {
            if (this.index1 == null) {
                this.index0.addUnique(entry2);
                return;
            }
            this.index1.addUnique(entry2);
        }
    }

    public final void addUnique(List<Row.Entry> rows) throws SpaceExceededException {
        Iterator<Row.Entry> i = rows.iterator();
        while (i.hasNext()) {
            this.addUnique(i.next());
        }
    }

    public final synchronized long inc(byte[] key, int col, long add, Row.Entry initrow) throws SpaceExceededException {
        assert (key != null);
        this.finishInitialization();
        assert (this.index0.isSorted());
        long l = this.index0.inc(key, col, add, null);
        if (l != Long.MIN_VALUE) {
            return l;
        }
        return this.index1.inc(key, col, add, initrow);
    }

    public final synchronized ArrayList<RowCollection> removeDoubles() throws SpaceExceededException {
        this.index0.sort();
        if (this.index1 == null) {
            return this.index0.removeDoubles();
        }
        List d0 = this.index0.removeDoubles();
        List d1 = this.index1.removeDoubles();
        ((ArrayList)d0).addAll(d1);
        return d0;
    }

    @Override
    public final synchronized boolean delete(byte[] key) {
        this.finishInitialization();
        boolean b = this.index0.delete(key);
        if (b) {
            assert (!this.index0.has(key));
            return true;
        }
        b = this.index1.delete(key);
        assert (this.index1.has(key)) : "removed " + (b ? " true" : " false") + ", and index entry still exists";
        return b;
    }

    @Override
    public final synchronized Row.Entry remove(byte[] key) {
        this.finishInitialization();
        int s = this.index0.size();
        Row.Entry indexentry = this.index0.remove(key);
        if (indexentry != null) {
            assert (this.index0.size() < s) : "s = " + s + ", index0.size() = " + this.index0.size();
            assert (!this.index0.has(key));
            return indexentry;
        }
        s = this.index1.size();
        Row.Entry removed = this.index1.remove(key);
        assert (removed == null || this.index1.size() < s) : "s = " + s + ", index1.size() = " + this.index1.size();
        assert (!this.index1.has(key)) : "removed " + (removed == null ? " is null" : " is not null") + ", and index entry still exists";
        return removed;
    }

    @Override
    public final synchronized Row.Entry removeOne() {
        if (this.index1 != null && !this.index1.isEmpty()) {
            return this.index1.removeOne();
        }
        if (this.index0 != null && !this.index0.isEmpty()) {
            return this.index0.removeOne();
        }
        return null;
    }

    @Override
    public synchronized List<Row.Entry> top(int count) throws IOException {
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        List<Row.Entry> list0 = this.index1.top(count);
        list2.addAll(list0);
        list0 = this.index0.top(count - list2.size());
        list2.addAll(list0);
        return list2;
    }

    @Override
    public synchronized List<Row.Entry> random(int count) throws IOException {
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        List<Row.Entry> list0 = this.index1.random(count);
        list2.addAll(list0);
        list0 = this.index0.random(count - list2.size());
        list2.addAll(list0);
        return list2;
    }

    @Override
    public long mem() {
        if (this.index0 != null && this.index1 == null) {
            return this.index0.mem();
        }
        if (this.index0 == null && this.index1 != null) {
            return this.index1.mem();
        }
        assert (this.index0 != null && this.index1 != null);
        return this.index0.mem() + this.index1.mem();
    }

    @Override
    public final int size() {
        if (this.index0 != null && this.index1 == null) {
            return this.index0.size();
        }
        if (this.index0 == null && this.index1 != null) {
            return this.index1.size();
        }
        assert (this.index0 != null && this.index1 != null);
        return this.index0.size() + this.index1.size();
    }

    @Override
    public final boolean isEmpty() {
        if (this.index0 != null && this.index1 == null) {
            return this.index0.isEmpty();
        }
        if (this.index0 == null && this.index1 != null) {
            return this.index1.isEmpty();
        }
        assert (this.index0 != null && this.index1 != null);
        if (!this.index0.isEmpty()) {
            return false;
        }
        return this.index1.isEmpty();
    }

    @Override
    public final synchronized CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) {
        if (this.index1 == null) {
            this.index0.sort();
            this.index0.uniq();
            this.index1 = new RowSet(this.rowdef);
            return this.index0.keys(up, firstKey);
        }
        assert (this.index1 != null);
        if (this.index0 == null) {
            return this.index1.keys(up, firstKey);
        }
        CloneableIterator<byte[]> k0 = this.index0.keys(up, firstKey);
        CloneableIterator<byte[]> k1 = this.index1.keys(up, firstKey);
        if (k0 == null) {
            return k1;
        }
        if (k1 == null) {
            return k0;
        }
        return new MergeIterator<byte[]>(k0, k1, this.rowdef.objectOrder, MergeIterator.simpleMerge, up);
    }

    @Override
    public final synchronized CloneableIterator<Row.Entry> rows(boolean up, byte[] firstKey) {
        if (this.index1 == null) {
            this.index0.sort();
            this.index0.uniq();
            this.index1 = new RowSet(this.rowdef);
            return this.index0.rows(up, firstKey);
        }
        assert (this.index1 != null);
        if (this.index0 == null) {
            return this.index1.rows(up, firstKey);
        }
        CloneableIterator<Row.Entry> k0 = this.index0.rows(up, firstKey);
        CloneableIterator<Row.Entry> k1 = this.index1.rows(up, firstKey);
        if (k0 == null) {
            return k1;
        }
        if (k1 == null) {
            return k0;
        }
        return new MergeIterator<Row.Entry>(k0, k1, this.entryComparator, MergeIterator.simpleMerge, up);
    }

    @Override
    public final Iterator<Row.Entry> iterator() {
        return this.rows();
    }

    @Override
    public final synchronized CloneableIterator<Row.Entry> rows() {
        if (this.index1 == null) {
            this.index0.sort();
            this.index0.uniq();
            this.index1 = new RowSet(this.rowdef);
            return this.index0.rows();
        }
        assert (this.index1 != null);
        if (this.index0 == null) {
            return this.index1.rows();
        }
        return new StackIterator<Row.Entry>(this.index0.rows(), this.index1.rows(), null, true);
    }

    @Override
    public final synchronized void close() {
        if (this.index0 != null) {
            this.index0.close();
        }
        if (this.index1 != null) {
            this.index1.close();
        }
        objectTracker.remove(this.name);
    }

    @Override
    public final String filename() {
        return null;
    }

    @Override
    public final void deleteOnExit() {
    }
}

