/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.HashMap;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.TransactionManager;
import net.yacy.http.ReferrerPolicy;
import net.yacy.peers.Network;
import net.yacy.peers.operation.yacySeedUploader;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public final class Settings_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        String page = post == null ? "general" : post.get("page", "general");
        prop.put("transactionToken", TransactionManager.getTransactionToken(header, "/SettingsAck_p.html"));
        if (page.equals("ProxyAccess")) {
            prop.put("settingsTables", "Settings_ProxyAccess.inc");
        } else if (page.equals("proxy")) {
            prop.put("settingsTables", "Settings_Proxy.inc");
        } else if (page.equals("UrlProxyAccess")) {
            prop.put("settingsTables", "Settings_UrlProxyAccess.inc");
        } else if (page.equals("ServerAccess")) {
            prop.put("settingsTables", "Settings_ServerAccess.inc");
        } else if (page.equals("referrer")) {
            prop.put("settingsTables", "Settings_Referrer.inc");
        } else if (page.equals("SystemBehaviour")) {
            prop.put("settingsTables", "Settings_SystemBehaviour.inc");
        } else if (page.equals("seed")) {
            prop.put("settingsTables", "Settings_Seed.inc");
        } else if (page.equals("messageForwarding")) {
            prop.put("settingsTables", "Settings_MessageForwarding.inc");
        } else if (page.equals("parser")) {
            prop.put("settingsTables", "Settings_Parser.inc");
        } else if (page.equals("crawler")) {
            prop.put("settingsTables", "Settings_Crawler.inc");
        } else if (page.equals("debug")) {
            prop.put("settingsTables", "Settings_Debug.inc");
        } else if (page.equals("httpClient")) {
            prop.put("settingsTables", "Settings_HttpClient.inc");
        } else {
            prop.put("settingsTables", "");
        }
        prop.put("port", env.getLocalPort());
        prop.putHTML("peerName", sb.peers.mySeed().getName());
        prop.putHTML("staticIP", env.getConfig("staticIP", ""));
        prop.putHTML("publicPort", env.getConfig("publicPort", ""));
        prop.putHTML("fileHost", env.getConfig("fileHost", "localpeer"));
        String peerLang = env.getConfig("locale.language", "default");
        if (peerLang.equals("default")) {
            peerLang = "en";
        }
        prop.putHTML("peerLang", peerLang);
        prop.put("isTransparentProxy", env.getConfigBool("isTransparentProxy", false) ? "1" : "0");
        prop.put("proxyAlwaysFresh", env.getConfigBool("proxyAlwaysFresh", false) ? "1" : "0");
        prop.put("proxy.sendViaHeader", env.getConfigBool("proxy.sendViaHeader", false) ? "1" : "0");
        prop.put("proxy.sendXForwardedForHeader", env.getConfigBool("proxy.sendXForwardedForHeader", true) ? "1" : "0");
        prop.put("remoteProxyUseChecked", env.getConfigBool("remoteProxyUse", false) ? 1L : 0L);
        prop.put("remoteProxyUse4SSL", env.getConfigBool("remoteProxyUse4SSL", true) ? 1L : 0L);
        prop.putHTML("remoteProxyHost", env.getConfig("remoteProxyHost", ""));
        prop.putHTML("remoteProxyPort", env.getConfig("remoteProxyPort", ""));
        prop.putHTML("remoteProxyUser", env.getConfig("remoteProxyUser", ""));
        prop.putHTML("remoteProxyPwd", env.getConfig("remoteProxyPwd", ""));
        prop.putHTML("remoteProxyNoProxy", env.getConfig("remoteProxyNoProxy", ""));
        prop.putHTML("proxyfilter", env.getConfig("proxyClient", "*"));
        if (!env.getConfigBool("use_proxyAccounts", false)) {
            prop.put("use_proxyAccounts", "0");
        } else {
            prop.put("use_proxyAccounts", "1");
        }
        prop.putHTML("urlproxyfilter", env.getConfig("proxyURL.access", "127.0.0.1,0:0:0:0:0:0:0:1"));
        prop.putHTML("urlproxydomains", env.getConfig("proxyURL.rewriteURLs", "domainlist"));
        prop.put("urlproxyenabled_checked", env.getConfigBool("proxyURL", false) ? "1" : "0");
        prop.put("urlproxyuseforresults_checked", env.getConfigBool("proxyURL.useforresults", false) ? "1" : "0");
        prop.putHTML("serverfilter", env.getConfig("serverClient", "*"));
        prop.put("server.response.compress.gzip", env.getConfigBool("server.response.compress.gzip", true));
        prop.put("serveruser", "server");
        prop.putXML("clientIP", header.getRemoteAddr() == null ? "<unknown>" : header.getRemoteAddr());
        String enabledUploader = env.getConfig("seedUploadMethod", "none");
        if (enabledUploader.equalsIgnoreCase("Ftp") || enabledUploader.equals("") && env.getConfig("seedFTPPassword", "").length() > 0 && env.getConfig("seedFilePath", "").length() > 0) {
            enabledUploader = "Ftp";
            env.setConfig("seedUploadMethod", enabledUploader);
        }
        HashMap<String, String> uploaders = Network.getSeedUploadMethods();
        prop.put("seedUploadMethods", uploaders.size() + 1);
        prop.put("seedUploadMethods_0_name", "none");
        prop.put("seedUploadMethods_0_selected", enabledUploader.equals("none") ? "1" : "0");
        prop.put("seedUploadMethods_0_file", "");
        int count = 0;
        for (String uploaderName : uploaders.keySet()) {
            prop.put("seedUploadMethods_" + ++count + "_name", uploaderName);
            prop.put("seedUploadMethods_" + count + "_selected", uploaderName.equals(enabledUploader) ? "1" : "0");
            prop.put("seedUploadMethods_" + count + "_file", "Settings_Seed_Upload" + uploaderName + ".inc");
            yacySeedUploader theUploader = Network.getSeedUploader(uploaderName);
            String[] configOptions = theUploader.getConfigurationOptions();
            if (configOptions == null) continue;
            for (int i = 0; i < configOptions.length; ++i) {
                prop.put(configOptions[i], env.getConfig(configOptions[i], ""));
            }
        }
        prop.put("seedURL", sb.peers.mySeed().get("seedURL", ""));
        prop.put("msgForwardingEnabled", env.getConfigBool("msgForwardingEnabled", false) ? "1" : "0");
        prop.putHTML("msgForwardingCmd", env.getConfig("msgForwardingCmd", ""));
        prop.putHTML("msgForwardingTo", env.getConfig("msgForwardingTo", ""));
        prop.putHTML("crawler.clientTimeout", sb.getConfig("crawler.clientTimeout", "10000"));
        prop.putHTML("crawler.http.maxFileSize", sb.getConfig("crawler.http.maxFileSize", "-1"));
        prop.putHTML("crawler.ftp.maxFileSize", sb.getConfig("crawler.ftp.maxFileSize", "-1"));
        prop.putHTML("crawler.smb.maxFileSize", sb.getConfig("crawler.smb.maxFileSize", "-1"));
        prop.putHTML("crawler.file.maxFileSize", sb.getConfig("crawler.file.maxFileSize", "-1"));
        prop.put("server.https", sb.getConfigBool("server.https", false));
        prop.put("server.https_port.ssl", sb.getConfig("port.ssl", "8443"));
        prop.put("port.shutdown", sb.getConfig("port.shutdown", "-1"));
        String metaPolicy = env.getConfig("referrer.meta.policy", "origin-when-cross-origin");
        prop.put("metaPolicyNoReferrerChecked", ReferrerPolicy.NO_REFERRER.getValue().equals(metaPolicy) ? 1L : 0L);
        prop.put("metaPolicySameOriginChecked", ReferrerPolicy.SAME_ORIGIN.getValue().equals(metaPolicy) ? 1L : 0L);
        prop.put("metaPolicyStrictOriginChecked", ReferrerPolicy.STRICT_ORIGIN.getValue().equals(metaPolicy) ? 1L : 0L);
        prop.put("metaPolicyOriginChecked", ReferrerPolicy.ORIGIN.getValue().equals(metaPolicy) ? 1L : 0L);
        prop.put("metaPolicyStrictOriginWhenCrossOriginChecked", ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN.getValue().equals(metaPolicy) ? 1L : 0L);
        prop.put("metaPolicyOriginWhenCrossOriginChecked", ReferrerPolicy.ORIGIN_WHEN_CROSS_ORIGIN.getValue().equals(metaPolicy) ? 1L : 0L);
        prop.put("metaPolicyNoReferrerWhenDowngradeChecked", ReferrerPolicy.NO_REFERRER_WHEN_DOWNGRADE.getValue().equals(metaPolicy) ? 1L : 0L);
        prop.put("metaPolicyEmptyChecked", ReferrerPolicy.EMPTY.getValue().equals(metaPolicy) ? 1L : 0L);
        prop.put("metaPolicyUnsafeUrlChecked", ReferrerPolicy.UNSAFE_URL.getValue().equals(metaPolicy) ? 1L : 0L);
        if (ReferrerPolicy.contains(metaPolicy)) {
            prop.put("metaPolicyCustom", 0L);
        } else {
            prop.put("metaPolicyCustom", 1L);
            prop.put("metaPolicyCustom_checked", 1L);
            prop.put("metaPolicyCustom_value", metaPolicy);
        }
        prop.put("searchResultNoReferrerChecked", env.getConfigBool("search.result.noreferrer", false) ? 1L : 0L);
        prop.put("solrBinaryResponseChecked", env.getConfigBool("remote.solr.binaryResponse.enabled", true) ? 1L : 0L);
        prop.put("http.outgoing.general.tls.sniExtension.enabled", env.getConfigBool("http.outgoing.general.tls.sniExtension.enabled", true));
        prop.put("http.outgoing.remoteSolr.tls.sniExtension.enabled", env.getConfigBool("http.outgoing.remoteSolr.tls.sniExtension.enabled", true));
        String jvmSniExtensionSetting = System.getProperty("jsse.enableSNIExtension");
        prop.put("http.outgoing.general.tls.sniExtension.enabled.readonly", jvmSniExtensionSetting != null);
        prop.put("http.outgoing.general.tls.sniExtension.enabled.readonly_jvmSettingValue", jvmSniExtensionSetting);
        prop.put("http.outgoing.remoteSolr.tls.sniExtension.enabled.readonly", jvmSniExtensionSetting != null);
        prop.put("http.outgoing.remoteSolr.tls.sniExtension.enabled.readonly_jvmSettingValue", jvmSniExtensionSetting);
        prop.put("searchLocalDHTChecked", !env.getConfigBool("debug.search.local.dht.off", false) ? 1L : 0L);
        prop.put("searchLocalSolrChecked", !env.getConfigBool("debug.search.local.solr.off", false) ? 1L : 0L);
        prop.put("searchRemoteDHTChecked", !env.getConfigBool("debug.search.remote.dht.off", false) ? 1L : 0L);
        prop.put("searchRemoteSolrChecked", !env.getConfigBool("debug.search.remote.solr.off", false) ? 1L : 0L);
        prop.put("searchTestLocalDHTChecked", env.getConfigBool("debug.search.remote.dht.testlocal", false) ? 1L : 0L);
        prop.put("searchTestLocalSolrChecked", env.getConfigBool("debug.search.remote.solr.testlocal", false) ? 1L : 0L);
        prop.put("searchShowRankingChecked", env.getConfigBool("search.result.show.ranking", false) ? 1L : 0L);
        prop.put("debug.snippets.statistics.enabled", sb.getConfigBool("debug.snippets.statistics.enabled", false));
        return prop;
    }
}

