/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeSet;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.TransactionManager;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.OS;
import net.yacy.peers.operation.yacyBuildProperties;
import net.yacy.peers.operation.yacyRelease;
import net.yacy.peers.operation.yacyVersion;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class ConfigUpdate_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int downloadedFilesNum;
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        if (OS.isWindows && sb.appPath.toString().indexOf("Program Files") > -1) {
            prop.put("candeploy", "3");
            return prop;
        }
        if (OS.canExecUnix || OS.isWindows) {
            prop.put("candeploy", "1");
        } else {
            prop.put("candeploy", "0");
        }
        prop.put("candeploy_configCommit", "0");
        prop.put("candeploy_autoUpdate", "0");
        prop.put("candeploy_downloadsAvailable", "0");
        prop.put("candeploy_downloadError", "0");
        if (post != null) {
            String release;
            if (post.containsKey("downloadRelease") && !(release = post.get("releasedownload", "")).isEmpty()) {
                try {
                    File downloadedRelease;
                    yacyRelease versionToDownload = new yacyRelease(new DigestURL(release));
                    yacyRelease.DevAndMainVersions allReleases = yacyRelease.allReleases(false, false);
                    TreeSet<yacyRelease> mostReleases = versionToDownload.isMainRelease() ? allReleases.main : allReleases.dev;
                    for (yacyRelease rel : mostReleases) {
                        if (!rel.equals(versionToDownload)) continue;
                        versionToDownload = rel;
                        break;
                    }
                    if ((downloadedRelease = versionToDownload.downloadRelease()) == null) {
                        prop.put("candeploy_downloadError", "1");
                        prop.putHTML("candeploy_downloadError_releasedownload", release);
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                    prop.put("candeploy_downloadError", "1");
                    prop.putHTML("candeploy_downloadError_releasedownload", release);
                }
            }
            if (post.containsKey("checkRelease")) {
                yacyRelease.allReleases(true, false);
            }
            if (post.containsKey("deleteRelease") && !(release = post.get("releaseinstall", "")).isEmpty()) {
                try {
                    if (FileUtils.isInDirectory(new File(sb.releasePath, release), sb.releasePath)) {
                        FileUtils.deletedelete(new File(sb.releasePath, release));
                        FileUtils.deletedelete(new File(sb.releasePath, release + ".sig"));
                    } else {
                        sb.getLog().severe("AUTO-UPDATE: could not delete " + release + ": file not in release directory.");
                    }
                }
                catch (NullPointerException e) {
                    sb.getLog().severe("AUTO-UPDATE: could not delete release " + release + ": " + e.getMessage());
                }
            }
            if (post.containsKey("autoUpdate")) {
                yacyRelease updateVersion = yacyRelease.rulebasedUpdateInfo(true);
                if (updateVersion == null) {
                    prop.put("candeploy_autoUpdate", "2");
                } else {
                    sb.getLog().info("AUTO-UPDATE: downloading more recent release " + String.valueOf(updateVersion.getUrl()));
                    File downloaded = updateVersion.downloadRelease();
                    prop.putHTML("candeploy_autoUpdate_downloadedRelease", updateVersion.getName());
                    boolean devenvironment = new File(sb.getAppPath(), ".git").exists();
                    if (devenvironment) {
                        sb.getLog().info("AUTO-UPDATE: omitting update because this is a development environment");
                        prop.put("candeploy_autoUpdate", "3");
                    } else if (downloaded == null || !downloaded.exists() || downloaded.length() == 0L) {
                        sb.getLog().info("AUTO-UPDATE: omitting update because download failed (file cannot be found, is too small or signature was bad)");
                        prop.put("candeploy_autoUpdate", "4");
                    } else if (yacyRelease.deployRelease(downloaded)) {
                        sb.terminate(10L, "manual release update to " + downloaded.getName());
                        sb.getLog().info("AUTO-UPDATE: deploy and restart initiated");
                        prop.put("candeploy_autoUpdate", "1");
                    } else {
                        sb.getLog().info("AUTO-UPDATE: omitting update because an error occurred while trying to deploy the release..");
                        prop.put("candeploy_autoUpdate", "5");
                    }
                }
            }
            if (post.containsKey("configSubmit")) {
                prop.put("candeploy_configCommit", "1");
                sb.setConfig("update.process", "manual".equals(post.get("updateMode", "manual")) ? "manual" : "auto");
                sb.setConfig("update.cycle", Math.max(12L, post.getLong("cycle", 168L)));
                sb.setConfig("update.blacklist", post.get("blacklist", ""));
                sb.setConfig("update.concept", "any".equals(post.get("releaseType", "any")) ? "any" : "main");
                sb.setConfig("update.onlySignedFiles", post.getBoolean("onlySignedFiles") ? "1" : "0");
            }
        }
        String versionstring = yacyBuildProperties.getReleaseStub();
        prop.putHTML("candeploy_versionpp", versionstring);
        boolean devenvironment = new File(sb.getAppPath(), ".git").exists();
        float thisVersion = Float.parseFloat(yacyBuildProperties.getVersion());
        try {
            thisVersion = (float)((double)Math.round((double)thisVersion * 1000.0) / 1000.0);
        }
        catch (NumberFormatException mostReleases) {
            // empty catch block
        }
        File[] downloadedFiles = sb.releasePath.listFiles();
        int n = downloadedFilesNum = downloadedFiles == null ? 0 : downloadedFiles.length;
        prop.put("candeploy_deployenabled", downloadedFilesNum == 0 ? "0" : (devenvironment ? "1" : "2"));
        TreeSet<yacyRelease> downloadedReleases = new TreeSet<yacyRelease>();
        for (File downloaded : downloadedFiles) {
            try {
                yacyRelease release = new yacyRelease(downloaded);
                downloadedReleases.add(release);
            }
            catch (RuntimeException e) {
                File invalid = downloaded;
                if (invalid.getName().endsWith(".bat") || invalid.getName().endsWith(".sh") || invalid.getName().endsWith(".sig")) continue;
                invalid.deleteOnExit();
            }
        }
        yacyVersion dflt = downloadedReleases.isEmpty() ? null : (yacyVersion)downloadedReleases.last();
        prop.put("candeploy_downloadsAvailable", downloadedReleases.isEmpty() ? "0" : "1");
        prop.put("candeploy_deployenabled_buttonsActive", downloadedReleases.isEmpty() || devenvironment ? "0" : "1");
        prop.put("candeploy_deployenabled_transactionToken", TransactionManager.getTransactionToken(header, "/Steering.html"));
        int relcount = 0;
        for (yacyRelease release : downloadedReleases) {
            prop.put("candeploy_downloadedreleases_" + relcount + "_name", (release.isMainRelease() ? "main" : "dev") + " " + release.getReleaseNr() + "/" + release.getSvn());
            prop.put("candeploy_downloadedreleases_" + relcount + "_signature", release.getSignatureFile().exists() ? "1" : "0");
            prop.putHTML("candeploy_downloadedreleases_" + relcount + "_file", release.getName());
            prop.put("candeploy_downloadedreleases_" + relcount + "_selected", release == dflt ? "1" : "0");
            ++relcount;
        }
        prop.put("candeploy_downloadedreleases", relcount);
        yacyRelease.DevAndMainVersions releasess = yacyRelease.allReleases(false, false);
        relcount = 0;
        ArrayList<yacyRelease> rlist = new ArrayList<yacyRelease>();
        TreeSet<yacyRelease> remoteDevReleases = releasess.dev;
        remoteDevReleases.removeAll(downloadedReleases);
        for (yacyRelease yacyRelease2 : remoteDevReleases) {
            rlist.add(yacyRelease2);
        }
        TreeSet<yacyRelease> remoteMainReleases = releasess.main;
        remoteMainReleases.removeAll(downloadedReleases);
        for (yacyRelease release : remoteMainReleases) {
            rlist.add(release);
        }
        for (int i = rlist.size() - 1; i >= 0; --i) {
            yacyRelease yacyRelease3 = (yacyRelease)rlist.get(i);
            prop.put("candeploy_availreleases_" + relcount + "_name", (yacyRelease3.isMainRelease() ? "main" : "dev") + " " + yacyRelease3.getReleaseNr() + "/" + yacyRelease3.getSvn());
            prop.put("candeploy_availreleases_" + relcount + "_url", yacyRelease3.getUrl().toNormalform(false));
            prop.put("candeploy_availreleases_" + relcount + "_signatures", yacyRelease3.getPublicKey() != null ? "1" : "0");
            prop.put("candeploy_availreleases_" + relcount + "_selected", relcount == 0 ? "1" : "0");
            ++relcount;
        }
        prop.put("candeploy_availreleases", relcount);
        prop.put("candeploy_manualUpdateChecked", "manual".equals(sb.getConfig("update.process", "manual")) ? "1" : "0");
        prop.put("candeploy_autoUpdateChecked", "auto".equals(sb.getConfig("update.process", "manual")) ? "1" : "0");
        prop.put("candeploy_cycle", sb.getConfigLong("update.cycle", 168L));
        prop.putHTML("candeploy_blacklist", sb.getConfig("update.blacklist", ""));
        prop.put("candeploy_releaseTypeMainChecked", "any".equals(sb.getConfig("update.concept", "any")) ? "0" : "1");
        prop.put("candeploy_releaseTypeAnyChecked", "any".equals(sb.getConfig("update.concept", "any")) ? "1" : "0");
        prop.put("candeploy_lastlookup", sb.getConfigLong("update.time.lookup", 0L) == 0L ? "0" : "1");
        prop.put("candeploy_lastlookup_time", new Date(sb.getConfigLong("update.time.lookup", 0L)).toString());
        prop.put("candeploy_lastdownload", sb.getConfigLong("update.time.download", 0L) == 0L ? "0" : "1");
        prop.put("candeploy_lastdownload_time", new Date(sb.getConfigLong("update.time.download", 0L)).toString());
        prop.put("candeploy_lastdeploy", sb.getConfigLong("update.time.deploy", 0L) == 0L ? "0" : "1");
        prop.put("candeploy_lastdeploy_time", new Date(sb.getConfigLong("update.time.deploy", 0L)).toString());
        prop.put("candeploy_onlySignedFiles", "1".equals(sb.getConfig("update.onlySignedFiles", "1")) ? "1" : "0");
        return prop;
    }
}

