/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.BlogBoard;
import net.yacy.data.UserDB;
import net.yacy.http.servlets.YaCyDefaultServlet;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class Blog {
    private static final String DEFAULT_PAGE = "blog_default";
    private static DateFormat SimpleFormatter = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());

    public static String dateString(Date date) {
        return SimpleFormatter.format(date);
    }

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        BlogBoard.BlogEntry page = null;
        boolean hasRights = sb.verifyAuthentication(header);
        prop.put("display", 1L);
        boolean xml = header.getPathInfo().endsWith(".xml");
        String context = YaCyDefaultServlet.getContext(header, sb);
        prop.put("mode_admin", hasRights ? "1" : "0");
        if (post == null) {
            prop.putHTML("peername", sb.peers.mySeed().getName());
            prop.put("context", context);
            return Blog.putBlogDefault(prop, sb, context, 0, 10, hasRights, xml);
        }
        int start = post.getInt("start", 0);
        int num = post.getInt("num", 10);
        if (!hasRights) {
            UserDB.Entry userentry = sb.userDB.proxyAuth(header);
            if (userentry != null && userentry.hasRight(UserDB.AccessRight.BLOG_RIGHT)) {
                hasRights = true;
            } else if (post.containsKey("login")) {
                prop.authenticationRequired();
            }
        }
        String pagename = post.get("page", DEFAULT_PAGE);
        String ip = header.getRemoteAddr();
        String strAuthor = post.get("author", "anonymous");
        if ("anonymous".equals(strAuthor) && ((strAuthor = sb.blogDB.guessAuthor(ip)) == null || strAuthor.isEmpty())) {
            strAuthor = sb.peers.mySeed() == null ? "anonymous" : sb.peers.mySeed().get("Name", "anonymous");
        }
        byte[] author = UTF8.getBytes(strAuthor);
        if (hasRights && post.containsKey("delete") && "sure".equals(post.get("delete"))) {
            page = sb.blogDB.readBlogEntry(pagename);
            for (String comment : page.getComments()) {
                sb.blogCommentDB.delete(comment);
            }
            sb.blogDB.deleteBlogEntry(pagename);
            pagename = DEFAULT_PAGE;
        }
        if (post.containsKey("discard")) {
            pagename = DEFAULT_PAGE;
        }
        if (post.containsKey("submit") && hasRights) {
            Date date;
            byte[] content = UTF8.getBytes(post.get("content", ""));
            List<String> comments = null;
            if (DEFAULT_PAGE.equals(pagename)) {
                pagename = String.valueOf(System.currentTimeMillis());
                date = null;
            } else {
                page = sb.blogDB.readBlogEntry(pagename);
                comments = page.getComments();
                date = page.getDate();
            }
            String commentMode = post.get("commentMode", "2");
            String StrSubject = post.get("subject", "");
            byte[] subject = UTF8.getBytes(StrSubject);
            sb.blogDB.writeBlogEntry(sb.blogDB.newEntry(pagename, subject, author, ip, date, content, comments, commentMode));
            if (!sb.isRobinsonMode()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("page", pagename);
                map.put("subject", StrSubject.replace(',', ' '));
                map.put("author", strAuthor.replace(',', ' '));
                sb.peers.newsPool.publishMyNews(sb.peers.mySeed(), "blog_add", map);
            }
        }
        page = sb.blogDB.readBlogEntry(pagename);
        if (post.containsKey("edit")) {
            if (hasRights) {
                prop.put("mode", "1");
                prop.put("mode_commentMode", page.getCommentMode());
                prop.putHTML("mode_author", UTF8.String(page.getAuthor()));
                prop.put("mode_pageid", page.getKey());
                prop.putHTML("mode_subject", UTF8.String(page.getSubject()));
                prop.put("mode_page-code", UTF8.String(page.getPage()));
            } else {
                prop.put("mode", "3");
            }
        } else if (post.containsKey("preview")) {
            if (hasRights) {
                prop.put("mode", "2");
                prop.put("mode_commentMode", post.getInt("commentMode", 2));
                prop.putHTML("mode_pageid", pagename);
                prop.putHTML("mode_author", UTF8.String(author));
                prop.putHTML("mode_subject", post.get("subject", ""));
                prop.put("mode_date", Blog.dateString(new Date()));
                prop.putWiki("mode_page", post.get("content", ""));
                prop.putHTML("mode_page-code", post.get("content", ""));
            } else {
                prop.put("mode", "3");
            }
        } else if ("try".equals(post.get("delete", ""))) {
            if (hasRights) {
                prop.put("mode", "4");
                prop.putHTML("mode_pageid", pagename);
                prop.putHTML("mode_author", UTF8.String(page.getAuthor()));
                prop.putHTML("mode_subject", UTF8.String(page.getSubject()));
            } else {
                prop.put("mode", "3");
            }
        } else if (post.containsKey("import")) {
            prop.put("mode", "5");
            prop.put("mode_state", "0");
        } else if (post.containsKey("xmlfile")) {
            prop.put("mode", "5");
            if (sb.blogDB.importXML(post.getInputStream("xmlfile$file"))) {
                prop.put("mode_state", "1");
            } else {
                prop.put("mode_state", "2");
            }
        } else {
            prop.put("mode", "0");
            if (DEFAULT_PAGE.equals(pagename)) {
                prop.putHTML("peername", sb.peers.mySeed().getName());
                prop.put("context", context);
                Blog.putBlogDefault(prop, sb, context, start, num, hasRights, xml);
            } else {
                prop.put("mode_entries", "1");
                Blog.putBlogEntry(prop, page, context, 0, hasRights, xml);
            }
        }
        return prop;
    }

    private static serverObjects putBlogDefault(serverObjects prop, Switchboard switchboard, String context, int start, int num, boolean hasRights, boolean xml) {
        Iterator<String> i = switchboard.blogDB.getBlogIterator(false);
        int count = 0;
        if (xml) {
            num = 0;
        }
        int nextstart = start + num;
        int prevstart = start - num;
        while (i.hasNext() && (num == 0 || num > count)) {
            if (0 < start--) continue;
            Blog.putBlogEntry(prop, switchboard.blogDB.readBlogEntry(i.next()), context, count++, hasRights, xml);
        }
        prop.put("mode_entries", count);
        if (i.hasNext()) {
            prop.put("mode_moreentries", "1");
            prop.put("mode_moreentries_start", nextstart);
            prop.put("mode_moreentries_num", num);
        } else {
            prop.put("moreentries", "0");
        }
        if (start > 0) {
            prop.put("mode_preventries", "1");
            if (prevstart < 0) {
                prevstart = 0;
            }
            prop.put("mode_preventries_start", prevstart);
            prop.put("mode_preventries_num", num);
        } else {
            prop.put("mode_preventries", "0");
        }
        return prop;
    }

    private static serverObjects putBlogEntry(serverObjects prop, BlogBoard.BlogEntry entry2, String context, int number, boolean hasRights, boolean xml) {
        prop.putHTML("mode_entries_" + number + "_subject", UTF8.String(entry2.getSubject()));
        prop.putHTML("mode_entries_" + number + "_author", UTF8.String(entry2.getAuthor()));
        if (entry2.getCommentMode() == 0) {
            prop.put("mode_entries_" + number + "_commentsactive", "0");
        } else {
            prop.put("mode_entries_" + number + "_commentsactive", "1");
            prop.put("mode_entries_" + number + "_commentsactive_pageid", entry2.getKey());
            prop.put("mode_entries_" + number + "_commentsactive_context", context);
            prop.put("mode_entries_" + number + "_commentsactive_comments", entry2.getCommentsSize());
        }
        prop.put("mode_entries_" + number + "_date", Blog.dateString(entry2.getDate()));
        prop.put("mode_entries_" + number + "_rfc822date", HeaderFramework.formatRFC1123(entry2.getDate()));
        prop.put("mode_entries_" + number + "_pageid", entry2.getKey());
        prop.put("mode_entries_" + number + "_context", context);
        prop.put("mode_entries_" + number + "_ip", entry2.getIp());
        if (xml) {
            prop.put("mode_entries_" + number + "_page", entry2.getPage());
            prop.put("mode_entries_" + number + "_timestamp", entry2.getTimestamp());
        } else {
            prop.putWiki("mode_entries_" + number + "_page", entry2.getPage());
        }
        if (hasRights) {
            prop.put("mode_entries_" + number + "_admin", "1");
            prop.put("mode_entries_" + number + "_admin_pageid", entry2.getKey());
        } else {
            prop.put("mode_entries_" + number + "_admin", "0");
        }
        return prop;
    }
}

