/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.gui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.yacy.kelondro.util.MemoryControl;

public class Audio {
    private static final String path = "htroot/env/soundclips/";

    public static void main(String[] args) {
        try {
            Soundclip.dhtin.playExperimental();
            Thread.sleep(100L);
            Soundclip.newdoc.play(-20.0f);
            Thread.sleep(500L);
            Soundclip.newdoc.play(-20.0f);
            Thread.sleep(500L);
            Soundclip.newdoc.play(-20.0f);
            Thread.sleep(500L);
            Soundclip.remotesearch.start();
            Thread.sleep(1000L);
            Soundclip.remotesearch.stop();
            Thread.sleep(1000L);
            Soundclip.remotesearch.start();
            Thread.sleep(1000L);
            Soundclip.remotesearch.stop();
            Thread.sleep(1000L);
            Soundclip.remotesearch.start();
            Thread.sleep(1000L);
            Soundclip.remotesearch.stop();
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            System.out.println("Error playing sound: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static enum Soundclip {
        dhtin("dhtin.wav"),
        newdoc("newdoc.wav"),
        remotesearch("remotesearch.wav");

        public final String filename;
        private Clip clip;
        private AudioFormat aisFormat;
        private byte[] data;

        private Soundclip(String filename) {
            this.filename = filename;
            this.clip = null;
            this.aisFormat = null;
            this.data = null;
        }

        private Clip getClip() {
            if ("true".equals(System.getProperty("java.awt.headless"))) {
                return null;
            }
            if (this.clip != null && this.clip.isOpen()) {
                return this.clip;
            }
            if (this.clip == null || !this.clip.isOpen()) {
                try {
                    Thread.sleep(1000L);
                    if (this.clip != null && this.clip.isOpen()) {
                        return this.clip;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.clip = this.getFreshClip();
            return this.clip;
        }

        private Clip getFreshClip() {
            if ("true".equals(System.getProperty("java.awt.headless"))) {
                return null;
            }
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new File(Audio.path + this.filename).getAbsoluteFile());
                Clip newclip = AudioSystem.getClip();
                newclip.open(audioInputStream);
                return newclip;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            }
            catch (IOException iOException) {
            }
            catch (LineUnavailableException lineUnavailableException) {
                // empty catch block
            }
            return null;
        }

        public void start() {
            Clip clip = this.getClip();
            if (clip == null || clip.isActive()) {
                return;
            }
            BooleanControl muteControl = (BooleanControl)clip.getControl(BooleanControl.Type.MUTE);
            FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            gainControl.setValue(-80.0f);
            clip.loop(-1);
            for (float gain = -30.0f; gain < 0.0f; gain += 6.0f) {
                try {
                    muteControl.setValue(true);
                    gainControl.setValue(gain);
                    muteControl.setValue(false);
                    Thread.sleep(600L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void stop() {
            Clip clip = this.getClip();
            if (clip == null || !clip.isActive()) {
                return;
            }
            BooleanControl muteControl = (BooleanControl)clip.getControl(BooleanControl.Type.MUTE);
            FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            for (float gain = 0.0f; gain > -30.0f; gain -= 6.0f) {
                try {
                    muteControl.setValue(true);
                    gainControl.setValue(gain);
                    muteControl.setValue(false);
                    Thread.sleep(600L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            clip.stop();
            clip.flush();
        }

        public void play(float gain) {
            Clip clip = this.getClip();
            if (clip == null) {
                return;
            }
            if (clip.isActive()) {
                if (!MemoryControl.shortStatus()) {
                    try {
                        Clip onetimeclip = this.getFreshClip();
                        FloatControl gainControl = (FloatControl)onetimeclip.getControl(FloatControl.Type.MASTER_GAIN);
                        gainControl.setValue(gain);
                        onetimeclip.start();
                    }
                    catch (OutOfMemoryError onetimeclip) {}
                }
            } else {
                FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                gainControl.setValue(gain);
                clip.setFramePosition(0);
                clip.start();
            }
        }

        public void playExperimental() throws IOException {
            this.ensureLoaded();
            try {
                SourceDataLine line = AudioSystem.getSourceDataLine(this.aisFormat);
                line.open(this.aisFormat);
                line.start();
                int frameSize = this.aisFormat.getFrameSize();
                for (int i = 0; i < this.data.length - frameSize * 100; i += frameSize * 100) {
                    line.write(this.data, i, frameSize * 100);
                }
                line.drain();
                line.close();
            }
            catch (LineUnavailableException e) {
                throw new IOException(e.getMessage());
            }
        }

        private void ensureLoaded() throws IOException {
            if (this.data != null) {
                return;
            }
            try {
                AudioInputStream ais = AudioSystem.getAudioInputStream(new File(Audio.path + this.filename));
                this.aisFormat = ais.getFormat();
                int rc = 0;
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((rc = ais.read(buffer, 0, buffer.length)) > 0) {
                    baos.write(buffer, 0, rc);
                }
                this.data = baos.toByteArray();
            }
            catch (UnsupportedAudioFileException e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

