/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.xml.ODContentHandler;
import net.yacy.document.parser.xml.ODMetaHandler;
import net.yacy.kelondro.io.CharBuffer;
import net.yacy.kelondro.util.FileUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class odtParser
extends AbstractParser
implements Parser {
    public static final int MAX_DOCSIZE = 0xC800000;
    private static final ThreadLocal<SAXParser> tlSax = new ThreadLocal();

    public odtParser() {
        super("OASIS OpenDocument V2 Text Document Parser");
        this.SUPPORTED_EXTENSIONS.add("odt");
        this.SUPPORTED_EXTENSIONS.add("ods");
        this.SUPPORTED_EXTENSIONS.add("odp");
        this.SUPPORTED_EXTENSIONS.add("odg");
        this.SUPPORTED_EXTENSIONS.add("odc");
        this.SUPPORTED_EXTENSIONS.add("odf");
        this.SUPPORTED_EXTENSIONS.add("odb");
        this.SUPPORTED_EXTENSIONS.add("odi");
        this.SUPPORTED_EXTENSIONS.add("odm");
        this.SUPPORTED_EXTENSIONS.add("ott");
        this.SUPPORTED_EXTENSIONS.add("ots");
        this.SUPPORTED_EXTENSIONS.add("otp");
        this.SUPPORTED_EXTENSIONS.add("otg");
        this.SUPPORTED_EXTENSIONS.add("sxw");
        this.SUPPORTED_EXTENSIONS.add("sxc");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.text");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.spreadsheet");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.presentation");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.graphics");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.chart");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.formula");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.database");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.image");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.text-master");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.text-template");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.spreadsheet-template");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.presentation-template");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.oasis.opendocument.graphics-template");
        this.SUPPORTED_MIME_TYPES.add("application/x-vnd.oasis.opendocument.text");
        this.SUPPORTED_MIME_TYPES.add("application/OOo-calc");
        this.SUPPORTED_MIME_TYPES.add("application/OOo-writer");
    }

    private static SAXParser getParser() throws SAXException {
        SAXParser parser = tlSax.get();
        if (parser == null) {
            try {
                parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
            tlSax.set(parser);
        }
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document[] parse(DigestURL location, String mimeType, String charset, File dest) throws Parser.Failure, InterruptedException {
        CharBuffer writer = null;
        try {
            String docDescription = null;
            String docKeywordStr = null;
            String docShortTitle = null;
            String docLongTitle = null;
            String docAuthor = null;
            String docLanguage = null;
            Date docModified = null;
            ZipFile zipFile = new ZipFile(dest);
            Enumeration<? extends ZipEntry> zipEnum = zipFile.entries();
            while (zipEnum.hasMoreElements()) {
                SAXParser saxParser;
                InputStream zipFileEntryStream;
                ZipEntry zipEntry = zipEnum.nextElement();
                String entryName = zipEntry.getName();
                if (entryName.equals("content.xml")) {
                    writer = new CharBuffer(0xC800000, (int)zipEntry.getSize());
                    zipFileEntryStream = zipFile.getInputStream(zipEntry);
                    try {
                        saxParser = odtParser.getParser();
                        saxParser.parse(zipFileEntryStream, (DefaultHandler)new ODContentHandler(writer));
                        continue;
                    }
                    finally {
                        zipFileEntryStream.close();
                        continue;
                    }
                }
                if (!entryName.equals("meta.xml")) continue;
                zipFileEntryStream = zipFile.getInputStream(zipEntry);
                saxParser = odtParser.getParser();
                ODMetaHandler metaData = new ODMetaHandler();
                saxParser.parse(zipFileEntryStream, (DefaultHandler)metaData);
                docDescription = metaData.getDescription();
                docKeywordStr = metaData.getKeyword();
                docShortTitle = metaData.getTitle();
                docLongTitle = metaData.getSubject();
                docAuthor = metaData.getCreator();
                docLanguage = metaData.getLanguage();
                docModified = metaData.getLastModified();
            }
            zipFile.close();
            HashSet<String> languages = new HashSet<String>(1);
            if (docLanguage != null) {
                languages.add(docLanguage);
            }
            if (docLongTitle == null && docShortTitle != null) {
                docLongTitle = docShortTitle;
            }
            String[] docKeywords = null;
            if (docKeywordStr != null) {
                docKeywords = docKeywordStr.split(" |,");
            }
            Document[] docs = null;
            byte[] contentBytes = writer == null ? null : UTF8.getBytes(writer.toString());
            ArrayList<String> descriptions = new ArrayList<String>();
            if (docDescription != null && docDescription.length() > 0) {
                descriptions.add(docDescription);
            }
            docs = new Document[]{new Document(location, mimeType, StandardCharsets.UTF_8.name(), this, languages, docKeywords, odtParser.singleList(docLongTitle), docAuthor, "", null, descriptions, 0.0, 0.0, contentBytes, null, null, null, false, docModified)};
            return docs;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof Parser.Failure) {
                throw (Parser.Failure)e;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Parser.Failure("Unexpected error while parsing odt file. " + e.getMessage(), location);
        }
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        File dest = null;
        try {
            dest = File.createTempFile("OpenDocument", ".odt");
            FileUtils.copy(source, dest);
            Document[] documentArray = this.parse(location, mimeType, charset, dest);
            return documentArray;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof Parser.Failure) {
                throw (Parser.Failure)e;
            }
            throw new Parser.Failure("Unexpected error while parsing odt file. " + e.getMessage(), location);
        }
        finally {
            if (dest != null) {
                FileUtils.deletedelete(dest);
            }
        }
    }
}

