/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.yacy.cora.util.StreamLimitException;
import net.yacy.kelondro.util.Formatter;

public class StrictLimitInputStream
extends FilterInputStream {
    private final long maxBytes;
    private long position = 0L;
    private long mark = -1L;
    private final String limitErrorMessage;

    public StrictLimitInputStream(InputStream inStream, long maxBytes) {
        this(inStream, maxBytes, Formatter.bytesToString(maxBytes) + " limit has been reached");
    }

    public StrictLimitInputStream(InputStream inStream, long maxBytes, String limitErrorMessage) {
        super(inStream);
        if (inStream == null) {
            throw new IllegalArgumentException("inStream parameter must not be null");
        }
        if (maxBytes < 0L) {
            throw new IllegalArgumentException("maxBytes parameter must be greater or equals to zero");
        }
        this.maxBytes = maxBytes;
        this.limitErrorMessage = limitErrorMessage;
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.maxBytes) {
            throw new StreamLimitException(this.limitErrorMessage);
        }
        int result = this.in.read();
        ++this.position;
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException, StreamLimitException {
        if (this.position >= this.maxBytes) {
            throw new StreamLimitException(this.limitErrorMessage);
        }
        long maxToRead = Math.min((long)len, this.maxBytes - this.position);
        int nbRead = this.in.read(b, off, (int)maxToRead);
        if (nbRead > 0) {
            this.position += (long)nbRead;
        }
        return nbRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.position >= this.maxBytes) {
            throw new StreamLimitException(this.limitErrorMessage);
        }
        long toSkip = Math.min(n, this.maxBytes - this.position);
        long nbSkipped = this.in.skip(toSkip);
        this.position += nbSkipped;
        return nbSkipped;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.position = this.mark;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.position;
    }
}

