/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.TimeoutRequest;
import net.yacy.cora.protocol.ftp.FTPClient;
import net.yacy.cora.protocol.http.HTTPClient;

public class Scanner {
    private static final Map<Service, Access> scancache = new ConcurrentHashMap<Service, Access>();
    private final Map<Service, Access> services = Collections.synchronizedMap(new HashMap());
    private final ThreadPoolExecutor threadPool;
    private final int timeout;

    public static int scancacheSize() {
        return scancache.size();
    }

    public static void scancacheReplace(Scanner newScanner) {
        scancache.clear();
        scancache.putAll(newScanner.services());
    }

    public static void scancacheExtend(Scanner newScanner) {
        Iterator<Map.Entry<Service, Access>> i = scancache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Service, Access> entry2 = i.next();
            if (entry2.getValue() == Access.granted) continue;
            i.remove();
        }
        scancache.putAll(newScanner.services());
    }

    public static Iterator<Map.Entry<Service, Access>> scancacheEntries() {
        return scancache.entrySet().iterator();
    }

    public static boolean acceptURL(MultiProtocolURL url) {
        if (scancache == null || scancache.isEmpty()) {
            return true;
        }
        InetAddress a = url.getInetAddress();
        if (a == null) {
            return true;
        }
        for (Map.Entry<Service, Access> entry2 : scancache.entrySet()) {
            Service service = entry2.getKey();
            if (!service.inetAddress.equals(a) || !service.protocol.toString().equals(url.getProtocol())) continue;
            Access access = entry2.getValue();
            if (access == null) {
                return false;
            }
            return access == Access.granted;
        }
        return true;
    }

    public Scanner(int concurrentRunner, int timeout) {
        this.threadPool = new ThreadPoolExecutor(concurrentRunner, concurrentRunner, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.timeout = timeout;
    }

    public int pending() {
        return this.threadPool.getQueue().size() + this.threadPool.getActiveCount();
    }

    public void terminate() {
        this.threadPool.shutdown();
    }

    public void addProtocols(List<InetAddress> addresses, boolean http, int httpPort, boolean https, int httpsPort, boolean ftp, boolean smb) {
        if (http) {
            this.addProtocol(Protocol.http.setPort(httpPort, httpPort == Protocol.http.port), addresses);
        }
        if (https) {
            this.addProtocol(Protocol.https.setPort(httpsPort, httpsPort == Protocol.https.port), addresses);
        }
        if (ftp) {
            this.addProtocol(Protocol.ftp, addresses);
        }
        if (smb) {
            this.addProtocol(Protocol.smb, addresses);
        }
    }

    public void addProtocol(Protocol protocol, List<InetAddress> addresses) {
        for (InetAddress i : addresses) {
            this.threadPool.execute(new Service(protocol, i));
        }
    }

    public static final List<InetAddress> genlist(Collection<InetAddress> base, int subnet) {
        ArrayList<InetAddress> c = new ArrayList<InetAddress>(1);
        for (InetAddress i : base) {
            Scanner.genlist(c, i, subnet);
        }
        return c;
    }

    public static final List<InetAddress> genlist(InetAddress base, int subnet) {
        ArrayList<InetAddress> c = new ArrayList<InetAddress>(1);
        Scanner.genlist(c, base, subnet);
        return c;
    }

    private static final void genlist(ArrayList<InetAddress> c, InetAddress base, int subnet) {
        if (subnet == 31) {
            try {
                c.add(InetAddress.getByAddress(base.getAddress()));
            }
            catch (UnknownHostException unknownHostException) {}
        } else {
            int br;
            int ul = subnet >= 24 ? base.getAddress()[2] : (1 << 24 - subnet) - 1;
            int n = br = subnet >= 24 ? base.getAddress()[2] : 0;
            while (br <= ul) {
                for (int j = 1; j < 255; ++j) {
                    byte[] address = base.getAddress();
                    address[2] = (byte)br;
                    address[3] = (byte)j;
                    try {
                        c.add(InetAddress.getByAddress(address));
                        continue;
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                ++br;
            }
        }
    }

    public Map<Service, Access> services() {
        return this.services;
    }

    public static byte[] inIndex(Map<byte[], String> commentCache, String url) {
        for (Map.Entry<byte[], String> comment : commentCache.entrySet()) {
            if (!comment.getValue().contains(url)) continue;
            return comment.getKey();
        }
        return null;
    }

    public static Set<String> scanForOtherYaCyInIntranet() {
        Set<InetAddress> in = Domains.myIPv4IntranetNonLocalhostIPs();
        List<InetAddress> myaddresses = Scanner.genlist(in, 20);
        myaddresses.removeAll(in);
        Scanner scanner = new Scanner(100, 1000);
        scanner.addProtocol(Protocol.http.setPort(8090, false), myaddresses);
        while (scanner.pending() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        scanner.terminate();
        Set<String> urls2 = Collections.newSetFromMap(new ConcurrentHashMap());
        scanner.services().keySet().forEach(service -> {
            String urlstub = service.toString();
            boolean notMy = true;
            for (InetAddress a : in) {
                if (urlstub.indexOf(a.getHostAddress()) < 0) continue;
                notMy = false;
            }
            if (notMy) {
                urls2.add(urlstub);
            }
        });
        return urls2;
    }

    public static void main(String[] args) {
        System.out.println("collecting addresses");
        Set<InetAddress> in = Domains.myIPv4IntranetNonLocalhostIPs();
        System.out.println("found " + in.size() + " intranet addresses");
        for (InetAddress a : in) {
            System.out.println("intranet address:" + a.getHostAddress());
        }
        List<InetAddress> addresses = Scanner.genlist(in, 20);
        System.out.println();
        System.out.println("scanner start with " + addresses.size() + " addresses");
        long time = System.currentTimeMillis();
        Scanner scanner = new Scanner(100, 1000);
        scanner.addProtocol(Protocol.http.setPort(8090, false), addresses);
        while (scanner.pending() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        scanner.terminate();
        for (Service service : scanner.services().keySet()) {
            System.out.println("PING successful: " + service.toString());
        }
        try {
            HTTPClient.closeConnectionManager();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        time = System.currentTimeMillis() - time;
        System.out.println("scanner terminated after " + time / 1000L + " seconds, " + (long)(1000 * addresses.size()) / time + " addresses per second");
        System.exit(0);
    }

    public static enum Access {
        unknown,
        empty,
        granted,
        denied;

    }

    public class Service
    implements Runnable {
        public Protocol protocol;
        public InetAddress inetAddress;
        private String hostname;
        private final long starttime;

        public Service(Protocol protocol, InetAddress inetAddress) {
            this.protocol = protocol;
            this.inetAddress = inetAddress;
            this.hostname = null;
            this.starttime = System.currentTimeMillis();
        }

        public Service(String protocol, InetAddress inetAddress) {
            this.protocol = protocol.equals("http") ? Protocol.http : (protocol.equals("https") ? Protocol.https : (protocol.equals("ftp") ? Protocol.ftp : Protocol.smb));
            this.inetAddress = inetAddress;
            this.hostname = null;
            this.starttime = System.currentTimeMillis();
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public InetAddress getInetAddress() {
            return this.inetAddress;
        }

        public String getHostName() {
            if (this.hostname != null) {
                if (this.hostname.equals(this.inetAddress.getHostAddress())) {
                    if (System.currentTimeMillis() / 1000L % 10L != 1L) {
                        return this.hostname;
                    }
                } else {
                    return this.hostname;
                }
            }
            try {
                this.hostname = TimeoutRequest.getHostName(this.inetAddress, 100L);
                Domains.setHostName(this.inetAddress, this.hostname);
            }
            catch (ExecutionException e) {
                this.hostname = this.inetAddress.getHostAddress();
            }
            return this.hostname;
        }

        public DigestURL url() throws MalformedURLException {
            return new DigestURL(this.protocol.name() + "://" + this.getHostName() + "/");
        }

        public String toString() {
            try {
                return new MultiProtocolURL(this.protocol.name() + "://" + this.inetAddress.getHostAddress() + this.protocol.portSuffix() + "/").toNormalform(true);
            }
            catch (MalformedURLException e) {
                return "";
            }
        }

        public int hashCode() {
            return (this.inetAddress.toString() + ":" + this.protocol.port).hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Service && ((Service)o).protocol == this.protocol && ((Service)o).inetAddress.equals(this.inetAddress);
        }

        @Override
        public void run() {
            block10: {
                try {
                    Thread.currentThread().setName("Scanner.Runner: Ping to " + this.getInetAddress().getHostAddress() + ":" + this.getProtocol().port);
                    if (!TimeoutRequest.ping(this.getInetAddress().getHostAddress(), this.getProtocol().port, Scanner.this.timeout)) break block10;
                    Access access = this.getProtocol() == Protocol.http || this.getProtocol() == Protocol.https ? Access.granted : Access.unknown;
                    Scanner.this.services.put(this, access);
                    if (access == Access.unknown) {
                        Object list2;
                        if (this.getProtocol() == Protocol.ftp) {
                            FTPClient ftpClient = new FTPClient();
                            try {
                                ftpClient.open(this.getInetAddress().getHostAddress(), this.getProtocol().port);
                                ftpClient.login("anonymous", "anomic@");
                                list2 = ftpClient.list("/", false);
                                ftpClient.CLOSE();
                                access = list2 == null || list2.isEmpty() ? Access.empty : Access.granted;
                            }
                            catch (IOException e) {
                                access = Access.denied;
                            }
                        }
                        if (this.getProtocol() == Protocol.smb) {
                            try {
                                MultiProtocolURL uri = new MultiProtocolURL(this.toString());
                                list2 = uri.list();
                                access = list2 == null || ((String[])list2).length == 0 ? Access.empty : Access.granted;
                            }
                            catch (IOException e) {
                                access = Access.denied;
                            }
                        }
                    }
                    if (access != Access.unknown) {
                        Scanner.this.services.put(this, access);
                    }
                }
                catch (OutOfMemoryError e) {
                    e.printStackTrace();
                }
            }
        }

        public long age() {
            return System.currentTimeMillis() - this.starttime;
        }
    }

    public static enum Protocol {
        http(80, true),
        https(443, true),
        ftp(21, true),
        smb(445, true);

        public int port;
        public boolean standard;

        private Protocol(int port, boolean standard) {
            this.port = port;
            this.standard = standard;
        }

        public Protocol setPort(int port, boolean standard) {
            this.port = port;
            this.standard = standard;
            return this;
        }

        public String portSuffix() {
            return this.standard ? "" : ":" + this.port;
        }
    }
}

