/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.geo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import net.yacy.cora.document.WordCache;
import net.yacy.cora.geo.GeoLocation;
import net.yacy.cora.geo.Locations;
import net.yacy.cora.geo.OverarchingLocation;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.StringBuilderComparator;

public class OpenGeoDBLocation
implements Locations {
    private final Map<Integer, GeoLocation> id2loc;
    private final TreeMap<StringBuilder, List<Integer>> name2ids;
    private final TreeMap<StringBuilder, List<Integer>> kfz2ids;
    private final Map<String, List<Integer>> predial2ids;
    private final Map<String, Integer> zip2id;
    private final File file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenGeoDBLocation(File file, WordCache dymLib) {
        this.file = file;
        this.id2loc = new HashMap<Integer, GeoLocation>();
        this.name2ids = new TreeMap(StringBuilderComparator.CASE_INSENSITIVE_ORDER);
        this.kfz2ids = new TreeMap(StringBuilderComparator.CASE_INSENSITIVE_ORDER);
        this.predial2ids = new HashMap<String, List<Integer>>();
        this.zip2id = new HashMap<String, Integer>();
        if (file == null || !file.exists()) {
            return;
        }
        InputStream is = null;
        BufferedReader reader = null;
        try {
            String line;
            is = new FileInputStream(file);
            if (file.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                List<Integer> l;
                String h;
                Integer id;
                String[] v;
                if (!(line = line.trim()).startsWith("INSERT INTO ") || !line.endsWith(");")) continue;
                if ((line = line.substring(12)).startsWith("geodb_coordinates ")) {
                    line = line.substring(25);
                    v = CommonPattern.COMMA.split(line);
                    float lat = Float.parseFloat(v[2]);
                    float lon = Float.parseFloat(v[3]);
                    this.id2loc.put(Integer.parseInt(v[0]), new GeoLocation(lat, lon));
                }
                if (!line.startsWith("geodb_textdata ")) continue;
                v = CommonPattern.COMMA.split(line = line.substring(22));
                if (v[1].equals("500100000")) {
                    if (v.length > 10) {
                        v[2] = v[2] + "," + v[3];
                    }
                    id = Integer.parseInt(v[0]);
                    h = OpenGeoDBLocation.removeQuotes(v[2]);
                    if (h.length() < OverarchingLocation.MINIMUM_NAME_LENGTH || dymLib != null && dymLib.contains(new StringBuilder(h))) continue;
                    l = this.name2ids.get(new StringBuilder(h));
                    if (l == null) {
                        l = new ArrayList<Integer>(1);
                    }
                    l.add(id);
                    this.name2ids.put(new StringBuilder(h), l);
                    GeoLocation loc = this.id2loc.get(id);
                    if (loc == null) continue;
                    loc.setName(h);
                    continue;
                }
                if (v[1].equals("500400000")) {
                    id = Integer.parseInt(v[0]);
                    h = OpenGeoDBLocation.removeQuotes(v[2]);
                    l = this.predial2ids.get(h);
                    if (l == null) {
                        l = new ArrayList<Integer>(1);
                    }
                    l.add(id);
                    this.predial2ids.put(h, l);
                    continue;
                }
                if (v[1].equals("400300000")) {
                    id = Integer.parseInt(v[0]);
                    h = OpenGeoDBLocation.removeQuotes(v[2]);
                    continue;
                }
                if (v[1].equals("500300000")) {
                    this.zip2id.put(OpenGeoDBLocation.removeQuotes(v[2]), Integer.parseInt(v[0]));
                    continue;
                }
                if (!v[1].equals("500500000")) continue;
                id = Integer.parseInt(v[0]);
                h = OpenGeoDBLocation.removeQuotes(v[2]);
                l = this.kfz2ids.get(new StringBuilder(h));
                if (l == null) {
                    l = new ArrayList<Integer>(1);
                }
                l.add(id);
                this.kfz2ids.put(new StringBuilder(h), l);
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            } else if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final String removeQuotes(String s) {
        if (s.length() > 0 && s.charAt(0) == '\'') {
            s = s.substring(1);
        }
        if (s.charAt(s.length() - 1) == '\'') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Override
    public int size() {
        return this.id2loc.size();
    }

    @Override
    public boolean isEmpty() {
        return this.id2loc.isEmpty();
    }

    @Override
    public TreeSet<GeoLocation> find(String anyname, boolean locationexact) {
        List<Integer> c;
        HashSet<Integer> r = new HashSet<Integer>();
        StringBuilder an = new StringBuilder(anyname);
        if (locationexact) {
            c = this.name2ids.get(an);
            if (c != null) {
                r.addAll(c);
            }
        } else {
            Integer i;
            SortedMap<StringBuilder, List<Integer>> cities = this.name2ids.tailMap(an);
            for (Map.Entry<StringBuilder, List<Integer>> entry2 : cities.entrySet()) {
                if (!StringBuilderComparator.CASE_INSENSITIVE_ORDER.startsWith(entry2.getKey(), an)) break;
                r.addAll((Collection)entry2.getValue());
            }
            c = this.kfz2ids.get(an);
            if (c != null) {
                r.addAll(c);
            }
            if ((c = this.predial2ids.get(anyname)) != null) {
                r.addAll(c);
            }
            if ((i = this.zip2id.get(anyname)) != null) {
                r.add(i);
            }
        }
        TreeSet<GeoLocation> a = new TreeSet<GeoLocation>();
        for (Integer n : r) {
            GeoLocation w = this.id2loc.get(n);
            if (w == null) continue;
            a.add(w);
        }
        return a;
    }

    @Override
    public Set<String> locationNames() {
        HashSet<String> locations = new HashSet<String>();
        Set<StringBuilder> l = this.name2ids.keySet();
        for (StringBuilder s : l) {
            locations.add(s.toString());
        }
        return locations;
    }

    @Override
    public Set<String> recommend(String s) {
        HashSet<String> a = new HashSet<String>();
        StringBuilder an = new StringBuilder(s);
        if (s.isEmpty()) {
            return a;
        }
        SortedMap<StringBuilder, List<Integer>> t = this.name2ids.tailMap(an);
        for (StringBuilder r : t.keySet()) {
            if (!StringBuilderComparator.CASE_INSENSITIVE_ORDER.startsWith(r, an)) break;
            a.add(r.toString());
        }
        return a;
    }

    @Override
    public Set<StringBuilder> recommend(StringBuilder s) {
        HashSet<StringBuilder> a = new HashSet<StringBuilder>();
        if (s.length() == 0) {
            return a;
        }
        SortedMap<StringBuilder, List<Integer>> t = this.name2ids.tailMap(s);
        for (StringBuilder r : t.keySet()) {
            if (!StringBuilderComparator.CASE_INSENSITIVE_ORDER.startsWith(r, s)) break;
            a.add(r);
        }
        return a;
    }

    @Override
    public String nickname() {
        return this.file.getName();
    }

    @Override
    public int hashCode() {
        return this.nickname().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Locations)) {
            return false;
        }
        return this.nickname().equals(((Locations)other).nickname());
    }
}

