/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.connector;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import net.yacy.cora.federate.solr.connector.AbstractSolrConnector;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.sorting.ReversibleScoreMap;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;

public class MirrorSolrConnector
extends AbstractSolrConnector
implements SolrConnector {
    private SolrConnector solr0;
    private SolrConnector solr1;

    public MirrorSolrConnector() {
        this.solr0 = null;
        this.solr1 = null;
    }

    public MirrorSolrConnector(SolrConnector solr0, SolrConnector solr1) {
        this.solr0 = solr0;
        this.solr1 = solr1;
    }

    public int hashCode() {
        return (this.solr0 == null ? 0 : this.solr0.hashCode()) + (this.solr1 == null ? 0 : this.solr1.hashCode());
    }

    public boolean equals(Object o) {
        return o instanceof MirrorSolrConnector && (this.solr0 == null && ((MirrorSolrConnector)o).solr0 == null || this.solr0 != null && ((MirrorSolrConnector)o).solr0 != null && this.solr0.equals(((MirrorSolrConnector)o).solr0)) && (this.solr1 == null && ((MirrorSolrConnector)o).solr1 == null || this.solr1 != null && ((MirrorSolrConnector)o).solr1 != null && this.solr1.equals(((MirrorSolrConnector)o).solr1));
    }

    @Override
    public int bufferSize() {
        int b = 0;
        if (this.solr0 != null) {
            b += this.solr0.bufferSize();
        }
        if (this.solr1 != null) {
            b += this.solr1.bufferSize();
        }
        return b;
    }

    @Override
    public void clearCaches() {
        if (this.solr0 != null) {
            this.solr0.clearCaches();
        }
        if (this.solr1 != null) {
            this.solr1.clearCaches();
        }
    }

    public boolean isConnected0() {
        return this.solr0 != null;
    }

    public void connect0(SolrConnector c) {
        this.solr0 = c;
    }

    public SolrConnector getSolr0() {
        return this.solr0;
    }

    public void disconnect0() {
        if (this.solr0 == null) {
            return;
        }
        this.solr0.close();
        this.solr0 = null;
    }

    public boolean isConnected1() {
        return this.solr1 != null;
    }

    public void connect1(SolrConnector c) {
        this.solr1 = c;
    }

    public SolrConnector getSolr1() {
        return this.solr1;
    }

    public void disconnect1() {
        if (this.solr1 == null) {
            return;
        }
        this.solr1.close();
        this.solr1 = null;
    }

    @Override
    public void commit(boolean softCommit) {
        if (this.solr0 != null) {
            this.solr0.commit(softCommit);
        }
        if (this.solr1 != null) {
            this.solr1.commit(softCommit);
        }
    }

    @Override
    public void optimize(int maxSegments) {
        if (this.solr0 != null) {
            this.solr0.optimize(maxSegments);
        }
        if (this.solr1 != null) {
            this.solr1.optimize(maxSegments);
        }
    }

    @Override
    public int getSegmentCount() {
        int s0 = this.solr0 == null ? 0 : this.solr0.getSegmentCount();
        int s1 = this.solr1 == null ? 0 : this.solr1.getSegmentCount();
        return Math.max(s0, s1);
    }

    @Override
    public boolean isClosed() {
        return !(this.solr0 != null && !this.solr0.isClosed() || this.solr1 != null && !this.solr1.isClosed());
    }

    @Override
    public synchronized void close() {
        if (this.solr0 != null) {
            this.solr0.close();
            this.solr0 = null;
        }
        if (this.solr1 != null) {
            this.solr1.close();
            this.solr1 = null;
        }
    }

    @Override
    public void clear() throws IOException {
        if (this.solr0 != null) {
            this.solr0.clear();
        }
        if (this.solr1 != null) {
            this.solr1.clear();
        }
    }

    @Override
    public void deleteById(String id) throws IOException {
        if (this.solr0 != null) {
            this.solr0.deleteById(id);
        }
        if (this.solr1 != null) {
            this.solr1.deleteById(id);
        }
    }

    @Override
    public void deleteByIds(Collection<String> ids) throws IOException {
        if (this.solr0 != null) {
            this.solr0.deleteByIds(ids);
        }
        if (this.solr1 != null) {
            this.solr1.deleteByIds(ids);
        }
    }

    @Override
    public void deleteByQuery(String querystring) throws IOException {
        if (this.solr0 != null) {
            this.solr0.deleteByQuery(querystring);
        }
        if (this.solr1 != null) {
            this.solr1.deleteByQuery(querystring);
        }
    }

    @Override
    public SolrDocument getDocumentById(String key, String ... fields) throws IOException {
        SolrDocument doc;
        assert (key.length() == 12) : "wrong id: " + key;
        if (this.solr0 != null && (doc = this.solr0.getDocumentById(key, fields)) != null || this.solr1 != null && (doc = this.solr1.getDocumentById(key, fields)) != null) {
            return doc;
        }
        return null;
    }

    @Override
    public void add(SolrInputDocument solrdoc) throws IOException {
        if (this.solr0 != null) {
            this.solr0.add(solrdoc);
        }
        if (this.solr1 != null) {
            this.solr1.add(solrdoc);
        }
    }

    @Override
    public void add(Collection<SolrInputDocument> solrdocs) throws IOException, SolrException {
        if (this.solr0 != null) {
            this.solr0.add(solrdocs);
        }
        if (this.solr1 != null) {
            this.solr1.add(solrdocs);
        }
    }

    @Override
    public SolrDocumentList getDocumentListByQuery(String querystring, String sort, int offset, int count, String ... fields) throws IOException {
        if (this.solr0 == null && this.solr1 == null) {
            return new SolrDocumentList();
        }
        if (offset == 0 && count == 1 && querystring.startsWith("id:") && (querystring.length() == 17 && querystring.charAt(3) == '\"' && querystring.charAt(16) == '\"' || querystring.length() == 15)) {
            SolrDocumentList list2 = new SolrDocumentList();
            SolrDocument doc = this.getDocumentById(querystring.charAt(3) == '\"' ? querystring.substring(4, querystring.length() - 1) : querystring.substring(3), fields);
            list2.add((Object)doc);
            return list2;
        }
        if (this.solr0 != null && this.solr1 == null) {
            SolrDocumentList list3 = this.solr0.getDocumentListByQuery(querystring, sort, offset, count, fields);
            return list3;
        }
        if (this.solr1 != null && this.solr0 == null) {
            SolrDocumentList list4 = this.solr1.getDocumentListByQuery(querystring, sort, offset, count, fields);
            return list4;
        }
        SolrDocumentList l = this.solr0.getDocumentListByQuery(querystring, sort, offset, count, fields);
        if (l.size() >= count) {
            return l;
        }
        int size0 = 0;
        SolrDocumentList lHack = this.solr0.getDocumentListByQuery(querystring, sort, 0, Integer.MAX_VALUE, fields);
        size0 = lHack.size();
        SolrDocumentList list5 = new SolrDocumentList();
        for (SolrDocument d : l) {
            list5.add((Object)d);
        }
        l = this.solr1.getDocumentListByQuery(querystring, sort, offset + l.size() - size0, count - l.size(), fields);
        for (SolrDocument d : l) {
            list5.add((Object)d);
        }
        return list5;
    }

    @Override
    public QueryResponse getResponseByParams(ModifiableSolrParams query2) throws IOException, SolrException {
        int start;
        Integer count0 = query2.getInt("rows");
        int count = count0 == null ? 10 : count0;
        Integer start0 = query2.getInt("start");
        int n = start = start0 == null ? 0 : start0;
        if (this.solr0 == null && this.solr1 == null) {
            return new QueryResponse();
        }
        if (this.solr0 != null && this.solr1 == null) {
            QueryResponse list2 = this.solr0.getResponseByParams(query2);
            return list2;
        }
        if (this.solr1 != null && this.solr0 == null) {
            QueryResponse list3 = this.solr1.getResponseByParams(query2);
            return list3;
        }
        QueryResponse rsp = this.solr0.getResponseByParams(query2);
        SolrDocumentList l = rsp.getResults();
        if (l.size() >= count) {
            return rsp;
        }
        int size0 = 0;
        query2.set("start", 0);
        query2.set("rows", Integer.MAX_VALUE);
        QueryResponse lHack = this.solr0.getResponseByParams(query2);
        query2.set("start", start);
        query2.set("rows", count);
        size0 = lHack.getResults().size();
        query2.set("start", start + l.size() - size0);
        query2.set("rows", count - l.size());
        QueryResponse rsp1 = this.solr1.getResponseByParams(query2);
        query2.set("start", start);
        query2.set("rows", count);
        return rsp1;
    }

    @Override
    public SolrDocumentList getDocumentListByParams(ModifiableSolrParams query2) throws IOException, SolrException {
        int start;
        Integer count0 = query2.getInt("rows");
        int count = count0 == null ? 10 : count0;
        Integer start0 = query2.getInt("start");
        int n = start = start0 == null ? 0 : start0;
        if (this.solr0 == null && this.solr1 == null) {
            return new SolrDocumentList();
        }
        if (this.solr0 != null && this.solr1 == null) {
            SolrDocumentList list2 = this.solr0.getDocumentListByParams(query2);
            return list2;
        }
        if (this.solr1 != null && this.solr0 == null) {
            SolrDocumentList list3 = this.solr1.getDocumentListByParams(query2);
            return list3;
        }
        SolrDocumentList l = this.solr0.getDocumentListByParams(query2);
        if (l.size() >= count) {
            return l;
        }
        int size0 = 0;
        query2.set("start", 0);
        query2.set("rows", Integer.MAX_VALUE);
        SolrDocumentList lHack = this.solr0.getDocumentListByParams(query2);
        query2.set("start", start);
        query2.set("rows", count);
        size0 = lHack.size();
        query2.set("start", start + l.size() - size0);
        query2.set("rows", count - l.size());
        SolrDocumentList l1 = this.solr1.getDocumentListByParams(query2);
        query2.set("start", start);
        query2.set("rows", count);
        return l1;
    }

    @Override
    public long getCountByQuery(final String querystring) throws IOException {
        if (this.solr0 == null && this.solr1 == null) {
            return 0L;
        }
        if (this.solr0 != null && this.solr1 == null) {
            return this.solr0.getCountByQuery(querystring);
        }
        if (this.solr1 != null && this.solr0 == null) {
            return this.solr1.getCountByQuery(querystring);
        }
        final AtomicLong count = new AtomicLong(0L);
        Thread t0 = new Thread(this, "MirrorSolrConnector.getCountByQuery/t0"){
            final /* synthetic */ MirrorSolrConnector this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void run() {
                try {
                    count.addAndGet(this.this$0.solr0.getCountByQuery(querystring));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t0.start();
        Thread t1 = new Thread(this, "MirrorSolrConnector.getCountByQuery/t1"){
            final /* synthetic */ MirrorSolrConnector this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void run() {
                try {
                    count.addAndGet(this.this$0.solr1.getCountByQuery(querystring));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t1.start();
        try {
            t0.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            t1.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return count.get();
    }

    @Override
    public LinkedHashMap<String, ReversibleScoreMap<String>> getFacets(String query2, int maxresults, String ... fields) throws IOException {
        if (this.solr0 == null && this.solr1 == null) {
            return new LinkedHashMap<String, ReversibleScoreMap<String>>(0);
        }
        if (this.solr0 != null && this.solr1 == null) {
            return this.solr0.getFacets(query2, maxresults, fields);
        }
        if (this.solr1 != null && this.solr0 == null) {
            return this.solr1.getFacets(query2, maxresults, fields);
        }
        LinkedHashMap<String, ReversibleScoreMap<String>> facets0 = this.solr0.getFacets(query2, maxresults, fields);
        LinkedHashMap<String, ReversibleScoreMap<String>> facets1 = this.solr1.getFacets(query2, maxresults, fields);
        for (Map.Entry<String, ReversibleScoreMap<String>> facet0 : facets0.entrySet()) {
            ReversibleScoreMap facet1 = (ReversibleScoreMap)facets1.remove(facet0.getKey());
            if (facet1 == null) continue;
            for (String key : facet1) {
                facet0.getValue().inc(key, facet1.get(key));
            }
        }
        for (Map.Entry<String, ReversibleScoreMap<String>> facet1 : facets1.entrySet()) {
            facets0.put(facet1.getKey(), facet1.getValue());
        }
        return facets0;
    }

    @Override
    public long getSize() {
        long s = 0L;
        if (this.solr0 != null) {
            s += this.solr0.getSize();
        }
        if (this.solr1 != null) {
            s += this.solr1.getSize();
        }
        return s;
    }

    @Override
    public boolean exists(String id) {
        boolean result = false;
        if (this.solr0 != null) {
            boolean bl = result = result || this.solr0.exists(id);
        }
        if (this.solr1 != null) {
            result = result || this.solr1.exists(id);
        }
        return result;
    }

    @Override
    public BlockingQueue<String> concurrentIDsByQuery(String querystring, String sort, int offset, int maxcount, long maxtime, int buffersize, int concurrency) {
        if (this.solr0 != null && this.solr1 == null) {
            return this.solr0.concurrentIDsByQuery(querystring, sort, offset, maxcount, maxtime, buffersize, concurrency);
        }
        if (this.solr0 == null && this.solr1 != null) {
            return this.solr1.concurrentIDsByQuery(querystring, sort, offset, maxcount, maxtime, buffersize, concurrency);
        }
        return super.concurrentIDsByQuery(querystring, sort, offset, maxcount, maxtime, buffersize, concurrency);
    }
}

