/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.connector;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.sorting.ClusteredScoreMap;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.LookAheadIterator;
import net.yacy.search.schema.CollectionSchema;
import org.apache.lucene.document.Document;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.ModifiableSolrParams;

public abstract class AbstractSolrConnector
implements SolrConnector {
    protected static Set<String> SOLR_ID_FIELDS = new HashSet<String>();
    protected static Set<String> SOLR_ID_and_LOAD_DATE_FIELDS = new HashSet<String>();
    public static final SolrDocument POISON_DOCUMENT;
    public static final String POISON_ID = "POISON_ID";
    public static final String CATCHALL_TERM = "[* TO *]";
    public static final String CATCHALL_DTERM = ":[* TO *]";
    public static final String CATCHALL_QUERY = "*:*";
    public static final SolrQuery catchallQuery;
    public static final SolrQuery catchSuccessQuery;
    protected static final int pagesize_docs = 100;
    protected static final int pagesize_ids = 1000;

    protected static String getURL(Object doc) {
        if (doc == null) {
            return null;
        }
        String url = null;
        if (doc instanceof SolrInputDocument) {
            url = (String)((SolrInputDocument)doc).getFieldValue(CollectionSchema.sku.getSolrFieldName());
        }
        if (doc instanceof SolrDocument) {
            url = (String)((SolrDocument)doc).getFieldValue(CollectionSchema.sku.getSolrFieldName());
        }
        if (doc instanceof Document) {
            url = ((Document)doc).get(CollectionSchema.sku.getSolrFieldName());
        }
        if (url == null) {
            return null;
        }
        return url;
    }

    protected static String[] ensureEssentialFieldsIncluded(String[] fields) {
        if (fields != null && fields.length > 0) {
            HashSet<String> f = new HashSet<String>();
            for (String s : fields) {
                f.add(s);
            }
            f.add(CollectionSchema.id.getSolrFieldName());
            f.add(CollectionSchema.load_date_dt.getSolrFieldName());
            fields = f.toArray(new String[f.size()]);
        }
        return fields;
    }

    @Override
    public BlockingQueue<SolrDocument> concurrentDocumentsByQuery(String querystring, String sort, int offset, int maxcount, long maxtime, int buffersize, int concurrency, boolean prefetchIDs, String ... fields) {
        ArrayList<String> querystrings = new ArrayList<String>(1);
        querystrings.add(querystring);
        return this.concurrentDocumentsByQueries(querystrings, sort, offset, maxcount, maxtime, buffersize, concurrency, prefetchIDs, fields);
    }

    @Override
    public BlockingQueue<SolrDocument> concurrentDocumentsByQueries(List<String> querystrings, String sort, int offset, int maxcount, long maxtime, int buffersize, int concurrency, boolean prefetchIDs, final String ... fields) {
        LinkedBlockingQueue<SolrDocument> queue;
        AbstractQueue abstractQueue = queue = buffersize <= 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(Math.max(buffersize, concurrency));
        if (!prefetchIDs) {
            Thread t = new Thread(this.newDocumentsByQueriesTask(queue, querystrings, sort, offset, maxcount, maxtime, buffersize, concurrency, fields));
            t.start();
            return queue;
        }
        final BlockingQueue<String> idQueue = this.concurrentIDsByQueries(querystrings, sort, offset, maxcount, maxtime, Math.min(maxcount, 10000000), concurrency);
        final long endtime = maxtime < 0L || maxtime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + maxtime;
        Thread[] t = new Thread[concurrency];
        for (int i = 0; i < Math.max(1, concurrency); ++i) {
            t[i] = new Thread(this, "AbstractSolrConnector:concurrentDocumentsByQueriesWithPrefetch(" + querystrings.size() + " queries, first: " + querystrings.iterator().next() + ")"){
                final /* synthetic */ AbstractSolrConnector this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void run() {
                    block8: while (true) {
                        try {
                            String nextID;
                            while (System.currentTimeMillis() < endtime && (nextID = (String)idQueue.take()) != AbstractSolrConnector.POISON_ID) {
                                try {
                                    SolrDocument d = this.this$0.getDocumentById(nextID, fields);
                                    if (d == null) continue block8;
                                    try {
                                        queue.put(d);
                                        continue block8;
                                    }
                                    catch (InterruptedException interruptedException) {
                                    }
                                }
                                catch (IOException | SolrException e) {
                                    ConcurrentLog.logException(e);
                                    ConcurrentLog.severe("AbstractSolrConnector", "aborted concurrentDocumentsByQuery: " + e.getMessage());
                                    break block8;
                                }
                            }
                            break;
                        }
                        catch (InterruptedException e) {
                            ConcurrentLog.severe("AbstractSolrConnector", "interrupted concurrentDocumentsByQuery: " + e.getMessage());
                            break;
                        }
                    }
                    try {
                        queue.put(POISON_DOCUMENT);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            t[i].start();
        }
        return queue;
    }

    @Override
    public Runnable newDocumentsByQueriesTask(BlockingQueue<SolrDocument> queue, List<String> querystrings, String sort, int offset, int maxcount, long maxtime, int buffersize, int concurrency, String ... fields) {
        Objects.requireNonNull(queue, "The queue parameter must not be null.");
        if (querystrings == null || querystrings.isEmpty()) {
            return () -> {
                for (int i = 0; i < Math.max(1, concurrency); ++i) {
                    try {
                        queue.put(POISON_DOCUMENT);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                }
            };
        }
        long endtime = maxtime < 0L || maxtime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + maxtime;
        int ps = buffersize < 0 ? 100 : Math.min(100, buffersize);
        int maxretries = 6;
        return () -> {
            long remainingTime = endtime - System.currentTimeMillis();
            try {
                block18: for (String querystring : querystrings) {
                    Thread.currentThread().setName("AbstractSolrConnector:concurrentDocumentsByQueryNoPrefetch(" + querystring + ")");
                    int o = offset;
                    int count = 0;
                    int retry = 0;
                    while (remainingTime > 0L && count < maxcount) {
                        try {
                            SolrDocumentList sdl = this.getDocumentListByQuery(querystring, sort, o, Math.min(maxcount, ps), fields);
                            for (SolrDocument d : sdl) {
                                if (endtime != Long.MAX_VALUE) {
                                    if (!queue.offer(d, remainingTime, TimeUnit.MILLISECONDS)) {
                                        break;
                                    }
                                } else {
                                    queue.put(d);
                                }
                                ++count;
                            }
                            if (sdl.size() < ps) continue block18;
                            o += sdl.size();
                            retry = 0;
                        }
                        catch (InterruptedIOException e) {
                            throw new InterruptedException();
                        }
                        catch (IOException | SolrException e) {
                            ConcurrentLog.logException(e);
                            if (retry++ < 6) {
                                Thread.sleep(100L);
                                continue;
                            }
                            ConcurrentLog.severe("AbstractSolrConnector", "aborted concurrentDocumentsByQueryNoPrefetch after 6 retries: " + e.getMessage());
                            continue block18;
                        }
                        remainingTime = endtime - System.currentTimeMillis();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException e) {
                ConcurrentLog.logException(e);
            }
            finally {
                for (int i = 0; i < Math.max(1, concurrency); ++i) {
                    try {
                        queue.put(POISON_DOCUMENT);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        };
    }

    @Override
    public BlockingQueue<String> concurrentIDsByQuery(String querystring, String sort, int offset, int maxcount, long maxtime, int buffersize, int concurrency) {
        ArrayList<String> querystrings = new ArrayList<String>(1);
        querystrings.add(querystring);
        return this.concurrentIDsByQueries(querystrings, sort, offset, maxcount, maxtime, buffersize, concurrency);
    }

    @Override
    public BlockingQueue<String> concurrentIDsByQueries(final List<String> querystrings, final String sort, final int offset, final int maxcount, long maxtime, int buffersize, final int concurrency) {
        final LinkedBlockingQueue<String> queue = buffersize <= 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(buffersize);
        final long endtime = maxtime < 0L || maxtime == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + maxtime;
        Thread t = new Thread(this){
            final /* synthetic */ AbstractSolrConnector this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.setPriority(10);
                try {
                    block15: for (String querystring : querystrings) {
                        this.setName("AbstractSolrConnector:concurrentIDsByQueries(" + querystring + ")");
                        int o = offset;
                        while (System.currentTimeMillis() < endtime) {
                            try {
                                SolrDocumentList sdl = this.this$0.getDocumentListByQuery(querystring, sort, o, maxcount < 0 ? 1000 : Math.min(maxcount, 1000), CollectionSchema.id.getSolrFieldName());
                                int count = 0;
                                for (SolrDocument d : sdl) {
                                    try {
                                        queue.put((String)d.getFieldValue(CollectionSchema.id.getSolrFieldName()));
                                    }
                                    catch (InterruptedException e) {
                                        break;
                                    }
                                    ++count;
                                }
                                if (count < 1000) continue block15;
                                if ((o += count) <= maxcount || maxcount <= 0) continue;
                            }
                            catch (SolrException e) {
                            }
                            catch (IOException e) {}
                            continue block15;
                        }
                    }
                }
                catch (Throwable i) {
                    for (int i2 = 0; i2 < concurrency; ++i2) {
                        try {
                            queue.put(AbstractSolrConnector.POISON_ID);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    for (int i = 0; i < concurrency; ++i) {
                        try {
                            queue.put(AbstractSolrConnector.POISON_ID);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        };
        t.start();
        return queue;
    }

    @Override
    public Iterator<String> iterator() {
        final BlockingQueue<String> queue = this.concurrentIDsByQuery(CATCHALL_QUERY, null, 0, Integer.MAX_VALUE, 60000L, 2000, 1);
        return new LookAheadIterator<String>(this){
            final /* synthetic */ AbstractSolrConnector this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected String next0() {
                try {
                    String s = (String)queue.poll(60000L, TimeUnit.MILLISECONDS);
                    if (s == AbstractSolrConnector.POISON_ID) {
                        return null;
                    }
                    return s;
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
        };
    }

    @Override
    public SolrDocumentList getDocumentListByQuery(String querystring, String sort, int offset, int count, String ... fields) throws IOException {
        SolrQuery params = AbstractSolrConnector.getSolrQuery(querystring, sort, offset, count, fields);
        SolrDocumentList docs = this.getDocumentListByParams((ModifiableSolrParams)params);
        return docs;
    }

    public static SolrQuery getSolrQuery(String querystring, String sort, int offset, int count, String ... fields) {
        SolrQuery params = new SolrQuery();
        params.setQuery(querystring);
        params.clearSorts();
        if (sort != null) {
            params.set("sort", new String[]{sort});
        }
        params.setRows(Integer.valueOf(count));
        params.setStart(Integer.valueOf(offset));
        params.setFacet(false);
        if (fields != null && fields.length > 0) {
            params.setFields(fields);
        }
        params.setIncludeScore(false);
        if (count > 1) {
            params.setParam("defType", new String[]{"edismax"});
            params.setParam("qf", new String[]{CollectionSchema.text_t.getSolrFieldName() + "^1.0"});
        }
        return params;
    }

    @Override
    public String getURL(String id) throws IOException {
        SolrQuery params = new SolrQuery();
        String q = "{!cache=false raw f=" + CollectionSchema.id.getSolrFieldName() + "}" + id;
        params.setQuery(q);
        params.setRows(Integer.valueOf(1));
        params.setStart(Integer.valueOf(0));
        params.setFacet(false);
        params.clearSorts();
        params.setFields(new String[]{CollectionSchema.id.getSolrFieldName(), CollectionSchema.sku.getSolrFieldName(), CollectionSchema.load_date_dt.getSolrFieldName()});
        params.setIncludeScore(false);
        SolrDocumentList sdl = this.getDocumentListByParams((ModifiableSolrParams)params);
        if (sdl == null || sdl.getNumFound() <= 0L) {
            return null;
        }
        SolrDocument doc = (SolrDocument)sdl.iterator().next();
        return AbstractSolrConnector.getURL(doc);
    }

    @Override
    public boolean exists(String id) {
        String query2 = "{!cache=false raw f=" + CollectionSchema.id.getSolrFieldName() + "}" + id;
        try {
            return this.getCountByQuery(query2) > 0L;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return false;
        }
    }

    @Override
    public long getCountByQuery(String querystring) throws IOException {
        SolrQuery params = new SolrQuery();
        params.setQuery(querystring);
        params.setRows(Integer.valueOf(0));
        params.setStart(Integer.valueOf(0));
        params.setFacet(false);
        params.clearSorts();
        params.setFields(new String[]{CollectionSchema.id.getSolrFieldName()});
        params.setIncludeScore(false);
        SolrDocumentList sdl = this.getDocumentListByParams((ModifiableSolrParams)params);
        return sdl == null ? 0L : sdl.getNumFound();
    }

    @Override
    public LinkedHashMap<String, ReversibleScoreMap<String>> getFacets(String query2, int maxresults, String ... fields) throws IOException {
        assert (fields.length > 0);
        SolrQuery params = new SolrQuery();
        params.setQuery(query2);
        params.setRows(Integer.valueOf(0));
        params.setStart(Integer.valueOf(0));
        params.setFacet(true);
        params.setFacetMinCount(1);
        params.setFacetLimit(maxresults);
        params.setFacetSort("count");
        params.setParam("facet.method", new String[]{"enum"});
        params.setFields(fields);
        params.clearSorts();
        params.setIncludeScore(false);
        for (String field : fields) {
            params.addFacetField(new String[]{field});
        }
        QueryResponse rsp = this.getResponseByParams((ModifiableSolrParams)params);
        LinkedHashMap<String, ReversibleScoreMap<String>> facets = new LinkedHashMap<String, ReversibleScoreMap<String>>(fields.length);
        for (String field : fields) {
            FacetField facet = rsp.getFacetField(field);
            ClusteredScoreMap<String> result = new ClusteredScoreMap<String>(UTF8.insensitiveUTF8Comparator);
            List values = facet.getValues();
            if (values == null) continue;
            for (FacetField.Count ff : values) {
                if (ff.getCount() <= 0L) continue;
                result.set(ff.getName(), (int)ff.getCount());
            }
            facets.put(field, result);
        }
        return facets;
    }

    @Override
    public SolrDocument getDocumentById(String id, String ... fields) throws IOException {
        assert (id.length() == 12) : "wrong id: " + id;
        SolrQuery query2 = new SolrQuery();
        StringBuilder sb = new StringBuilder(23);
        sb.append("{!cache=false raw f=").append(CollectionSchema.id.getSolrFieldName()).append('}').append(id);
        query2.setQuery(sb.toString());
        query2.clearSorts();
        query2.setRows(Integer.valueOf(1));
        query2.setStart(Integer.valueOf(0));
        if (fields != null && fields.length > 0) {
            query2.setFields(fields);
        }
        query2.setIncludeScore(false);
        try {
            SolrDocumentList docs = this.getDocumentListByParams((ModifiableSolrParams)query2);
            if (docs == null || docs.isEmpty()) {
                return null;
            }
            SolrDocument doc = (SolrDocument)docs.get(0);
            return doc;
        }
        catch (Throwable e) {
            this.clearCaches();
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void update(SolrInputDocument solrdoc) throws IOException, SolrException {
        this.add(this.partialUpdatePatch(solrdoc));
    }

    @Override
    public void update(Collection<SolrInputDocument> solrdoc) throws IOException, SolrException {
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>(solrdoc.size());
        for (SolrInputDocument doc : solrdoc) {
            docs.add(this.partialUpdatePatch(doc));
        }
        this.add(docs);
    }

    private SolrInputDocument partialUpdatePatch(SolrInputDocument docIn) {
        SolrInputDocument docOut = new SolrInputDocument();
        docOut.setField(CollectionSchema.id.name(), docIn.getFieldValue(CollectionSchema.id.name()));
        for (Map.Entry entry2 : docIn.entrySet()) {
            if (((String)entry2.getKey()).equals(CollectionSchema.id.name())) continue;
            SolrInputField sif = (SolrInputField)entry2.getValue();
            HashMap<String, Object> partialUpdate = new HashMap<String, Object>(1);
            Object value = sif.getValue();
            docOut.removeField((String)entry2.getKey());
            partialUpdate.put("set", value);
            docOut.setField((String)entry2.getKey(), partialUpdate);
        }
        return docOut;
    }

    static {
        SOLR_ID_FIELDS.add(CollectionSchema.id.getSolrFieldName());
        SOLR_ID_and_LOAD_DATE_FIELDS.add(CollectionSchema.id.getSolrFieldName());
        SOLR_ID_and_LOAD_DATE_FIELDS.add(CollectionSchema.load_date_dt.getSolrFieldName());
        POISON_DOCUMENT = new SolrDocument();
        catchallQuery = new SolrQuery();
        catchallQuery.setQuery(CATCHALL_QUERY);
        catchallQuery.setFields(new String[]{CollectionSchema.id.getSolrFieldName()});
        catchallQuery.setRows(Integer.valueOf(0));
        catchallQuery.setStart(Integer.valueOf(0));
        catchSuccessQuery = new SolrQuery();
        catchSuccessQuery.setQuery(CATCHALL_QUERY);
        catchSuccessQuery.setFields(new String[]{CollectionSchema.id.getSolrFieldName()});
        catchSuccessQuery.clearSorts();
        catchSuccessQuery.setIncludeScore(false);
        catchSuccessQuery.setRows(Integer.valueOf(0));
        catchSuccessQuery.setStart(Integer.valueOf(0));
    }
}

