/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.document.analysis;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.util.CommonPattern;

public class Classification {
    private static final Set<String> textExtSet = new HashSet<String>();
    private static final Set<String> mediaExtSet = new HashSet<String>();
    private static final Set<String> imageExtSet = new HashSet<String>();
    private static final Set<String> audioExtSet = new HashSet<String>();
    private static final Set<String> videoExtSet = new HashSet<String>();
    private static final Set<String> appsExtSet = new HashSet<String>();
    private static final Set<String> ctrlExtSet = new HashSet<String>();
    private static final Properties mimeTable;

    private static void addSet(Set<String> set, String extString) {
        if (extString == null || extString.isEmpty()) {
            return;
        }
        for (String s : CommonPattern.COMMA.split(extString, 0)) {
            set.add(s.toLowerCase(Locale.ROOT).trim());
        }
    }

    public static boolean isTextExtension(String textExt) {
        if (textExt == null) {
            return false;
        }
        return textExtSet.contains(textExt.trim().toLowerCase(Locale.ROOT));
    }

    public static boolean isMediaExtension(String mediaExt) {
        if (mediaExt == null) {
            return false;
        }
        return mediaExtSet.contains(mediaExt.trim().toLowerCase(Locale.ROOT));
    }

    public static boolean isImageExtension(String imageExt) {
        if (imageExt == null) {
            return false;
        }
        return imageExtSet.contains(imageExt.trim().toLowerCase(Locale.ROOT));
    }

    public static boolean isAudioExtension(String audioExt) {
        if (audioExt == null) {
            return false;
        }
        return audioExtSet.contains(audioExt.trim().toLowerCase(Locale.ROOT));
    }

    public static boolean isVideoExtension(String videoExt) {
        if (videoExt == null) {
            return false;
        }
        return videoExtSet.contains(videoExt.trim().toLowerCase(Locale.ROOT));
    }

    public static boolean isApplicationExtension(String appsExt) {
        if (appsExt == null) {
            return false;
        }
        return appsExtSet.contains(appsExt.trim().toLowerCase(Locale.ROOT));
    }

    public static boolean isControlExtension(String ctrlExt) {
        if (ctrlExt == null) {
            return false;
        }
        return ctrlExtSet.contains(ctrlExt.trim().toLowerCase(Locale.ROOT));
    }

    public static boolean isAnyKnownExtension(String ext) {
        if (ext == null) {
            return false;
        }
        return textExtSet.contains(ext = ext.trim().toLowerCase(Locale.ROOT)) || mediaExtSet.contains(ext) || ctrlExtSet.contains(ext);
    }

    public static ContentDomain getContentDomainFromExt(String ext) {
        if (Classification.isTextExtension(ext)) {
            return ContentDomain.TEXT;
        }
        if (Classification.isImageExtension(ext)) {
            return ContentDomain.IMAGE;
        }
        if (Classification.isAudioExtension(ext)) {
            return ContentDomain.AUDIO;
        }
        if (Classification.isVideoExtension(ext)) {
            return ContentDomain.VIDEO;
        }
        if (Classification.isApplicationExtension(ext)) {
            return ContentDomain.APP;
        }
        if (Classification.isControlExtension(ext)) {
            return ContentDomain.CTRL;
        }
        return ContentDomain.ALL;
    }

    public static ContentDomain getContentDomainFromMime(String mime) {
        if (mime != null) {
            if (mime.startsWith("text/")) {
                return ContentDomain.TEXT;
            }
            if (mime.startsWith("image/")) {
                return ContentDomain.IMAGE;
            }
            if (mime.startsWith("audio/")) {
                return ContentDomain.AUDIO;
            }
            if (mime.startsWith("video/")) {
                return ContentDomain.VIDEO;
            }
            if (mime.startsWith("application/")) {
                return ContentDomain.APP;
            }
        }
        return ContentDomain.ALL;
    }

    public static boolean isPictureMime(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.toUpperCase(Locale.ROOT).startsWith("IMAGE");
    }

    public static void init(File mimeFile) {
        if (mimeTable.isEmpty()) {
            BufferedInputStream mimeTableInputStream = null;
            try {
                mimeTableInputStream = new BufferedInputStream(new FileInputStream(mimeFile));
                mimeTable.load(mimeTableInputStream);
            }
            catch (Exception exception) {
            }
            finally {
                if (mimeTableInputStream != null) {
                    try {
                        mimeTableInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        for (Map.Entry<Object, Object> entry2 : mimeTable.entrySet()) {
            String ext = (String)entry2.getKey();
            String mime = (String)entry2.getValue();
            if (mime.startsWith("text/")) {
                textExtSet.add(ext.toLowerCase(Locale.ROOT));
            }
            if (mime.startsWith("audio/")) {
                audioExtSet.add(ext.toLowerCase(Locale.ROOT));
            }
            if (mime.startsWith("video/")) {
                videoExtSet.add(ext.toLowerCase(Locale.ROOT));
            }
            if (!mime.startsWith("application/")) continue;
            appsExtSet.add(ext.toLowerCase(Locale.ROOT));
        }
    }

    public static int countMimes() {
        return mimeTable.size();
    }

    public static String ext2mime(String ext) {
        return ext == null ? "application/octet-stream" : mimeTable.getProperty(ext.toLowerCase(Locale.ROOT), "application/" + (ext == null || ext.length() == 0 ? "octet-stream" : ext));
    }

    public static String ext2mime(String ext, String dfltMime) {
        return ext == null ? dfltMime : mimeTable.getProperty(ext.toLowerCase(Locale.ROOT), dfltMime);
    }

    public static String url2mime(MultiProtocolURL url, String dfltMime) {
        return url == null ? dfltMime : Classification.ext2mime(MultiProtocolURL.getFileExtension(url.getFileName()), dfltMime);
    }

    public static String url2mime(MultiProtocolURL url) {
        return url == null ? "application/octet-stream" : Classification.ext2mime(MultiProtocolURL.getFileExtension(url.getFileName()));
    }

    static {
        String text = "htm,html,phtml,shtml,xhtml,php,php3,php4,php5,cfm,asp,aspx,tex,txt,jsp,mf,asp,aspx,csv,gpx,vcf,xsl,xml,pdf,doc,docx,xls,xlsx,ppt,pptx";
        String apps = "7z,ace,arc,arj,apk,asf,asx,bat,bin,bkf,bz2,cab,com,css,dcm,deb,dll,dmg,exe,java,gho,ghs,gz,hqx,img,iso,jar,lha,rar,sh,sit,sitx,tar,tbz,tgz,tib,torrent,vbs,war,zip";
        String audio = "aac,aif,aiff,aifc,flac,m4a,m4b,m4p,mid,mp2,mp3,oga,ogg,ra,ram,sid,wav,wma";
        String video = "3g2,3gp,3gp2,3gpp,3gpp2,3ivx,asf,asx,avi,div,divx,dv,dvx,env,f4v,flv,hdmov,m1v,m4v,m-jpeg,mkv,moov,mov,movie,mp2v,mp4,mpe,mpeg,mpg,mpg4,mv4,ogm,ogv,qt,rm,rv,vid,swf,webm,wmv";
        String image = "ai,bmp,cdr,cmx,emf,eps,gif,img,jpeg,jpg,mng,pct,pdd,pdn,pict,png,psb,psd,psp,svg,tif,tiff,wmf";
        String ctrl = "sha1,md5,crc32,sfv";
        Classification.addSet(textExtSet, "htm,html,phtml,shtml,xhtml,php,php3,php4,php5,cfm,asp,aspx,tex,txt,jsp,mf,asp,aspx,csv,gpx,vcf,xsl,xml,pdf,doc,docx,xls,xlsx,ppt,pptx");
        Classification.addSet(imageExtSet, "ai,bmp,cdr,cmx,emf,eps,gif,img,jpeg,jpg,mng,pct,pdd,pdn,pict,png,psb,psd,psp,svg,tif,tiff,wmf");
        Classification.addSet(audioExtSet, "aac,aif,aiff,aifc,flac,m4a,m4b,m4p,mid,mp2,mp3,oga,ogg,ra,ram,sid,wav,wma");
        Classification.addSet(videoExtSet, "3g2,3gp,3gp2,3gpp,3gpp2,3ivx,asf,asx,avi,div,divx,dv,dvx,env,f4v,flv,hdmov,m1v,m4v,m-jpeg,mkv,moov,mov,movie,mp2v,mp4,mpe,mpeg,mpg,mpg4,mv4,ogm,ogv,qt,rm,rv,vid,swf,webm,wmv");
        Classification.addSet(appsExtSet, "7z,ace,arc,arj,apk,asf,asx,bat,bin,bkf,bz2,cab,com,css,dcm,deb,dll,dmg,exe,java,gho,ghs,gz,hqx,img,iso,jar,lha,rar,sh,sit,sitx,tar,tbz,tgz,tib,torrent,vbs,war,zip");
        Classification.addSet(ctrlExtSet, "sha1,md5,crc32,sfv");
        Classification.addSet(mediaExtSet, "7z,ace,arc,arj,apk,asf,asx,bat,bin,bkf,bz2,cab,com,css,dcm,deb,dll,dmg,exe,java,gho,ghs,gz,hqx,img,iso,jar,lha,rar,sh,sit,sitx,tar,tbz,tgz,tib,torrent,vbs,war,zip,aac,aif,aiff,aifc,flac,m4a,m4b,m4p,mid,mp2,mp3,oga,ogg,ra,ram,sid,wav,wma,3g2,3gp,3gp2,3gpp,3gpp2,3ivx,asf,asx,avi,div,divx,dv,dvx,env,f4v,flv,hdmov,m1v,m4v,m-jpeg,mkv,moov,mov,movie,mp2v,mp4,mpe,mpeg,mpg,mpg4,mv4,ogm,ogv,qt,rm,rv,vid,swf,webm,wmv,ai,bmp,cdr,cmx,emf,eps,gif,img,jpeg,jpg,mng,pct,pdd,pdn,pict,png,psb,psd,psp,svg,tif,tiff,wmf");
        mimeTable = new Properties();
    }

    public static enum ContentDomain {
        ALL(-1),
        TEXT(0),
        IMAGE(1),
        AUDIO(2),
        VIDEO(3),
        APP(4),
        CTRL(5);

        private final int code;

        private ContentDomain(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ContentDomain contentdomParser(String dom) {
            if ("all".equals(dom)) {
                return ALL;
            }
            if ("text".equals(dom)) {
                return TEXT;
            }
            if ("image".equals(dom)) {
                return IMAGE;
            }
            if ("audio".equals(dom)) {
                return AUDIO;
            }
            if ("video".equals(dom)) {
                return VIDEO;
            }
            if ("app".equals(dom)) {
                return APP;
            }
            if ("ctrl".equals(dom)) {
                return CTRL;
            }
            return TEXT;
        }

        public String toString() {
            if (this == ALL) {
                return "all";
            }
            if (this == TEXT) {
                return "text";
            }
            if (this == IMAGE) {
                return "image";
            }
            if (this == AUDIO) {
                return "audio";
            }
            if (this == VIDEO) {
                return "video";
            }
            if (this == APP) {
                return "app";
            }
            if (this == CTRL) {
                return "ctrl";
            }
            return "text";
        }
    }
}

