/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.LongBuffer;
import java.util.concurrent.atomic.AtomicInteger;

final class ByteBufferGuard {
    private final String resourceDescription;
    private final BufferCleaner cleaner;
    private boolean invalidated = false;
    private final AtomicInteger barrier = new AtomicInteger();

    public ByteBufferGuard(String resourceDescription, BufferCleaner cleaner) {
        this.resourceDescription = resourceDescription;
        this.cleaner = cleaner;
    }

    public void invalidateAndUnmap(ByteBuffer ... bufs) throws IOException {
        if (this.cleaner != null) {
            this.invalidated = true;
            this.barrier.lazySet(0);
            Thread.yield();
            for (ByteBuffer b : bufs) {
                this.cleaner.freeBuffer(this.resourceDescription, b);
            }
        }
    }

    private void ensureValid() {
        if (this.invalidated) {
            throw new NullPointerException();
        }
    }

    public void getBytes(ByteBuffer receiver, byte[] dst, int offset, int length) {
        this.ensureValid();
        receiver.get(dst, offset, length);
    }

    public byte getByte(ByteBuffer receiver) {
        this.ensureValid();
        return receiver.get();
    }

    public short getShort(ByteBuffer receiver) {
        this.ensureValid();
        return receiver.getShort();
    }

    public int getInt(ByteBuffer receiver) {
        this.ensureValid();
        return receiver.getInt();
    }

    public long getLong(ByteBuffer receiver) {
        this.ensureValid();
        return receiver.getLong();
    }

    public byte getByte(ByteBuffer receiver, int pos) {
        this.ensureValid();
        return receiver.get(pos);
    }

    public short getShort(ByteBuffer receiver, int pos) {
        this.ensureValid();
        return receiver.getShort(pos);
    }

    public int getInt(ByteBuffer receiver, int pos) {
        this.ensureValid();
        return receiver.getInt(pos);
    }

    public long getLong(ByteBuffer receiver, int pos) {
        this.ensureValid();
        return receiver.getLong(pos);
    }

    public void getLongs(LongBuffer receiver, long[] dst, int offset, int length) {
        this.ensureValid();
        receiver.get(dst, offset, length);
    }

    public void getFloats(FloatBuffer receiver, float[] dst, int offset, int length) {
        this.ensureValid();
        receiver.get(dst, offset, length);
    }

    @FunctionalInterface
    static interface BufferCleaner {
        public void freeBuffer(String var1, ByteBuffer var2) throws IOException;
    }
}

