/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;
import org.jaudiotagger.tag.mp4.field.Mp4TagBinaryField;

public class Mp4TagCoverField
extends Mp4TagBinaryField {
    private Mp4FieldType imageType;
    private int dataAndHeaderSize;

    public Mp4TagCoverField() {
        super(Mp4FieldKey.ARTWORK.getFieldName());
    }

    public int getDataAndHeaderSize() {
        return this.dataAndHeaderSize;
    }

    public Mp4TagCoverField(ByteBuffer raw, Mp4FieldType imageType) throws UnsupportedEncodingException {
        super(Mp4FieldKey.ARTWORK.getFieldName(), raw);
        this.imageType = imageType;
        if (!Mp4FieldType.isCoverArtType(imageType)) {
            logger.warning(ErrorMessage.MP4_IMAGE_FORMAT_IS_NOT_TO_EXPECTED_TYPE.getMsg(new Object[]{imageType}));
        }
    }

    public Mp4TagCoverField(byte[] data) {
        super(Mp4FieldKey.ARTWORK.getFieldName(), data);
        if (ImageFormats.binaryDataIsPngFormat(data)) {
            this.imageType = Mp4FieldType.COVERART_PNG;
        } else if (ImageFormats.binaryDataIsJpgFormat(data)) {
            this.imageType = Mp4FieldType.COVERART_JPEG;
        } else if (ImageFormats.binaryDataIsGifFormat(data)) {
            this.imageType = Mp4FieldType.COVERART_GIF;
        } else if (ImageFormats.binaryDataIsBmpFormat(data)) {
            this.imageType = Mp4FieldType.COVERART_BMP;
        } else {
            logger.warning(ErrorMessage.GENERAL_UNIDENITIFED_IMAGE_FORMAT.getMsg());
            this.imageType = Mp4FieldType.COVERART_PNG;
        }
    }

    @Override
    public Mp4FieldType getFieldType() {
        return this.imageType;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.imageType) + ":" + this.dataBytes.length + "bytes";
    }

    @Override
    protected void build(ByteBuffer raw) {
        Mp4BoxHeader header = new Mp4BoxHeader(raw);
        this.dataSize = header.getDataLength();
        this.dataAndHeaderSize = header.getLength();
        raw.position(raw.position() + 8);
        this.dataBytes = new byte[this.dataSize - 8];
        raw.get(this.dataBytes, 0, this.dataBytes.length);
        int positionAfterDataAtom = raw.position();
        if (raw.position() + 8 <= raw.limit()) {
            Mp4BoxHeader nameHeader = new Mp4BoxHeader(raw);
            if (nameHeader.getId().equals("name")) {
                this.dataSize += nameHeader.getDataLength();
                this.dataAndHeaderSize += nameHeader.getLength();
            } else {
                raw.position(positionAfterDataAtom);
            }
        }
    }

    public static String getMimeTypeForImageType(Mp4FieldType imageType) {
        if (imageType == Mp4FieldType.COVERART_PNG) {
            return "image/png";
        }
        if (imageType == Mp4FieldType.COVERART_JPEG) {
            return "image/jpeg";
        }
        if (imageType == Mp4FieldType.COVERART_GIF) {
            return "image/gif";
        }
        if (imageType == Mp4FieldType.COVERART_BMP) {
            return "image/bmp";
        }
        return null;
    }
}

