/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javainetlocator.jini.server;

import com.sun.jini.config.Config;
import com.sun.jini.start.LifeCycle;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Locale;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jrmp.JrmpExporter;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.Name;
import net.sf.javainetlocator.InetAddressLocator;
import net.sf.javainetlocator.InetAddressLocatorException;
import net.sf.javainetlocator.jini.server.IPGeographerProxy;
import net.sf.javainetlocator.jini.server.RemoteIPGeographer;

public class RemoteIPGeographerImpl
implements RemoteIPGeographer,
ProxyAccessor {
    private Object proxy = null;
    private Exporter exporter;
    private JoinManager joinManager;
    private String PACKAGE_NAME = "net.sf.javainetlocator.jini.server";
    private static String[] GROUPS = LookupDiscovery.ALL_GROUPS;
    private static String NAME = "IP2CC";
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Lnet$jini$core$discovery$LookupLocator;
    static /* synthetic */ Class array$Lnet$jini$core$entry$Entry;
    static /* synthetic */ Class class$net$jini$export$Exporter;

    public RemoteIPGeographerImpl(String[] stringArray, LifeCycle lifeCycle) throws RemoteException, Exception {
        this.init(stringArray);
    }

    public Locale getLocale(InetAddress inetAddress) throws RemoteException {
        try {
            return InetAddressLocator.getLocale(inetAddress);
        }
        catch (InetAddressLocatorException inetAddressLocatorException) {
            throw new RemoteException("Couldn't convert address", inetAddressLocatorException);
        }
    }

    public Locale getLocale(byte[] byArray) throws RemoteException {
        try {
            return InetAddressLocator.getLocale(byArray);
        }
        catch (InetAddressLocatorException inetAddressLocatorException) {
            throw new RemoteException("Couldn't convert address", inetAddressLocatorException);
        }
    }

    private void init(String[] stringArray) throws RemoteException {
        try {
            Configuration configuration = ConfigurationProvider.getInstance((String[])stringArray);
            String[] stringArray2 = (String[])configuration.getEntry(this.PACKAGE_NAME, "initialLookupGroups", array$Ljava$lang$String == null ? (array$Ljava$lang$String = RemoteIPGeographerImpl.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, (Object)GROUPS);
            LookupLocator[] lookupLocatorArray = (LookupLocator[])Config.getNonNullEntry((Configuration)configuration, (String)this.PACKAGE_NAME, (String)"initialLookupLocators", (Class)(array$Lnet$jini$core$discovery$LookupLocator == null ? (array$Lnet$jini$core$discovery$LookupLocator = RemoteIPGeographerImpl.class$("[Lnet.jini.core.discovery.LookupLocator;")) : array$Lnet$jini$core$discovery$LookupLocator), (Object)new LookupLocator[0]);
            Entry[] entryArray = (Entry[])Config.getNonNullEntry((Configuration)configuration, (String)this.PACKAGE_NAME, (String)"initialLookupAttributes", (Class)(array$Lnet$jini$core$entry$Entry == null ? (array$Lnet$jini$core$entry$Entry = RemoteIPGeographerImpl.class$("[Lnet.jini.core.entry.Entry;")) : array$Lnet$jini$core$entry$Entry), (Object)new Entry[]{new Name(NAME)});
            this.exporter = (Exporter)Config.getNonNullEntry((Configuration)configuration, (String)this.PACKAGE_NAME, (String)"serverExporter", (Class)(class$net$jini$export$Exporter == null ? (class$net$jini$export$Exporter = RemoteIPGeographerImpl.class$("net.jini.export.Exporter")) : class$net$jini$export$Exporter), (Object)new JrmpExporter());
            Uuid uuid = UuidFactory.generate();
            ServiceID serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            Remote remote = this.exporter.export((Remote)this);
            this.proxy = new IPGeographerProxy((RemoteIPGeographer)remote);
            LookupDiscoveryManager lookupDiscoveryManager = new LookupDiscoveryManager(stringArray2, lookupLocatorArray, null);
            this.joinManager = new JoinManager(this.proxy, entryArray, serviceID, (DiscoveryManagement)lookupDiscoveryManager, null);
        }
        catch (Exception exception) {
            throw new RemoteException("Failed to init service", exception);
        }
    }

    public Object getProxy() {
        return this.proxy;
    }

    public void destroy() {
        this.exporter.unexport(true);
    }

    public Entry[] getLookupAttributes() throws RemoteException {
        return this.joinManager.getAttributes();
    }

    public void addLookupAttributes(Entry[] entryArray) throws RemoteException {
        this.joinManager.addAttributes(entryArray, true);
    }

    public void modifyLookupAttributes(Entry[] entryArray, Entry[] entryArray2) throws RemoteException {
        this.joinManager.modifyAttributes(entryArray, entryArray2, true);
    }

    public String[] getLookupGroups() throws RemoteException {
        return this.getDiscoveryManager().getGroups();
    }

    public void addLookupGroups(String[] stringArray) throws RemoteException {
        try {
            this.getDiscoveryManager().addGroups(stringArray);
        }
        catch (IOException iOException) {
            throw new RemoteException("addLookupGroups() encountered :", iOException);
        }
    }

    public void removeLookupGroups(String[] stringArray) throws RemoteException {
        this.getDiscoveryManager().removeGroups(stringArray);
    }

    public void setLookupGroups(String[] stringArray) throws RemoteException {
        try {
            this.getDiscoveryManager().setGroups(stringArray);
        }
        catch (IOException iOException) {
            throw new RemoteException("setLookupGroups() encountered :", iOException);
        }
    }

    public LookupLocator[] getLookupLocators() throws RemoteException {
        return this.getDiscoveryManager().getLocators();
    }

    public void addLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.getDiscoveryManager().addLocators(lookupLocatorArray);
    }

    public void removeLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.getDiscoveryManager().removeLocators(lookupLocatorArray);
    }

    public void setLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        this.getDiscoveryManager().setLocators(lookupLocatorArray);
    }

    private LookupDiscoveryManager getDiscoveryManager() {
        return (LookupDiscoveryManager)this.joinManager.getDiscoveryManager();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

