/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpClusterStateProvider;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.impl.SolrClientBuilder;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;

@Deprecated(since="9.0")
public class CloudLegacySolrClient
extends CloudSolrClient {
    private final ClusterStateProvider stateProvider;
    private final LBHttpSolrClient lbClient;
    private final boolean shutdownLBHttpSolrServer;
    private HttpClient myClient;
    private final boolean clientIsInternal;
    public static final String STATE_VERSION = "_stateVer_";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CloudLegacySolrClient(Builder builder) {
        super(builder.shardLeadersOnly, builder.parallelUpdates, builder.directUpdatesToLeadersOnly);
        if (builder.stateProvider == null) {
            if (builder.zkHosts != null && builder.solrUrls != null) {
                throw new IllegalArgumentException("Both zkHost(s) & solrUrl(s) have been specified. Only specify one.");
            }
            if (builder.zkHosts != null) {
                this.stateProvider = new ZkClientClusterStateProvider(builder.zkHosts, builder.zkChroot);
            } else {
                if (builder.solrUrls == null || builder.solrUrls.isEmpty()) throw new IllegalArgumentException("Both zkHosts and solrUrl cannot be null.");
                try {
                    this.stateProvider = new HttpClusterStateProvider(builder.solrUrls, builder.httpClient);
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't initialize a HttpClusterStateProvider (is/are the Solr server(s), " + builder.solrUrls + ", down?)", e);
                }
            }
        } else {
            this.stateProvider = builder.stateProvider;
        }
        this.clientIsInternal = builder.httpClient == null;
        boolean bl = this.shutdownLBHttpSolrServer = builder.loadBalancedSolrClient == null;
        if (builder.lbClientBuilder != null) {
            this.propagateLBClientConfigOptions(builder);
            builder.loadBalancedSolrClient = builder.lbClientBuilder.build();
        }
        if (builder.loadBalancedSolrClient != null) {
            builder.httpClient = builder.loadBalancedSolrClient.getHttpClient();
        }
        Object object = this.myClient = builder.httpClient == null ? HttpClientUtil.createClient(null) : builder.httpClient;
        if (builder.loadBalancedSolrClient == null) {
            builder.loadBalancedSolrClient = CloudLegacySolrClient.createLBHttpSolrClient(builder, this.myClient);
        }
        this.lbClient = builder.loadBalancedSolrClient;
    }

    private void propagateLBClientConfigOptions(Builder builder) {
        LBHttpSolrClient.Builder lbBuilder = builder.lbClientBuilder;
        if (builder.connectionTimeoutMillis != null) {
            lbBuilder.withConnectionTimeout(builder.connectionTimeoutMillis);
        }
        if (builder.socketTimeoutMillis != null) {
            lbBuilder.withSocketTimeout(builder.socketTimeoutMillis);
        }
    }

    protected Map<String, LBSolrClient.Req> createRoutes(UpdateRequest updateRequest, ModifiableSolrParams routableParams, DocCollection col, DocRouter router, Map<String, List<String>> urlMap, String idField) {
        return urlMap == null ? null : updateRequest.getRoutesToCollection(router, col, urlMap, routableParams, idField);
    }

    @Override
    protected CloudSolrClient.RouteException getRouteException(SolrException.ErrorCode serverError, NamedList<Throwable> exceptions, Map<String, ? extends LBSolrClient.Req> routes) {
        return new CloudSolrClient.RouteException(serverError, exceptions, routes);
    }

    @Override
    public void close() throws IOException {
        this.stateProvider.close();
        if (this.shutdownLBHttpSolrServer) {
            this.lbClient.close();
        }
        if (this.clientIsInternal && this.myClient != null) {
            HttpClientUtil.close(this.myClient);
        }
        super.close();
    }

    @Override
    public LBHttpSolrClient getLbClient() {
        return this.lbClient;
    }

    public HttpClient getHttpClient() {
        return this.myClient;
    }

    @Override
    public ClusterStateProvider getClusterStateProvider() {
        return this.stateProvider;
    }

    @Override
    protected boolean wasCommError(Throwable rootCause) {
        return rootCause instanceof ConnectTimeoutException || rootCause instanceof NoHttpResponseException;
    }

    private static LBHttpSolrClient createLBHttpSolrClient(Builder cloudSolrClientBuilder, HttpClient httpClient) {
        LBHttpSolrClient.Builder lbBuilder = new LBHttpSolrClient.Builder();
        lbBuilder.withHttpClient(httpClient);
        if (cloudSolrClientBuilder.connectionTimeoutMillis != null) {
            lbBuilder.withConnectionTimeout(cloudSolrClientBuilder.connectionTimeoutMillis);
        }
        if (cloudSolrClientBuilder.socketTimeoutMillis != null) {
            lbBuilder.withSocketTimeout(cloudSolrClientBuilder.socketTimeoutMillis);
        }
        LBHttpSolrClient lbClient = lbBuilder.build();
        lbClient.setRequestWriter(new BinaryRequestWriter());
        lbClient.setParser(new BinaryResponseParser());
        return lbClient;
    }

    public static class Builder
    extends SolrClientBuilder<Builder> {
        protected Collection<String> zkHosts = new ArrayList<String>();
        protected List<String> solrUrls = new ArrayList<String>();
        protected String zkChroot;
        protected LBHttpSolrClient loadBalancedSolrClient;
        protected LBHttpSolrClient.Builder lbClientBuilder;
        protected boolean shardLeadersOnly = true;
        protected boolean directUpdatesToLeadersOnly = false;
        protected boolean parallelUpdates = true;
        protected ClusterStateProvider stateProvider;

        protected Builder() {
        }

        public Builder(List<String> solrUrls) {
            this.solrUrls = solrUrls;
        }

        public Builder(ClusterStateProvider stateProvider) {
            this.stateProvider = stateProvider;
        }

        public Builder(List<String> zkHosts, Optional<String> zkChroot) {
            this.zkHosts = zkHosts;
            if (zkChroot.isPresent()) {
                this.zkChroot = zkChroot.get();
            }
        }

        public Builder withLBHttpSolrClientBuilder(LBHttpSolrClient.Builder lbHttpSolrClientBuilder) {
            this.lbClientBuilder = lbHttpSolrClientBuilder;
            return this;
        }

        public Builder withLBHttpSolrClient(LBHttpSolrClient loadBalancedSolrClient) {
            this.loadBalancedSolrClient = loadBalancedSolrClient;
            return this;
        }

        public Builder sendUpdatesOnlyToShardLeaders() {
            this.shardLeadersOnly = true;
            return this;
        }

        public Builder sendUpdatesToAllReplicasInShard() {
            this.shardLeadersOnly = false;
            return this;
        }

        public Builder sendDirectUpdatesToShardLeadersOnly() {
            this.directUpdatesToLeadersOnly = true;
            return this;
        }

        public Builder sendDirectUpdatesToAnyShardReplica() {
            this.directUpdatesToLeadersOnly = false;
            return this;
        }

        public Builder withParallelUpdates(boolean parallelUpdates) {
            this.parallelUpdates = parallelUpdates;
            return this;
        }

        public CloudLegacySolrClient build() {
            if (this.stateProvider == null) {
                if (!this.zkHosts.isEmpty()) {
                    this.stateProvider = new ZkClientClusterStateProvider(this.zkHosts, this.zkChroot);
                } else if (!this.solrUrls.isEmpty()) {
                    try {
                        this.stateProvider = new HttpClusterStateProvider(this.solrUrls, this.httpClient);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Couldn't initialize a HttpClusterStateProvider (is/are the Solr server(s), " + this.solrUrls + ", down?)", e);
                    }
                } else {
                    throw new IllegalArgumentException("Both zkHosts and solrUrl cannot be null.");
                }
            }
            return new CloudLegacySolrClient(this);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }
}

