/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.retrieval.StreamResponse;
import net.yacy.data.InvalidURLLicenceException;
import net.yacy.data.URLLicense;
import net.yacy.data.UserDB;
import net.yacy.http.servlets.TemplateMissingParameterException;
import net.yacy.peers.graphics.EncodedImage;
import net.yacy.repository.Blacklist;
import net.yacy.repository.LoaderDispatcher;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;

public class ImageViewer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DigestURL parseURL(serverObjects post, boolean auth) throws MalformedURLException {
        String urlString = post.get("url", "");
        String urlLicense = post.get("code", "");
        if (auth) {
            if (urlString.length() <= 0) throw new TemplateMissingParameterException("missing required url parameter");
            return new DigestURL(urlString);
        }
        if (urlLicense.length() <= 0) throw new TemplateMissingParameterException("missing required code parameter");
        String licensedURL = URLLicense.releaseLicense(urlLicense);
        if (licensedURL != null) {
            return new DigestURL(licensedURL);
        }
        ConcurrentLog.fine("ImageViewer", "image urlLicense not found key=" + urlLicense);
        throw new InvalidURLLicenceException();
    }

    public InputStream openInputStream(serverObjects post, LoaderDispatcher loader, boolean auth, DigestURL url) throws IOException {
        InputStream inStream = null;
        if (url != null) {
            try {
                String agentName = post.get("agentName", auth ? "YaCy Intranet (greedy)" : "YaCy Internet (cautious)");
                ClientIdentification.Agent agent = ClientIdentification.getAgent(agentName);
                StreamResponse response = loader.openInputStream(loader.request(url, false, true), CacheStrategy.IFEXIST, Blacklist.BlacklistType.SEARCH, agent, -1);
                inStream = response.getContentStream();
            }
            catch (IOException e) {
                ConcurrentLog.fine("ImageViewer", "cannot load image. URL : " + url.toNormalform(true));
                throw e;
            }
        }
        if (inStream == null) {
            throw new IOException("Input stream could no be open");
        }
        return inStream;
    }

    public static boolean hasFullViewingRights(RequestHeader header, Switchboard sb) {
        boolean extendedSearchRights = false;
        if (sb != null && header != null) {
            boolean adminAuthenticated = sb.verifyAuthentication(header);
            if (adminAuthenticated) {
                extendedSearchRights = true;
            } else {
                UserDB.Entry user;
                UserDB.Entry entry2 = user = sb.userDB != null ? sb.userDB.getUser(header) : null;
                if (user != null) {
                    extendedSearchRights = user.hasRight(UserDB.AccessRight.EXTENDED_SEARCH_RIGHT);
                }
            }
        }
        return header != null && (extendedSearchRights || Domains.isLocalhost(header.getRemoteAddr()));
    }

    public static boolean isBrowserRendered(String formatName) {
        return "gif".equalsIgnoreCase(formatName) || "svg".equalsIgnoreCase(formatName);
    }

    public EncodedImage parseAndScale(serverObjects post, boolean auth, DigestURL url, String ext, ImageInputStream imageInStream) throws IOException {
        EncodedImage encodedImage;
        Iterator<ImageReader> readers = ImageIO.getImageReaders(imageInStream);
        if (!readers.hasNext()) {
            try {
                imageInStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String urlString = url.toNormalform(false);
            String errorMessage = "Image format (" + MultiProtocolURL.getFileExtension(urlString) + ") is not supported.";
            ConcurrentLog.fine("ImageViewer", errorMessage + "Image URL : " + urlString);
            throw new IOException(errorMessage);
        }
        ImageReader reader = readers.next();
        reader.setInput(imageInStream, true, true);
        int maxwidth = post.getInt("maxwidth", 0);
        int maxheight = post.getInt("maxheight", 0);
        boolean quadratic = post.containsKey("quadratic");
        boolean isStatic = post.getBoolean("isStatic");
        BufferedImage image = null;
        boolean returnRaw = true;
        if (!auth || maxwidth != 0 || maxheight != 0) {
            int originWidth = reader.getWidth(0);
            int originHeigth = reader.getHeight(0);
            Dimension maxDimensions = this.calculateMaxDimensions(auth, originWidth, originHeigth, maxwidth, maxheight);
            int w = originWidth;
            int h = originHeigth;
            if (quadratic && originWidth != originHeigth) {
                Rectangle square = this.getMaxSquare(originHeigth, originWidth);
                h = square.height;
                w = square.width;
            }
            Dimension finalDimensions = this.calculateDimensions(w, h, maxDimensions);
            if (originWidth != finalDimensions.width || originHeigth != finalDimensions.height) {
                returnRaw = false;
                image = this.readImage(reader);
                if (quadratic && originWidth != originHeigth) {
                    image = this.makeSquare(image);
                }
                image = this.scale(finalDimensions.width, finalDimensions.height, image);
            }
        }
        if (returnRaw && (!reader.getFormatName().equalsIgnoreCase(ext) || imageInStream.getFlushedPosition() != 0L)) {
            returnRaw = false;
            image = this.readImage(reader);
        }
        if (returnRaw) {
            byte[] imageData = this.readRawImage(imageInStream);
            encodedImage = new EncodedImage(imageData, ext, isStatic);
        } else {
            encodedImage = new EncodedImage(image, ext, isStatic);
            if (encodedImage.getImage().length() == 0) {
                String errorMessage = "Image could not be encoded to format : " + ext;
                ConcurrentLog.fine("ImageViewer", errorMessage + ". Image URL : " + url.toNormalform(false));
                throw new IOException(errorMessage);
            }
        }
        return encodedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readImage(ImageReader reader) throws IOException {
        BufferedImage image;
        try {
            image = reader.read(0);
        }
        finally {
            reader.dispose();
            Object input = reader.getInput();
            if (input instanceof ImageInputStream) {
                try {
                    ((ImageInputStream)input).close();
                }
                catch (IOException iOException) {}
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readRawImage(ImageInputStream inStream) throws IOException {
        byte[] buffer = new byte[4096];
        int l = 0;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        inStream.seek(0L);
        try {
            while ((l = inStream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, l);
            }
            byte[] byArray = outStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected Dimension calculateDimensions(int originWidth, int originHeight, Dimension max) {
        int resultHeight;
        int resultWidth;
        if (max.width < originWidth || max.height < originHeight) {
            double vs;
            double hs = originWidth <= max.width ? 1.0 : (double)max.width / (double)originWidth;
            double scale = Math.min(hs, vs = originHeight <= max.height ? 1.0 : (double)max.height / (double)originHeight);
            if (scale < 1.0) {
                resultWidth = Math.max(1, (int)((double)originWidth * scale));
                resultHeight = Math.max(1, (int)((double)originHeight * scale));
            } else {
                resultWidth = Math.max(1, originWidth);
                resultHeight = Math.max(1, originHeight);
            }
        } else {
            resultWidth = originWidth;
            resultHeight = originHeight;
        }
        return new Dimension(resultWidth, resultHeight);
    }

    protected Dimension calculateMaxDimensions(boolean auth, int originWidth, int originHeight, int maxWidth, int maxHeight) {
        int resultHeight;
        int resultWidth;
        if (auth) {
            resultWidth = maxWidth == 0 ? originWidth : maxWidth;
            resultHeight = maxHeight == 0 ? originHeight : maxHeight;
        } else if (originWidth > 16 || originHeight > 16) {
            resultWidth = Math.min(96, originWidth);
            resultHeight = Math.min(96, originHeight);
        } else {
            resultWidth = 16;
            resultHeight = 16;
        }
        return new Dimension(resultWidth, resultHeight);
    }

    public BufferedImage scale(int width, int height, BufferedImage image) {
        Image scaled = image.getScaledInstance(width, height, 16);
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(scaled, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        BufferedImage result = new BufferedImage(width, height, 2);
        try {
            result.createGraphics().drawImage(scaled, 0, 0, width, height, null);
            Raster raster = result.getData();
            int[] pixel = new int[raster.getSampleModel().getNumBands()];
            pixel = raster.getPixel(0, 0, pixel);
        }
        catch (Exception e) {
            try {
                BufferedImage converted = EncodedImage.convertToRGB(image);
                scaled = converted.getScaledInstance(width, height, 16);
                mediaTracker.addImage(scaled, 1);
                try {
                    mediaTracker.waitForID(1);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                result = new BufferedImage(width, height, 2);
                result.createGraphics().drawImage(scaled, 0, 0, width, height, null);
                Raster raster = result.getData();
                int[] pixel = new int[result.getSampleModel().getNumBands()];
                pixel = raster.getPixel(0, 0, pixel);
            }
            catch (Exception e2) {
                result = image;
            }
            ConcurrentLog.fine("ImageViewer", "Image could not be scaled");
        }
        return result;
    }

    public Rectangle getMaxSquare(int h, int w) {
        Rectangle square;
        if (w > h) {
            int offset = (w - h) / 2;
            square = new Rectangle(offset, 0, h, h);
        } else {
            int offset = (h - w) / 2;
            square = new Rectangle(0, offset, w, w);
        }
        return square;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage makeSquare(BufferedImage image) {
        int h;
        int w = image.getWidth();
        if (w > (h = image.getHeight())) {
            BufferedImage dst = new BufferedImage(h, h, 2);
            Graphics2D g = dst.createGraphics();
            int offset = (w - h) / 2;
            try {
                g.drawImage(image, 0, 0, h - 1, h - 1, offset, 0, h + offset, h - 1, null);
            }
            finally {
                g.dispose();
            }
            image = dst;
        } else {
            BufferedImage dst = new BufferedImage(w, w, 2);
            Graphics2D g = dst.createGraphics();
            int offset = (h - w) / 2;
            try {
                g.drawImage(image, 0, 0, w - 1, w - 1, 0, offset, w - 1, w + offset, null);
            }
            finally {
                g.dispose();
            }
            image = dst;
        }
        return image;
    }
}

