/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.server;

import java.io.File;
import java.io.IOException;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.search.Switchboard;

public final class serverClassLoader
extends ClassLoader {
    public serverClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
        if (!serverClassLoader.registerAsParallelCapable()) {
            ConcurrentLog.warn("ClassLoader", "registerAsParallelCapable failed");
        }
    }

    public serverClassLoader(ClassLoader parent) {
        super(parent);
        if (!serverClassLoader.registerAsParallelCapable()) {
            ConcurrentLog.warn("ClassLoader", "registerAsParallelCapable failed");
        }
    }

    @Override
    protected Class<?> findClass(String classname) throws ClassNotFoundException {
        File cpath = new File(Switchboard.getSwitchboard().getAppPath("htRootPath", "htroot"), classname + ".class");
        return this.loadClass(cpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(File classfile) throws ClassNotFoundException {
        int p = classfile.getName().indexOf(46, 0);
        if (p < 0) {
            throw new ClassNotFoundException("wrong class name: " + classfile.getName());
        }
        String classname = classfile.getName().substring(0, p);
        serverClassLoader serverClassLoader2 = this;
        synchronized (serverClassLoader2) {
            Class<?> c = this.findLoadedClass(classname);
            if (c != null) {
                return c;
            }
            try {
                byte[] b = FileUtils.read(classfile);
                c = this.defineClass(null, b, 0, b.length);
                this.resolveClass(c);
            }
            catch (LinkageError ee) {
                throw new ClassNotFoundException("linkageError, " + ee.getMessage() + ":" + classfile.toString());
            }
            catch (IOException ee) {
                throw new ClassNotFoundException(ee.getMessage() + ":" + classfile.toString());
            }
            return c;
        }
    }
}

