/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.server.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.server.http.HTTPDFileHandler;
import net.yacy.server.serverCore;
import net.yacy.server.serverObjects;

public final class TemplateEngine {
    private static final byte hashChar = 35;
    private static final byte[] slashChar = new byte[]{47};
    private static final byte pcChar = 37;
    private static final byte[] dpdpa = "::".getBytes();
    private static final byte lbr = 91;
    private static final byte rbr = 93;
    private static final byte[] pClose = new byte[]{93, 35};
    private static final byte lcbr = 123;
    private static final byte rcbr = 125;
    private static final byte[] mOpen = new byte[]{35, 123};
    private static final byte[] mClose = new byte[]{125, 35};
    private static final byte lrbr = 40;
    private static final byte rrbr = 41;
    private static final byte[] aOpen = new byte[]{35, 40};
    private static final byte[] aClose = new byte[]{41, 35};
    private static final byte[] iClose = new byte[]{37, 35};
    private static final byte[] ul = "_".getBytes();
    private static final byte[] alternative_which = " type=\"alternative\" which=\"".getBytes();
    private static final byte[] multi_num = " type=\"multi\" num=\"".getBytes();
    private static final byte[] open_endtag = "</".getBytes();
    private static final byte[] close_quotetagn = "\">\n".getBytes();
    private static final byte[] close_tagn = ">\n".getBytes();
    private static final byte[] PP = "%%".getBytes();
    private static final byte[] hash_brackopen_slash = "#(/".getBytes();
    private static final byte[] brackclose_hash = ")#".getBytes();
    private static final byte[] UNRESOLVED_PATTERN = "-UNRESOLVED_PATTERN-".getBytes();

    private static final boolean transferUntil(PushbackInputStream i, OutputStream o, byte[] pattern) throws IOException {
        int b;
        while ((b = i.read()) > 0) {
            if ((b & 0xFF) == pattern[0]) {
                boolean equal = true;
                for (int n = 1; n < pattern.length; ++n) {
                    int bb = i.read();
                    if ((bb & 0xFF) == pattern[n]) continue;
                    i.unread(bb);
                    equal = false;
                    for (int nn = n - 1; nn > 0; --nn) {
                        i.unread(pattern[nn]);
                    }
                    break;
                }
                if (equal) {
                    return true;
                }
            }
            o.write(b);
        }
        return false;
    }

    private static final boolean transferUntil(PushbackInputStream i, OutputStream o, byte p) throws IOException {
        int b;
        while ((b = i.read()) > 0) {
            if ((b & 0xFF) == p) {
                return true;
            }
            o.write(b);
        }
        return false;
    }

    public static final void writeTemplate(String servletname, InputStream in, OutputStream out, serverObjects pattern) throws IOException {
        if (pattern == null) {
            FileUtils.copy(in, out);
        } else {
            TemplateEngine.writeTemplate(servletname, in, out, pattern, new byte[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] writeTemplate(String servletname, InputStream in, OutputStream out, serverObjects pattern, byte[] prefix) throws IOException {
        PushbackInputStream pis = new PushbackInputStream(in, 100);
        ByteArrayOutputStream keyStream = new ByteArrayOutputStream(4048);
        ByteBuffer structure = new ByteBuffer();
        String clientbrowserlang = pattern.get("clientlanguage");
        while (TemplateEngine.transferUntil(pis, out, (byte)35)) {
            byte[] key;
            String patternKey;
            Object text;
            int bb = pis.read();
            keyStream.reset();
            if ((bb & 0xFF) == 123) {
                if (!TemplateEngine.transferUntil(pis, (OutputStream)keyStream, mClose)) continue;
                bb = pis.read();
                if ((bb & 0xFF) != 10) {
                    pis.unread(bb);
                }
                byte[] multi_key = keyStream.toByteArray();
                keyStream.reset();
                int sep_char = -1;
                if (multi_key.length > 3 && multi_key[multi_key.length - 2] == 124) {
                    sep_char = multi_key[multi_key.length - 1];
                    byte[] a = new byte[multi_key.length - 2];
                    System.arraycopy(multi_key, 0, a, 0, multi_key.length - 2);
                    multi_key = a;
                }
                if (TemplateEngine.transferUntil(pis, (OutputStream)keyStream, TemplateEngine.appendBytes(mOpen, slashChar, multi_key, mClose))) {
                    bb = pis.read();
                    if ((bb & 0xFF) != 10) {
                        pis.unread(bb);
                    }
                    Object textsep = text = (Object)keyStream.toByteArray();
                    int p = ((Object)text).length;
                    if (sep_char != -1) {
                        byte[] a = new byte[p + 1];
                        System.arraycopy(text, 0, a, 0, p);
                        if (p >= 2 && a[p - 1] < 32 && a[p - 2] < 32) {
                            a[p] = a[p - 1];
                            a[p - 1] = a[p - 2];
                            a[p - 2] = sep_char;
                        } else if (p >= 1 && a[p - 1] < 32) {
                            a[p] = a[p - 1];
                            a[p - 1] = sep_char;
                        } else {
                            a[p] = sep_char;
                        }
                        textsep = a;
                    }
                    int num = 0;
                    patternKey = TemplateEngine.getPatternKey(prefix, multi_key);
                    if (pattern.containsKey(patternKey) && !pattern.get(patternKey).isEmpty()) {
                        try {
                            num = Integer.parseInt(pattern.get(patternKey));
                        }
                        catch (NumberFormatException e) {
                            ConcurrentLog.logException(e);
                            num = 0;
                        }
                    }
                    structure.append('<').append(multi_key).append(multi_num).append(ASCII.getBytes(Integer.toString(num))).append(close_quotetagn);
                    for (int i = 0; i < num; ++i) {
                        PushbackInputStream pis2 = new PushbackInputStream(new ByteArrayInputStream((byte[])(sep_char != -1 && i < num - 1 ? textsep : text)));
                        structure.append(TemplateEngine.writeTemplate(servletname, pis2, out, pattern, TemplateEngine.newPrefix(prefix, multi_key, i)));
                    }
                    structure.append(open_endtag).append(multi_key).append(close_tagn);
                    continue;
                }
                ConcurrentLog.severe("TEMPLATE", "No Close Key found for #{" + UTF8.String(multi_key) + "}# in " + servletname);
                continue;
            }
            if ((bb & 0xFF) == 40) {
                PushbackInputStream pis2;
                int others = 0;
                text = new ByteBuffer();
                TemplateEngine.transferUntil(pis, (OutputStream)keyStream, aClose);
                key = keyStream.toByteArray();
                keyStream.reset();
                boolean byName = false;
                int whichPattern = 0;
                byte[] patternName = new byte[]{};
                patternKey = TemplateEngine.getPatternKey(prefix, key);
                String patternId = pattern.get(patternKey);
                if (patternId == null) {
                    whichPattern = 0;
                } else if ("true".equals(patternId)) {
                    whichPattern = 1;
                } else if ("false".equals(patternId)) {
                    whichPattern = 0;
                } else {
                    try {
                        whichPattern = Integer.parseInt(patternId);
                    }
                    catch (NumberFormatException e) {
                        whichPattern = 0;
                        byName = true;
                        patternName = UTF8.getBytes(patternId);
                    }
                }
                int currentPattern = 0;
                boolean found = false;
                keyStream.reset();
                if (byName) {
                    TemplateEngine.transferUntil(pis, (OutputStream)keyStream, TemplateEngine.appendBytes(PP, patternName, null, null));
                    if (pis.available() == 0) {
                        ConcurrentLog.severe("TEMPLATE", "Bad Key-Value pair in #()# construct: key=\"" + patternKey + "\", value=\"" + UTF8.String(patternName) + "\" in " + servletname);
                        byte[] sb = structure.getBytes();
                        structure.close();
                        ((OutputStream)text).close();
                        return sb;
                    }
                    keyStream.reset();
                    TemplateEngine.transferUntil(pis, (OutputStream)keyStream, dpdpa);
                    pis2 = new PushbackInputStream(new ByteArrayInputStream(keyStream.toByteArray()));
                    structure.append(TemplateEngine.writeTemplate(servletname, pis2, out, pattern, TemplateEngine.newPrefix(prefix, key)));
                    TemplateEngine.transferUntil(pis, (OutputStream)keyStream, TemplateEngine.appendBytes(hash_brackopen_slash, key, brackclose_hash, null));
                    if (pis.available() == 0) {
                        ConcurrentLog.severe("TEMPLATE", "No Close Key found for #(" + UTF8.String(key) + ")# (by Name) in " + servletname);
                    }
                } else {
                    while (!found) {
                        bb = pis.read();
                        if ((bb & 0xFF) == 35) {
                            bb = pis.read();
                            if ((bb & 0xFF) == 40) {
                                TemplateEngine.transferUntil(pis, (OutputStream)keyStream, aClose);
                                if (Arrays.equals(keyStream.toByteArray(), TemplateEngine.appendBytes(slashChar, key, null, null))) {
                                    pis2 = new PushbackInputStream(new ByteArrayInputStream(((ByteBuffer)text).getBytes()));
                                    structure.append('<').append(key).append(alternative_which).append(ASCII.getBytes(Integer.toString(whichPattern))).append(ASCII.getBytes("\" found=\"0\">\n"));
                                    structure.append(TemplateEngine.writeTemplate(servletname, pis2, out, pattern, TemplateEngine.newPrefix(prefix, key)));
                                    structure.append(open_endtag).append(key).append(close_tagn);
                                    found = true;
                                } else if (others > 0 && keyStream.toString().startsWith("/")) {
                                    --others;
                                    ((ByteBuffer)text).append(aOpen).append(keyStream.toByteArray()).append(brackclose_hash);
                                } else {
                                    ++others;
                                    ((ByteBuffer)text).append(aOpen).append(keyStream.toByteArray()).append(brackclose_hash);
                                }
                                keyStream.reset();
                                continue;
                            }
                            pis.unread(bb);
                            bb = 35;
                        } else if ((bb & 0xFF) == 58 && others == 0) {
                            bb = pis.read();
                            if ((bb & 0xFF) == 58) {
                                if (currentPattern == whichPattern) {
                                    pis2 = new PushbackInputStream(new ByteArrayInputStream(((ByteBuffer)text).getBytes()));
                                    structure.append('<').append(key).append(alternative_which).append(ASCII.getBytes(Integer.toString(whichPattern))).append(ASCII.getBytes("\" found=\"0\">\n"));
                                    structure.append(TemplateEngine.writeTemplate(servletname, pis2, out, pattern, TemplateEngine.newPrefix(prefix, key)));
                                    structure.append(open_endtag).append(key).append(close_tagn);
                                    TemplateEngine.transferUntil(pis, (OutputStream)keyStream, TemplateEngine.appendBytes(hash_brackopen_slash, key, brackclose_hash, null));
                                    found = true;
                                }
                                ++currentPattern;
                                ((ByteBuffer)text).clear();
                                continue;
                            }
                            ((ByteBuffer)text).append(':');
                        }
                        if (found) continue;
                        ((ByteBuffer)text).append((byte)bb);
                    }
                }
                ((OutputStream)text).close();
                continue;
            }
            if ((bb & 0xFF) == 91) {
                if (TemplateEngine.transferUntil(pis, (OutputStream)keyStream, pClose)) {
                    key = keyStream.toByteArray();
                    String patternKey2 = TemplateEngine.getPatternKey(prefix, key);
                    byte[] replacement = TemplateEngine.replacePattern(patternKey2, pattern);
                    structure.append('<').append(key).append(ASCII.getBytes(" type=\"normal\">\n"));
                    structure.append(replacement);
                    structure.append(ASCII.getBytes("</")).append(key).append(close_tagn);
                    FileUtils.copy(replacement, out);
                    continue;
                }
                FileUtils.copy((InputStream)pis, out);
                pis.close();
                byte[] sb = structure.getBytes();
                structure.close();
                keyStream.close();
                return sb;
            }
            if ((bb & 0xFF) == 37) {
                keyStream.reset();
                if (!TemplateEngine.transferUntil(pis, (OutputStream)keyStream, iClose)) continue;
                byte[] filename = keyStream.toByteArray();
                if (filename[0] == 91 && filename[filename.length - 1] == 93) {
                    byte[] newFilename = new byte[filename.length - 2];
                    System.arraycopy(filename, 1, newFilename, 0, newFilename.length);
                    String patternkey = TemplateEngine.getPatternKey(prefix, newFilename);
                    filename = TemplateEngine.replacePattern(patternkey, pattern);
                }
                if (filename.length <= 0 || Arrays.equals(filename, UNRESOLVED_PATTERN)) continue;
                ByteBuffer include = new ByteBuffer();
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(HTTPDFileHandler.getLocalizedFile(UTF8.String(filename), clientbrowserlang)), StandardCharsets.UTF_8));
                    String line = "";
                    while ((line = br.readLine()) != null) {
                        include.append(UTF8.getBytes(line)).append(ASCII.getBytes(serverCore.CRLF_STRING));
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.severe("FILEHANDLER", "Include Error with file " + UTF8.String(filename) + ": " + e.getMessage());
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                            br = null;
                        }
                        catch (Exception e) {
                            ConcurrentLog.warn("FILEHANDLER", "Could not close buffered reader on file " + UTF8.String(filename));
                        }
                    }
                }
                PushbackInputStream pis2 = new PushbackInputStream(new ByteArrayInputStream(include.getBytes()));
                structure.append(ASCII.getBytes("<fileinclude file=\"")).append(filename).append(close_tagn);
                structure.append(TemplateEngine.writeTemplate(servletname, pis2, out, pattern, new byte[0]));
                structure.append(ASCII.getBytes("</fileinclude>\n"));
                include.close();
                continue;
            }
            out.write(35);
            out.write(bb);
        }
        byte[] sb = structure.getBytes();
        structure.close();
        return sb;
    }

    private static final byte[] replacePattern(String key, serverObjects pattern) {
        String value;
        byte[] replacement = pattern.containsKey(key) ? ((value = pattern.get(key)) instanceof byte[] ? (byte[])value : (value instanceof String ? UTF8.getBytes(value) : UTF8.getBytes(value.toString()))) : UNRESOLVED_PATTERN;
        return replacement;
    }

    private static final byte[] newPrefix(byte[] oldPrefix, byte[] key) {
        ByteBuffer newPrefix = new ByteBuffer(oldPrefix.length + key.length + 1);
        newPrefix.append(oldPrefix).append(key).append(ul);
        byte[] result = newPrefix.getBytes();
        try {
            newPrefix.close();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        return result;
    }

    private static final byte[] newPrefix(byte[] oldPrefix, byte[] multi_key, int i) {
        ByteBuffer newPrefix = new ByteBuffer(oldPrefix.length + multi_key.length + 8);
        newPrefix.append(oldPrefix).append(multi_key).append(ul).append(ASCII.getBytes(Integer.toString(i))).append(ul);
        try {
            newPrefix.close();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        return newPrefix.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getPatternKey(byte[] prefix, byte[] key) {
        ByteBuffer patternKey = new ByteBuffer(prefix.length + key.length);
        patternKey.append(prefix).append(key);
        try {
            String string = UTF8.String(patternKey.getBytes());
            return string;
        }
        finally {
            try {
                patternKey.close();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    private static final byte[] appendBytes(byte[] b1, byte[] b2, byte[] b3, byte[] b4) {
        ByteBuffer byteArray = new ByteBuffer(b1.length + b2.length + (b3 == null ? 0 : b3.length) + (b4 == null ? 0 : b4.length));
        byteArray.append(b1).append(b2);
        if (b3 != null) {
            byteArray.append(b3);
        }
        if (b4 != null) {
            byteArray.append(b4);
        }
        byte[] result = byteArray.getBytes();
        try {
            byteArray.close();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            ByteArrayInputStream i = new ByteArrayInputStream(UTF8.getBytes(args[0]));
            serverObjects h = new serverObjects();
            h.put("test", args[1]);
            TemplateEngine.writeTemplate("test", new PushbackInputStream(i, 100), System.out, h, UTF8.getBytes(args[2]));
            System.out.flush();
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
        }
    }
}

