/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.query;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.solr.Ranking;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.geo.GeoLocation;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.document.LibraryProvider;
import net.yacy.document.ProbabilisticClassifier;
import net.yacy.document.Tokenizer;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.data.word.WordReferenceRow;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.util.Bitfield;
import net.yacy.kelondro.util.SetTools;
import net.yacy.peers.Seed;
import net.yacy.search.index.Segment;
import net.yacy.search.navigator.NavigatorPlugins;
import net.yacy.search.navigator.NavigatorSort;
import net.yacy.search.query.QueryGoal;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.ranking.RankingProfile;
import net.yacy.search.schema.CollectionConfiguration;
import net.yacy.search.schema.CollectionSchema;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.solr.client.solrj.SolrQuery;

public final class QueryParams {
    public static final int FACETS_STANDARD_MAXCOUNT_DEFAULT = 100;
    public static final int FACETS_DATE_MAXCOUNT_DEFAULT = 640;
    private static final int FACETS_MAXCOUNT_FOR_RESORT_ON_SEARCH_NAV = 100000;
    private static final Map<String, CollectionSchema> defaultfacetfields = new HashMap<String, CollectionSchema>();
    private static final CollectionSchema[] SOLR_SNIPPET_FIELDS;
    public static final Bitfield empty_constraint;
    public static final Pattern catchall_pattern;
    private final QueryGoal queryGoal;
    public int itemsPerPage;
    public int offset;
    public Pattern urlMaskPattern;
    public Automaton urlMaskAutomaton;
    public String urlMaskString;
    public final Pattern prefer;
    public final String tld;
    public final String inlink;
    boolean urlMask_isCatchall;
    public final Classification.ContentDomain contentdom;
    private boolean strictContentDom = false;
    private int maxSuggestions = 0;
    public final String targetlang;
    protected final Collection<Tagging.Metatag> metatags;
    public final Searchdom domType;
    private final int zonecode;
    public final int maxDistance;
    public final Bitfield constraint;
    public final boolean allofconstraint;
    protected CacheStrategy snippetCacheStrategy;
    public final RankingProfile ranking;
    private final Segment indexSegment;
    public final String clienthost;
    protected final Set<String> siteexcludes;
    public final QueryModifier modifier;
    public Seed remotepeer;
    public final long starttime;
    protected final long maxtime;
    public int transmitcount;
    public long searchtime;
    public long urlretrievaltime;
    public long snippetcomputationtime;
    public final String userAgent;
    protected double lat;
    protected double lon;
    protected double radius;
    public Map<String, NavigatorSort> facetfields;
    private SolrQuery cachedQuery;
    private CollectionConfiguration solrSchema;
    public final int timezoneOffset;
    private int standardFacetsMaxCount;
    private int dateFacetMaxCount;
    private double kmNormal = 100.0;
    long year = 31536000000L;
    private volatile String idCacheAnon = null;
    private volatile String idCache = null;
    private static final char asterisk = '*';

    public QueryParams(QueryGoal queryGoal, QueryModifier modifier, int maxDistance, String prefer, Classification.ContentDomain contentdom, String language, int timezoneOffset, Collection<Tagging.Metatag> metatags, CacheStrategy snippetCacheStrategy, int itemsPerPage, int offset, String urlMask, String tld, String inlink, Searchdom domType, Bitfield constraint, boolean allofconstraint, Set<String> siteexcludes, int domainzone, String host, boolean specialRights, Segment indexSegment, RankingProfile ranking, String userAgent, double lat, double lon, double radius, Set<String> navConfigs) {
        this.queryGoal = queryGoal;
        this.modifier = modifier;
        this.ranking = ranking;
        this.maxDistance = maxDistance;
        this.contentdom = contentdom;
        this.timezoneOffset = timezoneOffset;
        this.itemsPerPage = Math.min(specialRights ? 10000 : 1000, itemsPerPage);
        this.offset = domType == Searchdom.LOCAL ? Math.max(0, offset) : Math.max(0, Math.min(specialRights ? 10000 - this.itemsPerPage : 1000 - this.itemsPerPage, offset));
        try {
            int p;
            this.urlMaskString = urlMask;
            while ((p = this.urlMaskString.indexOf(58)) >= 0) {
                this.urlMaskString = this.urlMaskString.substring(0, p) + "." + this.urlMaskString.substring(p + 1);
            }
            while ((p = this.urlMaskString.indexOf(47)) >= 0) {
                this.urlMaskString = this.urlMaskString.substring(0, p) + "." + this.urlMaskString.substring(p + 1);
            }
            while ((p = this.urlMaskString.indexOf(92)) >= 0) {
                this.urlMaskString = this.urlMaskString.substring(0, p) + "." + this.urlMaskString.substring(p + 2);
            }
            this.urlMaskAutomaton = Automata.makeString((String)this.urlMaskString);
            this.urlMaskPattern = Pattern.compile(this.urlMaskString);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Not a valid regular expression: " + urlMask, ex);
        }
        this.urlMask_isCatchall = this.urlMaskString.equals(catchall_pattern.toString());
        if (this.urlMask_isCatchall) {
            String filter = QueryParams.buildApproximateURLFilter(modifier, tld);
            if (!catchall_pattern.toString().equals(filter)) {
                this.urlMaskString = filter;
                this.urlMaskAutomaton = Automata.makeString((String)filter);
                this.urlMask_isCatchall = false;
                this.urlMaskPattern = null;
            }
        }
        this.tld = tld;
        this.inlink = inlink;
        try {
            this.prefer = Pattern.compile(prefer);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("Not a valid regular expression: " + prefer, ex);
        }
        assert (language != null);
        this.targetlang = language;
        this.metatags = metatags;
        this.domType = domType;
        this.zonecode = domainzone;
        this.constraint = constraint;
        this.allofconstraint = allofconstraint;
        this.siteexcludes = siteexcludes != null && siteexcludes.isEmpty() ? null : siteexcludes;
        this.snippetCacheStrategy = snippetCacheStrategy;
        this.clienthost = host;
        this.remotepeer = null;
        this.starttime = System.currentTimeMillis();
        this.maxtime = 10000L;
        this.indexSegment = indexSegment;
        this.userAgent = userAgent;
        this.transmitcount = 0;
        this.lat = Math.floor(lat * this.kmNormal) / this.kmNormal;
        this.lon = Math.floor(lon * this.kmNormal) / this.kmNormal;
        this.radius = Math.floor(radius * this.kmNormal + 1.0) / this.kmNormal;
        this.facetfields = new HashMap<String, NavigatorSort>();
        this.solrSchema = indexSegment.fulltext().getDefaultConfiguration();
        for (String navConfig : navConfigs) {
            CollectionSchema f = defaultfacetfields.get(NavigatorPlugins.getNavName(navConfig));
            if (f == null || !this.solrSchema.contains(f) && f != CollectionSchema.author_sxt && f != CollectionSchema.coordinate_p_0_coordinate) continue;
            this.facetfields.put(f.getSolrFieldName(), NavigatorPlugins.parseNavSortConfig(navConfig));
        }
        if (LibraryProvider.autotagging != null) {
            for (Tagging v : LibraryProvider.autotagging.getVocabularies()) {
                if (!v.isFacet()) continue;
                this.facetfields.put("vocabulary_" + v.getName() + "_sxt", NavigatorSort.COUNT_DESC);
            }
        }
        for (String context : ProbabilisticClassifier.getContextNames()) {
            this.facetfields.put("vocabulary_" + context + "_sxt", NavigatorSort.COUNT_DESC);
        }
        this.cachedQuery = null;
        this.standardFacetsMaxCount = 100;
        this.dateFacetMaxCount = 640;
    }

    protected static String buildApproximateURLFilter(QueryModifier modifier, String tld) {
        String filefilter;
        String protocolfilter = modifier.protocol == null ? ".*" : modifier.protocol;
        String defaulthostprefix = "www";
        Object hostfilter = modifier.sitehost == null && tld == null ? ".*" : (modifier.sitehost == null ? ".*\\." + tld : (modifier.sitehost.startsWith("www.") ? "(www\\.)?" + modifier.sitehost.substring(4) : "(www\\.)?" + modifier.sitehost));
        Object filter = protocolfilter + "..." + (String)hostfilter + "." + (filefilter = modifier.filetype == null ? ".*" : ".*" + modifier.filetype + ".*");
        if (!((String)filter).equals(".*....*..*")) {
            Matcher m;
            Pattern r = Pattern.compile("(\\.|(\\.\\*))\\.\\*");
            while ((m = r.matcher((CharSequence)filter)).find()) {
                filter = m.replaceAll(".*");
            }
        } else {
            filter = catchall_pattern.toString();
        }
        return filter;
    }

    public Segment getSegment() {
        return this.indexSegment;
    }

    public int neededResults() {
        return this.offset + this.itemsPerPage;
    }

    public int itemsPerPage() {
        return this.itemsPerPage;
    }

    public void setOffset(int newOffset) {
        this.offset = newOffset;
    }

    public boolean isLocal() {
        return this.domType == Searchdom.LOCAL;
    }

    public int getStandardFacetsMaxCount() {
        return this.standardFacetsMaxCount;
    }

    public void setStandardFacetsMaxCount(int standardFacetsMaxCount) {
        this.standardFacetsMaxCount = standardFacetsMaxCount;
    }

    public int getDateFacetMaxCount() {
        return this.dateFacetMaxCount;
    }

    public void setDateFacetMaxCount(int dateFacetMaxCount) {
        this.dateFacetMaxCount = dateFacetMaxCount;
    }

    public boolean isStrictContentDom() {
        return this.strictContentDom;
    }

    public void setStrictContentDom(boolean strictContentDom) {
        this.strictContentDom = strictContentDom;
    }

    public int getMaxSuggestions() {
        return this.maxSuggestions;
    }

    public void setMaxSuggestions(int maxSuggestions) {
        this.maxSuggestions = maxSuggestions;
    }

    public static HandleSet hashes2Set(String query2) {
        RowHandleSet keyhashes = new RowHandleSet(WordReferenceRow.urlEntryRow.primaryKeyLength, WordReferenceRow.urlEntryRow.objectOrder, 0);
        if (query2 != null) {
            for (int i = 0; i < query2.length() / 12; ++i) {
                try {
                    keyhashes.put(ASCII.getBytes(query2.substring(i * 12, (i + 1) * 12)));
                    continue;
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        return keyhashes;
    }

    public static String hashSet2hashString(HandleSet hashes) {
        byte[] bb = new byte[hashes.size() * 12];
        int p = 0;
        for (byte[] b : hashes) {
            assert (b.length == 12) : "hash = " + ASCII.String(b);
            System.arraycopy(b, 0, bb, p, 12);
            p += 12;
        }
        return ASCII.String(bb);
    }

    public static String hashSet2hashString(Set<String> hashes) {
        byte[] bb = new byte[hashes.size() * 12];
        int p = 0;
        for (String s : hashes) {
            assert (s.length() == 12) : "hash = " + s;
            System.arraycopy(ASCII.getBytes(s), 0, bb, p, 12);
            p += 12;
        }
        return ASCII.String(bb);
    }

    public static String anonymizedQueryHashes(HandleSet hashes) {
        byte[] hash;
        Iterator<byte[]> i = hashes.iterator();
        StringBuilder sb = new StringBuilder(hashes.size() * 14 + 2);
        sb.append("[");
        if (i.hasNext()) {
            hash = i.next();
            sb.append(ASCII.String(hash).substring(0, 3)).append(".........");
        }
        while (i.hasNext()) {
            hash = i.next();
            sb.append(", ").append(ASCII.String(hash).substring(0, 3)).append(".........");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String matchesURL(QueryModifier modifier, String tld, MultiProtocolURL url) {
        if (url == null) {
            return "url";
        }
        if (modifier != null) {
            if (modifier.protocol != null && !modifier.protocol.equalsIgnoreCase(url.getProtocol())) {
                return "protocol";
            }
            if (modifier.sitehost != null) {
                String host;
                Object hostWithWwwPrefix;
                String wwwPrefix = "www.";
                if (modifier.sitehost.startsWith("www.")) {
                    hostWithWwwPrefix = modifier.sitehost;
                    host = modifier.sitehost.substring("www.".length());
                } else {
                    hostWithWwwPrefix = "www." + modifier.sitehost;
                    host = modifier.sitehost;
                }
                if (!host.equalsIgnoreCase(url.getHost()) && !((String)hostWithWwwPrefix).equals(url.getHost())) {
                    return "sitehost";
                }
            }
            if (tld != null && !tld.equalsIgnoreCase(url.getTLD())) {
                return "tld";
            }
            if (modifier.filetype != null && !modifier.filetype.equalsIgnoreCase(MultiProtocolURL.getFileExtension(url.getFileName()))) {
                return "filetype";
            }
        }
        return "";
    }

    private final boolean matchesText(String text) {
        boolean ret = false;
        QueryGoal.NormalizedWords words = new QueryGoal.NormalizedWords((Collection<String>)Tokenizer.getWords(text, null).keySet());
        if (!SetTools.anymatchByTest(this.queryGoal.getExcludeWords(), words)) {
            ret = SetTools.totalInclusion(this.queryGoal.getIncludeWords(), words);
        }
        return ret;
    }

    protected static final boolean anymatch(String text, Iterator<String> keywords) {
        if (keywords == null || !keywords.hasNext()) {
            return false;
        }
        SortedSet textwords = (SortedSet)Tokenizer.getWords(text, null).keySet();
        return SetTools.anymatchByTest(keywords, textwords);
    }

    public SolrQuery solrQuery(Classification.ContentDomain cd, boolean strictContentDom, boolean getFacets, boolean excludeintext_image) {
        List<String> filterQueries;
        if (cd == Classification.ContentDomain.IMAGE) {
            return this.solrImageQuery(getFacets, strictContentDom);
        }
        switch (cd) {
            case AUDIO: {
                filterQueries = this.queryGoal.collectionAudioFilterQuery(strictContentDom);
                break;
            }
            case VIDEO: {
                filterQueries = this.queryGoal.collectionVideoFilterQuery(strictContentDom);
                break;
            }
            case APP: {
                filterQueries = this.queryGoal.collectionApplicationFilterQuery(strictContentDom);
                break;
            }
            default: {
                filterQueries = this.queryGoal.collectionTextFilterQuery(excludeintext_image);
            }
        }
        return this.solrQuery(getFacets, filterQueries);
    }

    private SolrQuery solrQuery(boolean getFacets, List<String> filterQueries) {
        if (this.cachedQuery != null) {
            this.cachedQuery.setStart(Integer.valueOf(this.offset));
            if (!getFacets) {
                this.cachedQuery.setFacet(false);
            }
            return this.cachedQuery;
        }
        SolrQuery params = this.getBasicParams(getFacets, filterQueries);
        int rankingProfile = this.ranking.coeff_date == 15 ? 1 : (this.modifier.sitehash != null || this.modifier.sitehost != null ? 2 : 0);
        params.setQuery(this.queryGoal.collectionTextQuery().toString());
        Ranking actRanking = this.indexSegment.fulltext().getDefaultConfiguration().getRanking(rankingProfile);
        String fq = actRanking.getFilterQuery();
        Object bq = actRanking.getBoostQuery();
        String bf = actRanking.getBoostFunction();
        String qf = actRanking.getQueryFields();
        if (!qf.isEmpty()) {
            params.setParam("qf", new String[]{qf});
        }
        if (this.queryGoal.getIncludeSize() > 1) {
            if (((String)bq).length() > 0) {
                bq = (String)bq + "\n";
            }
            bq = (String)bq + CollectionSchema.text_t.getSolrFieldName() + ":\"" + this.queryGoal.getIncludeString() + "\"^10";
        }
        if (fq.length() > 0) {
            String[] oldfq = params.getFilterQueries();
            ArrayList<String> newfq = new ArrayList<String>(oldfq.length + 1);
            for (String x : oldfq) {
                newfq.add(x);
            }
            newfq.add(fq);
            params.setFilterQueries(newfq.toArray(new String[newfq.size()]));
        }
        if (((String)bq).length() > 0) {
            params.setParam("bq", ((String)bq).split("[\\r\\n]+"));
        }
        if (bf.length() > 0) {
            params.setParam("boost", new String[]{bf});
        }
        if (this.contentdom == Classification.ContentDomain.TEXT || this.contentdom == Classification.ContentDomain.ALL) {
            params.setHighlight(true);
            params.setHighlightFragsize(220);
            params.setHighlightSimplePost("</b>");
            params.setHighlightSimplePre("<b>");
            params.setHighlightSnippets(5);
            for (CollectionSchema field : SOLR_SNIPPET_FIELDS) {
                params.addHighlightField(field.getSolrFieldName());
            }
        } else {
            params.setHighlight(false);
        }
        ConcurrentLog.info("Protocol", "SOLR QUERY: " + params.toString());
        this.cachedQuery = params;
        return params;
    }

    private SolrQuery solrImageQuery(boolean getFacets, boolean strictContentDom) {
        if (this.cachedQuery != null) {
            this.cachedQuery.setStart(Integer.valueOf(this.offset));
            if (!getFacets) {
                this.cachedQuery.setFacet(false);
            }
            return this.cachedQuery;
        }
        SolrQuery params = this.getBasicParams(getFacets, this.queryGoal.collectionImageFilterQuery(strictContentDom));
        params.setQuery(this.queryGoal.collectionImageQuery(this.modifier).toString());
        if (!strictContentDom) {
            StringBuilder bq = new StringBuilder();
            bq.append(CollectionSchema.url_file_ext_s.getSolrFieldName()).append(":\"jpg\"");
            bq.append(" OR ").append(CollectionSchema.url_file_ext_s.getSolrFieldName()).append(":\"tif\"");
            bq.append(" OR ").append(CollectionSchema.url_file_ext_s.getSolrFieldName()).append(":\"tiff\"");
            bq.append(" OR ").append(CollectionSchema.url_file_ext_s.getSolrFieldName()).append(":\"png\"");
            params.setParam("bq", new String[]{bq.toString()});
        }
        ConcurrentLog.info("Protocol", "SOLR QUERY: " + params.toString());
        this.cachedQuery = params;
        return params;
    }

    private void fillSolrParamWithNavSort(SolrQuery params, String solrFieldName, NavigatorSort navSort) {
        if (params != null && solrFieldName != null && navSort != null) {
            switch (navSort) {
                case COUNT_ASC: {
                    params.setParam("f." + solrFieldName + ".facet.sort", new String[]{"count"});
                    params.setParam("f." + solrFieldName + ".facet.limit", new String[]{String.valueOf(100000)});
                    break;
                }
                case LABEL_DESC: {
                    params.setParam("f." + solrFieldName + ".facet.sort", new String[]{"index"});
                    params.setParam("f." + solrFieldName + ".facet.limit", new String[]{String.valueOf(100000)});
                    break;
                }
                case LABEL_ASC: {
                    params.setParam("f." + solrFieldName + ".facet.sort", new String[]{"index"});
                    break;
                }
            }
            if (CollectionSchema.language_s.getSolrFieldName().equals(solrFieldName) || CollectionSchema.url_file_ext_s.getSolrFieldName().equals(solrFieldName) || CollectionSchema.collection_sxt.getSolrFieldName().equals(solrFieldName)) {
                params.setParam("f." + solrFieldName + ".facet.limit", new String[]{String.valueOf(100000)});
            }
        }
    }

    private SolrQuery getBasicParams(boolean getFacets, List<String> fqs) {
        SolrQuery params = new SolrQuery();
        params.setParam("defType", new String[]{"edismax"});
        params.setParam("qf", new String[]{CollectionSchema.text_t.getSolrFieldName() + "^1.0"});
        params.setStart(Integer.valueOf(this.offset));
        params.setRows(Integer.valueOf(this.itemsPerPage));
        params.setFacet(false);
        if (this.ranking.coeff_date == 15) {
            params.setSort(new SolrQuery.SortClause(CollectionSchema.last_modified.getSolrFieldName(), SolrQuery.ORDER.desc));
        }
        fqs.addAll(this.getFacetsFilterQueries());
        if (fqs.size() > 0) {
            params.setFilterQueries(fqs.toArray(new String[fqs.size()]));
        }
        if (getFacets && this.facetfields.size() > 0) {
            params.setFacet(true);
            params.setFacetMinCount(1);
            params.setFacetLimit(this.standardFacetsMaxCount);
            params.setFacetSort("count");
            params.setParam("facet.method", new String[]{"enum"});
            for (Map.Entry<String, NavigatorSort> entry2 : this.facetfields.entrySet()) {
                params.addFacetField(new String[]{"{!ex=" + entry2.getKey() + "}" + entry2.getKey()});
                this.fillSolrParamWithNavSort(params, entry2.getKey(), entry2.getValue());
            }
            NavigatorSort datesInContentSort = this.facetfields.get(CollectionSchema.dates_in_content_dts.name());
            if (datesInContentSort != null) {
                params.setParam("facet.range", new String[]{CollectionSchema.dates_in_content_dts.name()});
                String start = new Date(System.currentTimeMillis() - 259200000L).toInstant().toString();
                String end = new Date(System.currentTimeMillis() + 259200000L).toInstant().toString();
                params.setParam("f." + CollectionSchema.dates_in_content_dts.getSolrFieldName() + ".facet.range.start", new String[]{start});
                params.setParam("f." + CollectionSchema.dates_in_content_dts.getSolrFieldName() + ".facet.range.end", new String[]{end});
                params.setParam("f." + CollectionSchema.dates_in_content_dts.getSolrFieldName() + ".facet.range.gap", new String[]{"+1DAY"});
                this.fillSolrParamWithNavSort(params, CollectionSchema.dates_in_content_dts.getSolrFieldName(), datesInContentSort);
                params.setParam("f." + CollectionSchema.dates_in_content_dts.getSolrFieldName() + ".facet.limit", new String[]{Integer.toString(this.dateFacetMaxCount)});
            }
        } else {
            params.setFacet(false);
        }
        params.setFields(new String[]{"*", "score"});
        return params;
    }

    private List<String> getFacetsFilterQueries() {
        ArrayList<String> fqs = new ArrayList<String>();
        if (this.modifier.sitehash == null && this.modifier.sitehost == null) {
            if (this.siteexcludes != null) {
                for (String ex : this.siteexcludes) {
                    fqs.add("-" + CollectionSchema.host_id_s.getSolrFieldName() + ":" + ex);
                }
            }
        } else if (this.modifier.sitehost != null) {
            if (this.modifier.sitehost.startsWith("www.")) {
                fqs.add(CollectionSchema.host_s.getSolrFieldName() + ":\"" + this.modifier.sitehost.substring(4) + "\" OR " + CollectionSchema.host_s.getSolrFieldName() + ":\"" + this.modifier.sitehost + "\"");
            } else {
                fqs.add(CollectionSchema.host_s.getSolrFieldName() + ":\"" + this.modifier.sitehost + "\" OR " + CollectionSchema.host_s.getSolrFieldName() + ":\"www." + this.modifier.sitehost + "\"");
            }
        } else {
            fqs.add(CollectionSchema.host_id_s.getSolrFieldName() + ":\"" + this.modifier.sitehash + "\"");
        }
        if (this.metatags != null) {
            for (Tagging.Metatag tag : this.metatags) {
                fqs.add("vocabulary_" + tag.getVocabularyName() + "_sxt:\"" + tag.getObject() + "\"");
            }
        }
        if (this.modifier.language != null && this.modifier.language.length() > 0 && this.solrSchema.contains(CollectionSchema.language_s)) {
            fqs.add(CollectionSchema.language_s.getSolrFieldName() + ":\"" + this.modifier.language + "\"");
        }
        if (this.modifier.author != null && this.modifier.author.length() > 0 && this.solrSchema.contains(CollectionSchema.author)) {
            fqs.add(CollectionSchema.author_sxt.getSolrFieldName() + ":\"" + this.modifier.author + "\"");
        }
        if (this.modifier.keyword != null && this.modifier.keyword.length() > 0 && this.solrSchema.contains(CollectionSchema.keywords)) {
            fqs.add(CollectionSchema.keywords.getSolrFieldName() + ":\"" + this.modifier.keyword + "\"");
        }
        if (this.modifier.collection != null && this.modifier.collection.length() > 0 && this.solrSchema.contains(CollectionSchema.collection_sxt)) {
            fqs.add(QueryModifier.parseCollectionExpression(this.modifier.collection));
        }
        if (this.solrSchema.contains(CollectionSchema.dates_in_content_dts)) {
            if (this.modifier.on != null && this.modifier.on.length() > 0) {
                fqs.add(QueryModifier.parseOnExpression(this.modifier.on, this.timezoneOffset));
            }
            if (this.modifier.from != null && this.modifier.from.length() > 0 && (this.modifier.to == null || this.modifier.to.equals("*"))) {
                fqs.add(QueryModifier.parseFromToExpression(this.modifier.from, null, this.timezoneOffset));
            }
            if ((this.modifier.from == null || this.modifier.from.equals("*")) && this.modifier.to != null && this.modifier.to.length() > 0) {
                fqs.add(QueryModifier.parseFromToExpression(null, this.modifier.to, this.timezoneOffset));
            }
            if (this.modifier.from != null && this.modifier.from.length() > 0 && this.modifier.to != null && this.modifier.to.length() > 0) {
                fqs.add(QueryModifier.parseFromToExpression(this.modifier.from, this.modifier.to, this.timezoneOffset));
            }
        }
        if (this.modifier.protocol != null) {
            fqs.add("{!tag=" + CollectionSchema.url_protocol_s.getSolrFieldName() + "}" + CollectionSchema.url_protocol_s.getSolrFieldName() + ":" + this.modifier.protocol);
        }
        if (this.tld != null) {
            fqs.add(CollectionSchema.host_s.getSolrFieldName() + ":*." + this.tld);
        }
        if (this.modifier.filetype != null) {
            fqs.add(CollectionSchema.url_file_ext_s.getSolrFieldName() + ":\"" + this.modifier.filetype + "\"");
        }
        if (this.inlink != null) {
            fqs.add(CollectionSchema.outboundlinks_urlstub_sxt.getSolrFieldName() + ":\"" + this.inlink + "\"");
        }
        if (!this.urlMask_isCatchall && this.urlMaskPattern != null) {
            fqs.add(CollectionSchema.sku.getSolrFieldName() + ":/" + this.urlMaskString + "/");
        }
        if (this.radius > 0.0 && this.lat != 0.0 && this.lon != 0.0) {
            fqs.add("{!bbox sfield=" + CollectionSchema.coordinate_p.getSolrFieldName() + " pt=" + Double.toString(this.lat) + "," + Double.toString(this.lon) + " d=" + GeoLocation.degreeToKm(this.radius) + "}");
        }
        return fqs;
    }

    public QueryGoal getQueryGoal() {
        return this.queryGoal;
    }

    public final Map<AnchorURL, String> separateMatches(Map<AnchorURL, String> links) {
        HashMap<AnchorURL, String> matcher = new HashMap<AnchorURL, String>();
        Iterator<Map.Entry<AnchorURL, String>> i = links.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<AnchorURL, String> entry2 = i.next();
            AnchorURL url = entry2.getKey();
            String anchorText = entry2.getValue();
            if (!this.matchesText(anchorText)) continue;
            matcher.put(url, anchorText);
            i.remove();
        }
        return matcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String id(boolean anonymized) {
        if (anonymized) {
            if (this.idCacheAnon != null) {
                return this.idCacheAnon;
            }
        } else if (this.idCache != null) {
            return this.idCache;
        }
        QueryParams queryParams = this;
        synchronized (queryParams) {
            if (anonymized) {
                if (this.idCacheAnon != null) {
                    return this.idCacheAnon;
                }
            } else if (this.idCache != null) {
                return this.idCache;
            }
            StringBuilder context = new StringBuilder(180);
            if (anonymized) {
                context.append(QueryParams.anonymizedQueryHashes(this.queryGoal.getIncludeHashes()));
                context.append('-');
                context.append(QueryParams.anonymizedQueryHashes(this.queryGoal.getExcludeHashes()));
            } else {
                context.append(QueryParams.hashSet2hashString(this.queryGoal.getIncludeHashes()));
                context.append('-');
                context.append(QueryParams.hashSet2hashString(this.queryGoal.getExcludeHashes()));
            }
            context.append('*');
            context.append((Object)this.contentdom).append('*');
            context.append(this.strictContentDom).append('*');
            context.append(this.zonecode).append('*');
            context.append(ASCII.String(Word.word2hash(this.ranking.toExternalString()))).append('*');
            context.append(Base64Order.enhancedCoder.encodeString(this.prefer.toString())).append('*');
            context.append(Base64Order.enhancedCoder.encodeString(this.urlMaskString)).append('*');
            context.append(this.modifier.sitehash).append('*');
            context.append(this.modifier.author).append('*');
            context.append(this.modifier.protocol).append('*');
            context.append(this.modifier.filetype).append('*');
            context.append(this.modifier.collection).append('*');
            context.append(this.modifier.toString()).append('*');
            context.append(this.siteexcludes).append('*');
            context.append(this.targetlang).append('*');
            context.append((Object)this.domType).append('*');
            context.append(this.constraint).append('*');
            context.append(this.maxDistance).append('*');
            context.append(this.tld).append('*');
            context.append(this.inlink).append('*');
            context.append(this.lat).append('*').append(this.lon).append('*').append(this.radius).append('*');
            context.append(this.snippetCacheStrategy == null ? "null" : this.snippetCacheStrategy.name());
            String result = context.toString();
            if (anonymized) {
                this.idCacheAnon = result;
            } else {
                this.idCache = result;
            }
            return result;
        }
    }

    public static StringBuilder navurl(RequestHeader.FileType ext, int page, QueryParams theQuery, String newModifier, boolean newModifierReplacesOld, boolean authenticatedFeatures) {
        StringBuilder sb = QueryParams.navurlBase(ext, theQuery, newModifier, newModifierReplacesOld, authenticatedFeatures);
        sb.append("&startRecord=");
        sb.append(page * theQuery.itemsPerPage());
        return sb;
    }

    public static String navUrlWithSingleModifierRemoved(RequestHeader.FileType ext, int page, QueryParams theQuery, String modifierToRemove, boolean authenticatedFeatures) {
        StringBuilder sb = new StringBuilder(120);
        sb.append("yacysearch.");
        sb.append(ext.name().toLowerCase(Locale.ROOT));
        sb.append("?query=");
        sb.append(theQuery.getQueryGoal().getQueryString(true));
        if (!theQuery.modifier.isEmpty()) {
            String modifierString = theQuery.modifier.toString();
            if (StringUtils.isNotBlank((CharSequence)modifierToRemove)) {
                modifierString = modifierString.startsWith(modifierToRemove) ? modifierString.substring(modifierToRemove.length()) : modifierString.replace(" " + modifierToRemove, "");
            }
            if (StringUtils.isNotBlank((CharSequence)modifierString)) {
                sb.append("+" + modifierString.trim());
            }
        }
        QueryParams.appendNavUrlQueryParams(sb, theQuery, authenticatedFeatures);
        return sb.toString();
    }

    public static String navUrlWithNewQueryString(RequestHeader.FileType ext, int page, QueryParams theQuery, String newQueryString, boolean authenticatedFeatures) {
        StringBuilder sb = new StringBuilder(120);
        sb.append("yacysearch.");
        sb.append(ext.name().toLowerCase(Locale.ROOT));
        sb.append("?query=");
        sb.append(new QueryGoal(newQueryString).getQueryString(true));
        if (!theQuery.modifier.isEmpty()) {
            sb.append("+" + theQuery.modifier.toString());
        }
        QueryParams.appendNavUrlQueryParams(sb, theQuery, authenticatedFeatures);
        return sb.toString();
    }

    public static StringBuilder navurlBase(RequestHeader.FileType ext, QueryParams theQuery, String newModifier, boolean newModifierReplacesOld, boolean authenticatedFeatures) {
        StringBuilder sb = new StringBuilder(120);
        sb.append("yacysearch.");
        sb.append(ext.name().toLowerCase(Locale.ROOT));
        sb.append("?query=");
        sb.append(theQuery.getQueryGoal().getQueryString(true));
        if (newModifier == null) {
            if (!theQuery.modifier.isEmpty()) {
                sb.append("+" + theQuery.modifier.toString());
            }
        } else if (!newModifier.isEmpty()) {
            if (!theQuery.modifier.isEmpty()) {
                sb.append("+" + theQuery.modifier.toString());
            }
            if (newModifierReplacesOld) {
                QueryParams.removeOldModifiersFromNavUrl(sb, newModifier);
            }
            try {
                sb.append("+" + URLEncoder.encode(newModifier, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                sb.append("+" + newModifier);
            }
        }
        QueryParams.appendNavUrlQueryParams(sb, theQuery, authenticatedFeatures);
        return sb;
    }

    protected static void appendNavUrlQueryParams(StringBuilder sb, QueryParams theQuery, boolean authenticatedFeatures) {
        sb.append("&maximumRecords=");
        sb.append(theQuery.itemsPerPage());
        sb.append("&resource=");
        sb.append(theQuery.isLocal() ? "local" : "global");
        sb.append("&verify=");
        sb.append(theQuery.snippetCacheStrategy == null ? "false" : theQuery.snippetCacheStrategy.toName());
        sb.append("&prefermaskfilter=");
        sb.append(theQuery.prefer);
        sb.append("&cat=href");
        sb.append("&constraint=");
        sb.append(theQuery.constraint == null ? "" : theQuery.constraint.exportB64());
        sb.append("&contentdom=");
        sb.append(theQuery.contentdom.toString());
        sb.append("&strictContentDom=");
        sb.append(String.valueOf(theQuery.isStrictContentDom()));
        sb.append("&meanCount=");
        sb.append(theQuery.getMaxSuggestions());
        sb.append("&former=");
        sb.append(theQuery.getQueryGoal().getQueryString(true));
        if (authenticatedFeatures) {
            sb.append("&auth");
        }
    }

    protected static void removeOldModifiersFromNavUrl(StringBuilder sb, String newModifier) {
        int nmpi = newModifier.indexOf(":");
        if (nmpi > 0) {
            String newModifierKey = newModifier.substring(0, nmpi) + ":";
            int sameModifierIndex = sb.indexOf(newModifierKey);
            while (sameModifierIndex > 0) {
                int spaceModifierIndex = sb.indexOf(" ", sameModifierIndex);
                if (spaceModifierIndex > sameModifierIndex) {
                    sb.delete(sameModifierIndex, spaceModifierIndex + 1);
                } else {
                    sb.setLength(sameModifierIndex);
                }
                sameModifierIndex = sb.indexOf(newModifierKey);
            }
            if (sb.charAt(sb.length() - 1) == '+') {
                sb.setLength(sb.length() - 1);
            }
            if (sb.charAt(sb.length() - 1) == ' ') {
                sb.setLength(sb.length() - 1);
            }
        }
    }

    static {
        defaultfacetfields.put("hosts", CollectionSchema.host_s);
        defaultfacetfields.put("protocol", CollectionSchema.url_protocol_s);
        defaultfacetfields.put("filetype", CollectionSchema.url_file_ext_s);
        defaultfacetfields.put("date", CollectionSchema.dates_in_content_dts);
        defaultfacetfields.put("authors", CollectionSchema.author_sxt);
        defaultfacetfields.put("collections", CollectionSchema.collection_sxt);
        defaultfacetfields.put("language", CollectionSchema.language_s);
        SOLR_SNIPPET_FIELDS = new CollectionSchema[]{CollectionSchema.description_txt, CollectionSchema.h4_txt, CollectionSchema.h3_txt, CollectionSchema.h2_txt, CollectionSchema.h1_txt, CollectionSchema.text_t};
        empty_constraint = new Bitfield(4, "AAAAAA");
        catchall_pattern = Pattern.compile(".*");
    }

    public static enum Searchdom {
        LOCAL,
        CLUSTER,
        GLOBAL;


        public String toString() {
            if (this == LOCAL) {
                return "local";
            }
            if (this == CLUSTER) {
                return "global";
            }
            if (this == GLOBAL) {
                return "global";
            }
            return "local";
        }
    }
}

