/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.workflow;

import java.util.concurrent.atomic.AtomicInteger;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.workflow.AbstractBlockingThread;
import net.yacy.kelondro.workflow.BlockingThread;
import net.yacy.kelondro.workflow.WorkflowJob;
import net.yacy.kelondro.workflow.WorkflowProcessor;
import net.yacy.kelondro.workflow.WorkflowTask;

public class InstantBlockingThread<J extends WorkflowJob>
extends AbstractBlockingThread<J>
implements BlockingThread<J> {
    private static final String BLOCKINGTHREAD = "BLOCKINGTHREAD";
    private final WorkflowTask<J> task;
    private static AtomicInteger handleCounter = new AtomicInteger(0);
    private static AtomicInteger instantThreadCounter = new AtomicInteger(0);

    public InstantBlockingThread(WorkflowProcessor<J> manager) {
        this.setManager(manager);
        this.task = manager.getTask();
        this.setName(manager.getName() + "." + handleCounter.getAndIncrement());
    }

    @Override
    public int getJobCount() {
        return this.getManager().getQueueSize();
    }

    @Override
    public J job(J next) throws Exception {
        WorkflowJob out = null;
        if (next == null) {
            out = WorkflowJob.poisonPill;
        } else if (next == WorkflowJob.poisonPill || ((WorkflowJob)next).status == 99) {
            out = next;
        } else {
            long t = System.currentTimeMillis();
            instantThreadCounter.incrementAndGet();
            try {
                out = (WorkflowJob)this.task.process(next);
            }
            catch (Throwable e) {
                ConcurrentLog.severe(BLOCKINGTHREAD, "Internal Error in serverInstantThread.job: " + e.getMessage());
                ConcurrentLog.severe(BLOCKINGTHREAD, "shutting down thread '" + this.getName() + "'");
                ConcurrentLog.logException(e);
                ConcurrentLog.logException(e.getCause());
                ConcurrentLog.severe(BLOCKINGTHREAD, "Runtime Error in serverInstantThread.job, thread '" + this.getName() + "': " + e.getMessage());
            }
            instantThreadCounter.decrementAndGet();
            this.getManager().increaseJobTime(System.currentTimeMillis() - t);
        }
        return (J)out;
    }
}

