/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.table;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.NumberTools;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.table.Table;

public class Relations {
    private final File baseDir;
    private HashMap<String, Index> relations;
    private final boolean useTailCache;
    private final boolean exceed134217727;

    public Relations(File location, boolean useTailCache, boolean exceed134217727) {
        this.baseDir = location;
        this.useTailCache = useTailCache;
        this.exceed134217727 = exceed134217727;
    }

    private static Row rowdef(String filename) {
        int p = filename.lastIndexOf(46);
        if (p >= 0) {
            filename = filename.substring(0, p);
        }
        p = filename.lastIndexOf(45);
        assert (p >= 0);
        int payloadsize = NumberTools.parseIntDecSubstring(filename, p + 1);
        filename = filename.substring(0, p);
        p = filename.lastIndexOf(45);
        assert (p >= 0);
        int keysize = NumberTools.parseIntDecSubstring(filename, p + 1);
        return Relations.rowdef(keysize, payloadsize);
    }

    private static Row rowdef(int keysize, int payloadsize) {
        return new Row("byte[] key-" + keysize + ", long time-8" + keysize + ", int ttl-4" + keysize + ", byte[] node-" + payloadsize, NaturalOrder.naturalOrder);
    }

    private static String filename(String tablename, int keysize, int payloadsize) {
        return tablename + "-" + keysize + "-" + payloadsize + ".eco";
    }

    public void declareRelation(String name, int keysize, int payloadsize) throws SpaceExceededException {
        Table table;
        Index relation = this.relations.get(name);
        if (relation != null) {
            return;
        }
        String[] list2 = this.baseDir.list();
        String targetfilename = Relations.filename(name, keysize, payloadsize);
        for (int i = 0; i < list2.length; ++i) {
            Table table2;
            if (!list2[i].startsWith(name) || !list2[i].equals(targetfilename)) continue;
            Row row = Relations.rowdef(list2[i]);
            if (row.primaryKeyLength != keysize || row.column((int)1).cellwidth != payloadsize) continue;
            try {
                table2 = new Table(new File(this.baseDir, list2[i]), row, 0x100000, 0, this.useTailCache, this.exceed134217727, true);
            }
            catch (SpaceExceededException e) {
                table2 = new Table(new File(this.baseDir, list2[i]), row, 0, 0, false, this.exceed134217727, true);
            }
            this.relations.put(name, table2);
            return;
        }
        Row row = Relations.rowdef(keysize, payloadsize);
        try {
            table = new Table(new File(this.baseDir, targetfilename), row, 0x100000, 0, this.useTailCache, this.exceed134217727, true);
        }
        catch (SpaceExceededException e) {
            table = new Table(new File(this.baseDir, targetfilename), row, 0, 0, false, this.exceed134217727, true);
        }
        this.relations.put(name, table);
    }

    public Index getRelation(String name) throws SpaceExceededException {
        String[] list2;
        Index relation = this.relations.get(name);
        if (relation != null) {
            return relation;
        }
        for (String element : list2 = this.baseDir.list()) {
            Table table;
            if (!element.startsWith(name)) continue;
            Row row = Relations.rowdef(element);
            try {
                table = new Table(new File(this.baseDir, element), row, 0x100000, 0, this.useTailCache, this.exceed134217727, true);
            }
            catch (SpaceExceededException e) {
                table = new Table(new File(this.baseDir, element), row, 0, 0, false, this.exceed134217727, true);
            }
            this.relations.put(name, table);
            return table;
        }
        return null;
    }

    public String putRelation(String name, String key, String value) throws IOException, SpaceExceededException {
        byte[] r = this.putRelation(name, UTF8.getBytes(key), UTF8.getBytes(value));
        if (r == null) {
            return null;
        }
        return UTF8.String(r);
    }

    public byte[] putRelation(String name, byte[] key, byte[] value) throws IOException, SpaceExceededException {
        Index table = this.getRelation(name);
        if (table == null) {
            return null;
        }
        Row.Entry entry2 = table.row().newEntry();
        entry2.setCol(0, key);
        entry2.setCol(1, System.currentTimeMillis());
        entry2.setCol(2, 1000000L);
        entry2.setCol(3, value);
        Row.Entry oldentry = table.replace(entry2);
        if (oldentry == null) {
            return null;
        }
        return oldentry.getColBytes(3, true);
    }

    public String getRelation(String name, String key) throws IOException, SpaceExceededException {
        byte[] r = this.getRelation(name, UTF8.getBytes(key));
        if (r == null) {
            return null;
        }
        return UTF8.String(r);
    }

    public byte[] getRelation(String name, byte[] key) throws IOException, SpaceExceededException {
        Index table = this.getRelation(name);
        if (table == null) {
            return null;
        }
        Row.Entry entry2 = table.get(key, false);
        if (entry2 == null) {
            return null;
        }
        return entry2.getColBytes(3, true);
    }

    public boolean hasRelation(String name, byte[] key) throws SpaceExceededException {
        Index table = this.getRelation(name);
        if (table == null) {
            return false;
        }
        return table.has(key);
    }

    public byte[] removeRelation(String name, byte[] key) throws IOException, SpaceExceededException {
        Index table = this.getRelation(name);
        if (table == null) {
            return null;
        }
        Row.Entry entry2 = table.remove(key);
        if (entry2 == null) {
            return null;
        }
        return entry2.getColBytes(3, true);
    }

    public static void main(String[] args) {
        Relations r = new Relations(new File("/Users/admin/"), true, true);
        try {
            String table1 = "test1";
            r.declareRelation("test1", 12, 30);
            r.putRelation("test1", "abcdefg", "eineintrag");
            r.putRelation("test1", "abcdefg", "eineintrag");
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
        }
    }
}

