/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.rwi;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.sorting.Rating;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.ArrayStack;
import net.yacy.kelondro.blob.BLOB;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowSet;
import net.yacy.kelondro.rwi.IODispatcher;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceFactory;

public final class ReferenceContainerArray<ReferenceType extends Reference> {
    private static final long METHOD_MAXRUNTIME = 5000L;
    private final ReferenceFactory<ReferenceType> factory;
    private final ArrayStack array;

    public ReferenceContainerArray(File heapLocation, String prefix, ReferenceFactory<ReferenceType> factory, ByteOrder termOrder, int termSize) throws IOException {
        this.factory = factory;
        this.array = new ArrayStack(heapLocation, prefix, termOrder, termSize, 0, true, true);
    }

    public synchronized void close() {
        this.array.close(true);
    }

    public void clear() throws IOException {
        this.array.clear();
    }

    public int[] sizes() {
        return this.array == null ? new int[]{} : this.array.sizes();
    }

    public ByteOrder ordering() {
        return this.array.ordering();
    }

    public File newContainerBLOBFile() {
        return this.array.newBLOB(new Date());
    }

    public void mountBLOBFile(File location) throws IOException {
        this.array.mountBLOB(location, false);
    }

    public Row rowdef() {
        return this.factory.getRow();
    }

    public CloneableIterator<ReferenceContainer<ReferenceType>> referenceContainerIterator(byte[] startWordHash, boolean rot, boolean excludePrivate) {
        try {
            return new ReferenceContainerIterator(startWordHash, rot, excludePrivate);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    public CloneableIterator<Rating<byte[]>> referenceCountIterator(byte[] startWordHash, boolean rot, boolean excludePrivate) {
        try {
            return new ReferenceCountIterator(startWordHash, rot, excludePrivate);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    public boolean has(byte[] termHash) {
        return this.array.containsKey(termHash);
    }

    public ReferenceContainer<ReferenceType> get(byte[] termHash) throws IOException, SpaceExceededException {
        long timeout = System.currentTimeMillis() + 5000L;
        Iterator<byte[]> entries2 = this.array.getAll(termHash).iterator();
        if (entries2 == null || !entries2.hasNext()) {
            return null;
        }
        byte[] a = entries2.next();
        int k = 1;
        ReferenceContainer<ReferenceType> c = new ReferenceContainer<ReferenceType>(this.factory, termHash, RowSet.importRowSet(a, this.factory.getRow()));
        if (System.currentTimeMillis() > timeout) {
            ConcurrentLog.warn("KELONDRO", "ReferenceContainerArray: timout in get() (1): " + k + " tables searched. timeout = 5000");
            return c;
        }
        while (entries2.hasNext()) {
            c = c.merge(new ReferenceContainer<ReferenceType>(this.factory, termHash, RowSet.importRowSet(entries2.next(), this.factory.getRow())));
            ++k;
            if (System.currentTimeMillis() <= timeout) continue;
            ConcurrentLog.warn("KELONDRO", "ReferenceContainerArray: timout in get() (2): " + k + " tables searched. timeout = 5000");
            return c;
        }
        return c;
    }

    public int count(byte[] termHash) throws IOException {
        long timeout = System.currentTimeMillis() + 5000L;
        Iterator<Long> entries2 = this.array.lengthAll(termHash).iterator();
        if (entries2 == null || !entries2.hasNext()) {
            return 0;
        }
        Long a = entries2.next();
        int k = 1;
        int c = RowSet.importRowCount(a, this.factory.getRow());
        assert (c >= 0);
        if (System.currentTimeMillis() > timeout) {
            ConcurrentLog.warn("KELONDRO", "ReferenceContainerArray: timeout in count() (1): " + k + " tables searched. timeout = 5000");
            return c;
        }
        while (entries2.hasNext()) {
            assert ((c += RowSet.importRowCount(entries2.next(), this.factory.getRow())) >= 0);
            ++k;
            if (System.currentTimeMillis() <= timeout) continue;
            ConcurrentLog.warn("KELONDRO", "ReferenceContainerArray: timeout in count() (2): " + k + " tables searched. timeout = 5000");
            return c;
        }
        assert (c >= 0);
        return c;
    }

    public void delete(byte[] termHash) throws IOException {
        this.array.delete(termHash);
    }

    public int reduce(byte[] termHash, ContainerReducer<ReferenceType> reducer) throws IOException, SpaceExceededException {
        return this.array.reduce(termHash, new BLOBReducer(termHash, reducer));
    }

    public CloneableIterator<byte[]> keys(boolean up, boolean rotating) throws IOException {
        return this.array.keys(up, rotating);
    }

    public int entries() {
        return this.array.entries();
    }

    public boolean shrinkBestSmallFiles(IODispatcher merger, long targetFileSize) {
        File[] ff = this.array.unmountBestMatch(2.0f, targetFileSize);
        if (ff == null) {
            return false;
        }
        ConcurrentLog.info("KELONDRO", "RICELL-shrink1: unmountBestMatch(2.0, " + targetFileSize + ")");
        merger.merge(ff[0], ff[1], this.factory, this.array, this.newContainerBLOBFile());
        return true;
    }

    public boolean shrinkAnySmallFiles(IODispatcher merger, long targetFileSize) {
        File[] ff = this.array.unmountSmallest(targetFileSize);
        if (ff == null) {
            return false;
        }
        ConcurrentLog.info("KELONDRO", "RICELL-shrink2: unmountSmallest(" + targetFileSize + ")");
        merger.merge(ff[0], ff[1], this.factory, this.array, this.newContainerBLOBFile());
        return true;
    }

    public boolean shrinkUpToMaxSizeFiles(IODispatcher merger, long maxFileSize) {
        File[] ff = this.array.unmountBestMatch(2.0f, maxFileSize);
        if (ff == null) {
            return false;
        }
        ConcurrentLog.info("KELONDRO", "RICELL-shrink3: unmountBestMatch(2.0, " + maxFileSize + ")");
        merger.merge(ff[0], ff[1], this.factory, this.array, this.newContainerBLOBFile());
        return true;
    }

    public boolean shrinkOldFiles(IODispatcher merger) {
        File ff = this.array.unmountOldest();
        if (ff == null) {
            return false;
        }
        ConcurrentLog.info("KELONDRO", "RICELL-shrink4/rewrite: unmountOldest()");
        merger.merge(ff, null, this.factory, this.array, this.newContainerBLOBFile());
        return true;
    }

    public class ReferenceContainerIterator
    implements CloneableIterator<ReferenceContainer<ReferenceType>>,
    Iterable<ReferenceContainer<ReferenceType>> {
        private final boolean rot;
        private final boolean excludePrivate;
        protected CloneableIterator<byte[]> iterator;

        public ReferenceContainerIterator(byte[] startWordHash, boolean rot, boolean excludePrivate) throws IOException {
            this.rot = rot;
            this.excludePrivate = excludePrivate;
            this.iterator = ReferenceContainerArray.this.array.keys(true, startWordHash);
        }

        public ReferenceContainerIterator clone(Object secondWordHash) {
            try {
                return new ReferenceContainerIterator((byte[])secondWordHash, this.rot, this.excludePrivate);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                return null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            if (this.rot) {
                return true;
            }
            return this.iterator.hasNext();
        }

        @Override
        public ReferenceContainer<ReferenceType> next() {
            byte[] b;
            while (this.iterator.hasNext()) {
                try {
                    b = (byte[])this.iterator.next();
                    if (this.excludePrivate && Word.isPrivate(b)) continue;
                    return ReferenceContainerArray.this.get(b);
                }
                catch (Throwable e) {
                    ConcurrentLog.logException(e);
                    return null;
                }
            }
            if (!this.rot) {
                return null;
            }
            try {
                this.iterator = ReferenceContainerArray.this.array.keys(true, null);
                while (this.iterator.hasNext()) {
                    b = (byte[])this.iterator.next();
                    if (this.excludePrivate && Word.isPrivate(b)) continue;
                    return ReferenceContainerArray.this.get(b);
                }
                return null;
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
                return null;
            }
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public Iterator<ReferenceContainer<ReferenceType>> iterator() {
            return this;
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }

    public class ReferenceCountIterator
    implements CloneableIterator<Rating<byte[]>>,
    Iterable<Rating<byte[]>> {
        private final boolean rot;
        private final boolean excludePrivate;
        private CloneableIterator<byte[]> iterator;

        public ReferenceCountIterator(byte[] startWordHash, boolean rot, boolean excludePrivate) throws IOException {
            this.rot = rot;
            this.excludePrivate = excludePrivate;
            this.iterator = ReferenceContainerArray.this.array.keys(true, startWordHash);
        }

        public ReferenceCountIterator clone(Object secondWordHash) {
            try {
                return new ReferenceCountIterator((byte[])secondWordHash, this.rot, this.excludePrivate);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                return null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            if (this.rot) {
                return true;
            }
            return this.iterator.hasNext();
        }

        @Override
        public Rating<byte[]> next() {
            byte[] reference;
            while (this.iterator.hasNext()) {
                try {
                    reference = (byte[])this.iterator.next();
                    if (this.excludePrivate && Word.isPrivate(reference)) continue;
                    return new Rating<byte[]>(reference, ReferenceContainerArray.this.count(reference));
                }
                catch (Throwable e) {
                    ConcurrentLog.logException(e);
                    return null;
                }
            }
            if (!this.rot) {
                return null;
            }
            while (this.iterator.hasNext()) {
                try {
                    this.iterator = ReferenceContainerArray.this.array.keys(true, null);
                    reference = (byte[])this.iterator.next();
                    if (this.excludePrivate && Word.isPrivate(reference)) continue;
                    return new Rating<byte[]>(reference, ReferenceContainerArray.this.count(reference));
                }
                catch (Throwable e) {
                    ConcurrentLog.logException(e);
                    return null;
                }
            }
            return null;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public Iterator<Rating<byte[]>> iterator() {
            return this;
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }

    public class BLOBReducer
    implements BLOB.Reducer {
        ContainerReducer<ReferenceType> rewriter;
        byte[] wordHash;

        public BLOBReducer(byte[] wordHash, ContainerReducer<ReferenceType> rewriter) {
            this.rewriter = rewriter;
            this.wordHash = wordHash;
        }

        @Override
        public byte[] rewrite(byte[] b) throws SpaceExceededException {
            if (b == null) {
                return null;
            }
            ReferenceContainer c = this.rewriter.reduce(new ReferenceContainer(ReferenceContainerArray.this.factory, this.wordHash, RowSet.importRowSet(b, ReferenceContainerArray.this.factory.getRow())));
            if (c == null) {
                return null;
            }
            byte[] bb = c.exportCollection();
            assert (bb.length <= b.length);
            return bb;
        }
    }

    public static interface ContainerReducer<ReferenceType extends Reference> {
        public ReferenceContainer<ReferenceType> reduce(ReferenceContainer<ReferenceType> var1);
    }
}

