/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.io.AbstractWriter;
import net.yacy.kelondro.io.Writer;

public final class CachedFileWriter
extends AbstractWriter
implements Writer {
    private RandomAccessFile RAFile;
    private byte[] cache;
    private long cachestart;
    private int cachelen;

    public CachedFileWriter(File file) throws IOException, FileNotFoundException {
        this.name = file.getName();
        this.file = file;
        this.RAFile = new RandomAccessFile(this.file, "rw");
        this.cache = new byte[32768];
        this.cachestart = 0L;
        this.cachelen = 0;
    }

    @Override
    public final synchronized long length() throws IOException {
        this.checkReopen();
        return this.RAFile.length();
    }

    @Override
    public final synchronized void setLength(long length) throws IOException {
        this.checkReopen();
        this.cachelen = 0;
        this.RAFile.setLength(length);
    }

    @Override
    public final synchronized long available() throws IOException {
        this.checkReopen();
        return this.length() - this.RAFile.getFilePointer();
    }

    @Override
    public final synchronized void readFully(byte[] b, int off, int len) throws IOException {
        this.checkReopen();
        long seek = this.RAFile.getFilePointer();
        if (this.cache != null && this.cachestart <= seek && (long)this.cachelen - seek + this.cachestart >= (long)len) {
            System.arraycopy(this.cache, (int)(seek - this.cachestart), b, off, len);
            this.RAFile.seek(seek + (long)len);
            return;
        }
        if (this.cache == null || this.cache.length < len) {
            this.RAFile.readFully(b, off, len);
            return;
        }
        long available = this.RAFile.length() - seek;
        if (available == -seek) {
            return;
        }
        if (available < (long)len) {
            throw new IOException("EOF in " + this.file.getName() + ", available = " + available + ", requested = " + len + ", this.RAFile.length() = " + this.RAFile.length() + ", seek = " + seek);
        }
        if (this.cachestart + (long)this.cachelen == seek && this.cache.length - this.cachelen >= len) {
            this.RAFile.readFully(this.cache, this.cachelen, len);
            System.arraycopy(this.cache, this.cachelen, b, off, len);
            this.cachelen += len;
        } else {
            int m = (int)Math.min(available, (long)this.cache.length);
            this.RAFile.readFully(this.cache, 0, m);
            this.cachestart = seek;
            this.cachelen = m;
            if (m != len) {
                this.RAFile.seek(seek + (long)len);
            }
            System.arraycopy(this.cache, 0, b, off, len);
        }
    }

    @Override
    public final synchronized void write(byte[] b, int off, int len) throws IOException {
        this.checkReopen();
        if (this.cache.length > 512) {
            byte[] newcache = new byte[512];
            System.arraycopy(this.cache, 0, newcache, 0, newcache.length);
            this.cache = newcache;
            if (this.cachelen > this.cache.length) {
                this.cachelen = this.cache.length;
            }
        }
        long seekpos = this.RAFile.getFilePointer();
        if (this.cachelen + len <= this.cache.length && this.cachestart + (long)this.cachelen == seekpos) {
            System.arraycopy(b, off, this.cache, this.cachelen, len);
            this.cachelen += len;
        } else if (len <= this.cache.length) {
            System.arraycopy(b, off, this.cache, 0, len);
            this.cachelen = len;
            this.cachestart = seekpos;
        } else {
            this.cachelen = 0;
        }
        this.RAFile.write(b, off, len);
    }

    @Override
    public final synchronized void seek(long pos) throws IOException {
        this.checkReopen();
        this.RAFile.seek(pos);
    }

    @Override
    public final synchronized void close() {
        if (this.RAFile != null) {
            try {
                try {
                    this.RAFile.getChannel().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.RAFile.close();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        this.cache = null;
        this.RAFile = null;
    }

    private final void checkReopen() {
        if (this.RAFile != null) {
            return;
        }
        try {
            this.RAFile = new RandomAccessFile(this.file, "rw");
        }
        catch (FileNotFoundException e) {
            ConcurrentLog.logException(e);
        }
        this.cache = new byte[8192];
        this.cachestart = 0L;
        this.cachelen = 0;
    }
}

