/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.io;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.io.Records;
import net.yacy.kelondro.util.FileUtils;

public final class BufferedRecords {
    private final Records efs;
    private final int maxEntries;
    private final TreeMap<Long, byte[]> buffer;

    public BufferedRecords(Records efs, int maxEntries) {
        this.efs = efs;
        this.maxEntries = maxEntries;
        this.buffer = new TreeMap();
    }

    public synchronized void clear() {
        this.efs.clear();
        this.buffer.clear();
    }

    public synchronized void flushBuffer() throws IOException {
        this.flushBuffer0();
        if (this.efs != null) {
            this.efs.flushBuffer();
        }
    }

    private final void flushBuffer0() throws IOException {
        if (this.efs == null) {
            return;
        }
        for (Map.Entry<Long, byte[]> entry2 : this.buffer.entrySet()) {
            this.efs.put(entry2.getKey().intValue(), entry2.getValue(), 0);
        }
        this.buffer.clear();
    }

    public final synchronized long size() throws IOException {
        return this.efs == null ? 0L : this.efs.size();
    }

    public final File filename() {
        return this.efs.filename();
    }

    public final synchronized void close() {
        try {
            this.flushBuffer0();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        if (this.efs != null) {
            this.efs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void get(long index2, byte[] b, int start) throws IOException {
        byte[] bb;
        Long idx2 = index2;
        BufferedRecords bufferedRecords = this;
        synchronized (bufferedRecords) {
            assert (b.length - start >= this.efs.recordsize);
            bb = this.buffer.get(idx2);
            if (bb == null) {
                this.efs.get(index2, b, start);
                return;
            }
        }
        System.arraycopy(bb, 0, b, start, this.efs.recordsize);
    }

    public final synchronized void put(long index2, byte[] b, int start) throws IOException {
        assert (b.length - start >= this.efs.recordsize);
        long s = this.size();
        if (index2 > s) {
            throw new IndexOutOfBoundsException("kelondroBufferedEcoFS.put(" + index2 + ") outside bounds (" + this.size() + ")");
        }
        if (index2 == s) {
            this.efs.add(b, start);
        } else {
            byte[] bb = new byte[this.efs.recordsize];
            System.arraycopy(b, start, bb, 0, this.efs.recordsize);
            this.buffer.put(index2, bb);
            if (this.buffer.size() > this.maxEntries) {
                this.flushBuffer0();
            }
        }
    }

    public final synchronized void add(byte[] b, int start) throws IOException {
        assert (b.length - start >= this.efs.recordsize);
        this.efs.add(b, start);
    }

    public final synchronized void cleanLast(byte[] b, int start) throws IOException {
        assert (b.length - start >= this.efs.recordsize);
        byte[] bb = this.buffer.remove(this.size() - 1L);
        if (bb == null) {
            this.efs.cleanLast(b, start);
        } else {
            System.arraycopy(bb, 0, b, start, this.efs.recordsize);
            this.efs.cleanLast();
        }
    }

    public final synchronized void cleanLast() throws IOException {
        this.buffer.remove(this.size() - 1L);
        this.efs.cleanLast();
    }

    public final void deleteOnExit() {
        this.efs.deleteOnExit();
    }

    public static void main(String[] args) {
        File f = new File(args[0]);
        if (f.exists()) {
            FileUtils.deletedelete(f);
        }
        try {
            Records t = new Records(f, 8);
            byte[] b = new byte[8];
            t.add("01234567".getBytes(), 0);
            t.add("ABCDEFGH".getBytes(), 0);
            t.add("abcdefgh".getBytes(), 0);
            t.add("--------".getBytes(), 0);
            t.add("********".getBytes(), 0);
            for (int i = 0; i < 1000; ++i) {
                t.add("++++++++".getBytes(), 0);
            }
            t.add("=======0".getBytes(), 0);
            t.add("=======1".getBytes(), 0);
            t.add("=======2".getBytes(), 0);
            t.cleanLast(b, 0);
            System.out.println(UTF8.String(b));
            t.cleanLast(b, 0);
            System.out.println(UTF8.String(b));
            t.get(1L, b, 0);
            System.out.println(UTF8.String(b));
            t.put(1L, "AbCdEfGh".getBytes(), 0);
            t.get(1L, b, 0);
            System.out.println(UTF8.String(b));
            t.get(3L, b, 0);
            System.out.println(UTF8.String(b));
            t.get(4L, b, 0);
            System.out.println(UTF8.String(b));
            System.out.println("size = " + t.size());
            t.cleanLast();
            long start = System.currentTimeMillis();
            long c = 0L;
            for (int i = 0; i < 100000; ++i) {
                c = t.size();
            }
            System.out.println("size() needs " + (System.currentTimeMillis() - start) / 100L + " nanoseconds");
            System.out.println("size = " + c);
            t.close();
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }
}

