/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.data.word;

import java.util.Collection;
import net.yacy.cora.date.MicroDate;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.util.ByteArray;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.data.word.WordReference;
import net.yacy.kelondro.data.word.WordReferenceVars;
import net.yacy.kelondro.index.Column;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.rwi.AbstractReference;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.util.Bitfield;

public final class WordReferenceRow
extends AbstractReference
implements WordReference,
Cloneable {
    public static final Row urlEntryRow = new Row(new Column[]{new Column("h", 3, 3, 12, "urlhash"), new Column("a", 4, 2, 2, "lastModified"), new Column("s", 4, 2, 2, "freshUntil"), new Column("u", 4, 2, 1, "wordsInTitle"), new Column("w", 4, 2, 2, "wordsInText"), new Column("p", 4, 2, 2, "phrasesInText"), new Column("d", 2, 3, 1, "doctype"), new Column("l", 3, 3, 2, "language"), new Column("x", 4, 2, 1, "llocal"), new Column("y", 4, 2, 1, "lother"), new Column("m", 4, 2, 1, "urlLength"), new Column("n", 4, 2, 1, "urlComps"), new Column("g", 2, 3, 1, "typeofword"), new Column("z", 5, 3, 4, "flags"), new Column("c", 4, 2, 1, "hitcount"), new Column("t", 4, 2, 2, "posintext"), new Column("r", 4, 2, 1, "posinphrase"), new Column("o", 4, 2, 1, "posofphrase"), new Column("i", 4, 2, 1, "worddistance"), new Column("k", 4, 2, 1, "reserve")}, (ByteOrder)Base64Order.enhancedCoder);
    protected static final Row.Entry poisonRowEntry = urlEntryRow.newEntry();
    private static final int col_urlhash = 0;
    private static final int col_lastModified = 1;
    private static final int col_freshUntil = 2;
    private static final int col_wordsInTitle = 3;
    private static final int col_wordsInText = 4;
    private static final int col_phrasesInText = 5;
    private static final int col_doctype = 6;
    private static final int col_language = 7;
    private static final int col_llocal = 8;
    private static final int col_lother = 9;
    private static final int col_urlLength = 10;
    private static final int col_urlComps = 11;
    private static final int col_typeofword = 12;
    private static final int col_flags = 13;
    private static final int col_hitcount = 14;
    private static final int col_posintext = 15;
    private static final int col_posinphrase = 16;
    private static final int col_posofphrase = 17;
    private static final int col_worddistance = 18;
    private static final int col_reserve2 = 19;
    public static final int flag_app_dc_description = 24;
    public static final int flag_app_dc_title = 25;
    public static final int flag_app_dc_creator = 26;
    public static final int flag_app_dc_subject = 27;
    public static final int flag_app_dc_identifier = 28;
    public static final int flag_app_emphasized = 29;
    private final Row.Entry entry;
    private int hashCache = Integer.MIN_VALUE;

    protected WordReferenceRow(byte[] urlHash, int urlLength, int urlComps, int titlewordcount, int hitcount, int wordcount, int phrasecount, int posintext, int posinphrase, int posofphrase, long lastmodified, long updatetime, byte[] language, char doctype, int outlinksSame, int outlinksOther, int wordDistance, Bitfield flags) {
        assert (urlHash.length == 12) : "urlhash = " + ASCII.String(urlHash);
        this.entry = urlEntryRow.newEntry();
        int mddlm = MicroDate.microDateDays(lastmodified);
        int mddct = MicroDate.microDateDays(updatetime);
        this.entry.setCol(0, urlHash);
        this.entry.setCol(1, mddlm);
        this.entry.setCol(2, Math.max(0, mddlm + (mddct - mddlm) * 2));
        this.entry.setCol(3, titlewordcount);
        this.entry.setCol(4, wordcount);
        this.entry.setCol(5, phrasecount);
        this.entry.setCol(6, new byte[]{(byte)doctype});
        this.entry.setCol(7, language == null || language.length != urlEntryRow.width(7) ? WordReferenceVars.default_language : language);
        this.entry.setCol(8, outlinksSame);
        this.entry.setCol(9, outlinksOther);
        this.entry.setCol(10, urlLength);
        this.entry.setCol(11, urlComps);
        this.entry.setCol(12, new byte[]{0});
        this.entry.setCol(13, flags.bytes());
        this.entry.setCol(14, hitcount);
        this.entry.setCol(15, posintext);
        this.entry.setCol(16, posinphrase);
        this.entry.setCol(17, posofphrase);
        this.entry.setCol(18, wordDistance);
        this.entry.setCol(19, 0L);
    }

    public WordReferenceRow(byte[] urlHash, int urlLength, int urlComps, int titlewordcount, int wordcount, int phrasecount, long lastmodified, long updatetime, byte[] language, char doctype, int outlinksSame, int outlinksOther) {
        assert (urlHash.length == 12) : "urlhash = " + ASCII.String(urlHash);
        this.entry = urlEntryRow.newEntry();
        int mddlm = MicroDate.microDateDays(lastmodified);
        int mddct = MicroDate.microDateDays(updatetime);
        this.entry.setCol(0, urlHash);
        this.entry.setCol(1, mddlm);
        this.entry.setCol(2, Math.max(0, mddlm + (mddct - mddlm) * 2));
        this.entry.setCol(3, titlewordcount);
        this.entry.setCol(4, wordcount);
        this.entry.setCol(5, phrasecount);
        this.entry.setCol(6, new byte[]{(byte)doctype});
        this.entry.setCol(7, language == null || language.length != urlEntryRow.width(7) ? WordReferenceVars.default_language : language);
        this.entry.setCol(8, outlinksSame);
        this.entry.setCol(9, outlinksOther);
        this.entry.setCol(10, urlLength);
        this.entry.setCol(11, urlComps);
        this.entry.setCol(18, 0L);
        this.entry.setCol(19, 0L);
    }

    public void setWord(Word word) {
        this.entry.setCol(12, new byte[]{0});
        this.entry.setCol(13, word.flags.bytes());
        this.entry.setCol(14, word.count);
        this.entry.setCol(15, word.posInText);
        this.entry.setCol(16, word.posInPhrase);
        this.entry.setCol(17, word.numOfPhrase);
    }

    public WordReferenceRow(String external) {
        this.entry = urlEntryRow.newEntry(external, true);
    }

    private WordReferenceRow(byte[] row) {
        this.entry = urlEntryRow.newEntry(row);
    }

    protected WordReferenceRow(Row.Entry rentry) {
        this.entry = rentry;
    }

    public WordReferenceRow clone() {
        byte[] b = new byte[WordReferenceRow.urlEntryRow.objectsize];
        System.arraycopy(this.entry.bytes(), 0, b, 0, WordReferenceRow.urlEntryRow.objectsize);
        return new WordReferenceRow(b);
    }

    @Override
    public String toPropertyForm() {
        return this.entry.toPropertyForm('=', true, true, false, false);
    }

    @Override
    public Row.Entry toKelondroEntry() {
        return this.entry;
    }

    @Override
    public byte[] urlhash() {
        return this.entry.getColBytes(0, true);
    }

    @Override
    public int virtualAge() {
        return (int)this.entry.getColLong(1);
    }

    @Override
    public long lastModified() {
        return MicroDate.reverseMicroDateDays(this.entry.getColLong(1));
    }

    @Override
    public int hitcount() {
        return 0xFF & this.entry.getColByte(14);
    }

    @Override
    public int posintext() {
        int pos = (int)this.entry.getColLong(15);
        return pos;
    }

    @Override
    public int distance() {
        int distance = (int)this.entry.getColLong(18);
        return distance;
    }

    @Override
    public Collection<Integer> positions() {
        return null;
    }

    @Override
    public int posinphrase() {
        return 0xFF & this.entry.getColByte(16);
    }

    @Override
    public int posofphrase() {
        return 0xFF & this.entry.getColByte(17);
    }

    @Override
    public int wordsintext() {
        return (int)this.entry.getColLong(4);
    }

    @Override
    public int phrasesintext() {
        return (int)this.entry.getColLong(5);
    }

    @Override
    public byte[] getLanguage() {
        return this.entry.getColBytes(7, true);
    }

    @Override
    public char getType() {
        return (char)this.entry.getColByte(6);
    }

    @Override
    public int wordsintitle() {
        return 0xFF & this.entry.getColByte(3);
    }

    @Override
    public int llocal() {
        return 0xFF & this.entry.getColByte(8);
    }

    @Override
    public int lother() {
        return 0xFF & this.entry.getColByte(9);
    }

    @Override
    public int urllength() {
        return 0xFF & this.entry.getColByte(10);
    }

    @Override
    public int urlcomps() {
        return 0xFF & this.entry.getColByte(11);
    }

    @Override
    public Bitfield flags() {
        return new Bitfield(this.entry.getColBytes(13, false));
    }

    @Override
    public double termFrequency() {
        return (double)this.hitcount() / (double)(this.wordsintext() + this.wordsintitle() + 1);
    }

    @Override
    public String toString() {
        return this.toPropertyForm();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WordReferenceRow)) {
            return false;
        }
        WordReferenceRow other = (WordReferenceRow)obj;
        return Base64Order.enhancedCoder.equal(this.urlhash(), other.urlhash());
    }

    @Override
    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            this.hashCache = ByteArray.hashCode(this.urlhash());
        }
        return this.hashCache;
    }

    @Override
    public void join(Reference oe) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public String hosthash() {
        return ASCII.String(this.urlhash(), 6, 6);
    }
}

