/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.data.citation;

import java.io.Serializable;
import java.util.Collection;
import net.yacy.cora.date.MicroDate;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.util.ByteArray;
import net.yacy.kelondro.index.Column;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.rwi.Reference;

public class CitationReference
implements Reference,
Serializable {
    private static final long serialVersionUID = 1920200210928897131L;
    public static final Row citationRow = new Row(new Column[]{new Column("h", 3, 3, 12, "urlhash"), new Column("m", 4, 2, 2, "lastModified"), new Column("r", 4, 2, 2, "reserve")}, (ByteOrder)Base64Order.enhancedCoder);
    private static final int col_urlhash = 0;
    private static final int col_lastModified = 1;
    private static final int col_reserve = 2;
    private final Row.Entry entry;
    private int hashCache = Integer.MIN_VALUE;

    public CitationReference(byte[] urlHash, long lastmodified) {
        assert (urlHash.length == 12) : "urlhash = " + ASCII.String(urlHash);
        this.entry = citationRow.newEntry();
        int mddlm = MicroDate.microDateDays(lastmodified);
        this.entry.setCol(0, urlHash);
        this.entry.setCol(1, mddlm >> 2);
        this.entry.setCol(2, 0L);
    }

    private CitationReference(byte[] row) {
        this.entry = citationRow.newEntry(row);
    }

    public CitationReference(Row.Entry rentry) {
        this.entry = rentry;
    }

    public CitationReference clone() {
        byte[] b = new byte[CitationReference.citationRow.objectsize];
        System.arraycopy(this.entry.bytes(), 0, b, 0, CitationReference.citationRow.objectsize);
        return new CitationReference(b);
    }

    @Override
    public String toPropertyForm() {
        return this.entry.toPropertyForm('=', true, true, false, false);
    }

    @Override
    public Row.Entry toKelondroEntry() {
        return this.entry;
    }

    @Override
    public byte[] urlhash() {
        return this.entry.getColBytes(0, true);
    }

    public byte[] hosthash() {
        byte[] uh = this.entry.getColBytes(0, true);
        byte[] hh = new byte[6];
        System.arraycopy(uh, 6, hh, 0, 6);
        return hh;
    }

    public int virtualAge() {
        return (int)this.entry.getColLong(1);
    }

    @Override
    public long lastModified() {
        return MicroDate.reverseMicroDateDays((int)this.entry.getColLong(1) << 2);
    }

    @Override
    public String toString() {
        return this.toPropertyForm();
    }

    @Override
    public boolean isOlder(Reference other) {
        if (other == null) {
            return false;
        }
        return this.lastModified() < other.lastModified();
    }

    @Override
    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            this.hashCache = ByteArray.hashCode(this.urlhash());
        }
        return this.hashCache;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CitationReference)) {
            return false;
        }
        CitationReference other = (CitationReference)obj;
        return Base64Order.enhancedCoder.equal(this.urlhash(), other.urlhash());
    }

    @Override
    public int distance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void join(Reference oe) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Integer> positions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int posintext() {
        throw new UnsupportedOperationException();
    }
}

