/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.Heap;

public class Stack {
    private final Heap stack;
    private long lastHandle;

    public Stack(File stackFile) throws IOException {
        this.stack = new Heap(stackFile, 8, NaturalOrder.naturalOrder, 0);
        this.lastHandle = 0L;
    }

    public void clear() throws IOException {
        this.stack.clear();
    }

    private long nextHandle() {
        long h = System.currentTimeMillis();
        if (h <= this.lastHandle) {
            h = this.lastHandle + 1L;
        }
        this.lastHandle = h;
        return h;
    }

    public synchronized Iterator<Long> handles() throws IOException {
        return NaturalOrder.LongIterator(this.stack.keys(true, false));
    }

    public synchronized int size() {
        return this.stack.size();
    }

    public synchronized long push(byte[] b) throws IOException, SpaceExceededException {
        long handle = this.nextHandle();
        this.stack.insert(NaturalOrder.encodeLong(handle, 8), b);
        return handle;
    }

    protected synchronized void push(Entry e) throws IOException, SpaceExceededException {
        this.stack.insert(NaturalOrder.encodeLong(e.h, 8), e.b);
    }

    public synchronized byte[] get(long handle) throws IOException, SpaceExceededException {
        byte[] k = NaturalOrder.encodeLong(handle, 8);
        byte[] b = this.stack.get(k);
        if (b == null) {
            return null;
        }
        return b;
    }

    public synchronized byte[] remove(long handle) throws IOException, SpaceExceededException {
        byte[] k = NaturalOrder.encodeLong(handle, 8);
        byte[] b = this.stack.get(k);
        if (b == null) {
            return null;
        }
        this.stack.delete(k);
        return b;
    }

    public synchronized Entry pop() throws IOException {
        return this.po(this.stack.lastKey(), true);
    }

    public synchronized Entry top() throws IOException {
        return this.po(this.stack.lastKey(), false);
    }

    public synchronized Entry pot() throws IOException {
        return this.po(this.stack.firstKey(), true);
    }

    public synchronized Entry bot() throws IOException {
        return this.po(this.stack.firstKey(), false);
    }

    private Entry po(byte[] k, boolean remove) throws IOException {
        byte[] b;
        if (k == null) {
            return null;
        }
        assert (k.length == 8);
        try {
            b = this.stack.get(k);
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            b = null;
        }
        assert (b != null);
        if (b == null) {
            return null;
        }
        if (remove) {
            this.stack.delete(k);
        }
        return new Entry(k, b);
    }

    public synchronized void close() {
        this.stack.close(true);
    }

    public class Entry {
        private long h;
        byte[] b;

        public Entry(long h, byte[] b) {
            this.h = h;
            this.b = b;
        }

        public Entry(byte[] k, byte[] b) {
            this.h = NaturalOrder.decodeLong(k);
            this.b = b;
        }

        public long handle() {
            return this.h;
        }

        public byte[] blob() {
            return this.b;
        }
    }
}

