/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.yacy.ai.LLM;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.federate.solr.connector.EmbeddedSolrConnector;
import net.yacy.search.Switchboard;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.servlet.cache.Method;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RAGProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 3411544789759603107L;
    private static String LLM_SYSTEM_PREFIX = "\n\nYou may receive additional expert knowledge in the user prompt after a 'Additional Information' headline to enhance your knowledge. Use it only if applicable.";
    private static String LLM_USER_PREFIX = "\n\nAdditional Information:\n\nbelow you find a collection of texts that might be useful to generate a response. Do not discuss these documents, just use them to answer the question above.\n\n";
    private static String LLM_API_HOST = "http://localhost:11434";
    private static String LLM_QUERY_MODEL = "llama3.2:1b";
    private static String LLM_ANSWER_MODEL = "llama3.2:3b";
    private static Boolean LLM_API_MODEL_OVERWRITING = true;
    private static String LLM_API_KEY = "";

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        String line;
        response.setContentType("application/json;charset=utf-8");
        HttpServletResponse hresponse = (HttpServletResponse)response;
        HttpServletRequest hrequest = (HttpServletRequest)request;
        hresponse.setHeader("Access-Control-Allow-Origin", "*");
        hresponse.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        hresponse.setHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
        Method reqMethod = Method.getMethod((String)hrequest.getMethod());
        if (reqMethod == Method.OTHER) {
            hresponse.setStatus(200);
            return;
        }
        if (reqMethod != Method.POST) {
            hresponse.sendError(405);
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        BufferedReader reader = request.getReader();
        StringBuilder bodyBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            bodyBuilder.append(line);
        }
        String body = bodyBuilder.toString();
        try {
            JSONObject bodyObject = new JSONObject(body);
            JSONArray messages = bodyObject.optJSONArray("messages");
            JSONObject systemObject = messages.getJSONObject(0);
            Object system = systemObject.optString("content", "");
            JSONObject userObject = messages.getJSONObject(messages.length() - 1);
            Object user = userObject.optString("content", "");
            String query2 = this.searchWordsForPrompt(LLM_QUERY_MODEL, (String)user);
            out.print(RAGProxyServlet.responseLine("Searching for '" + query2 + "'\n\n").toString() + "\n");
            out.flush();
            JSONArray searchResults = RAGProxyServlet.searchResults(query2, 4, true);
            out.print(RAGProxyServlet.responseLine("\n").toString());
            out.flush();
            system = (String)system + LLM_SYSTEM_PREFIX;
            user = (String)user + LLM_USER_PREFIX;
            for (int i = 0; i < searchResults.length(); ++i) {
                JSONObject r = searchResults.getJSONObject(i);
                String snippet = r.optString("snippet", "");
                user = (String)user + snippet + "\n\n";
            }
            systemObject.put("content", system);
            userObject.put("content", user);
            if (LLM_API_MODEL_OVERWRITING.booleanValue()) {
                bodyObject.put("model", LLM_ANSWER_MODEL);
            }
            body = bodyObject.toString();
            URL url = new URI(LLM_API_HOST + "/v1/chat/completions").toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            if (!LLM_API_KEY.isEmpty()) {
                conn.setRequestProperty("Authorization", "Bearer " + LLM_API_KEY);
            }
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(body.getBytes());
                os.flush();
            }
            int status = conn.getResponseCode();
            hresponse.setStatus(status);
            if (status == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    out.print(inputLine);
                    out.flush();
                }
                in.close();
            }
            out.close();
        }
        catch (URISyntaxException | JSONException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static JSONArray searchResults(String query2, int count, boolean includeSnippet) {
        JSONArray results = new JSONArray();
        if (query2 == null || query2.length() == 0 || count == 0) {
            return results;
        }
        Switchboard sb = Switchboard.getSwitchboard();
        EmbeddedSolrConnector connector = sb.index.fulltext().getDefaultEmbeddedConnector();
        SolrQuery params = new SolrQuery();
        params.setQuery(CollectionSchema.text_t.getSolrFieldName() + ":" + query2);
        params.setRows(Integer.valueOf(count));
        params.setStart(Integer.valueOf(0));
        params.setFacet(false);
        params.clearSorts();
        params.setFields(new String[]{CollectionSchema.sku.getSolrFieldName(), CollectionSchema.text_t.getSolrFieldName()});
        params.setIncludeScore(true);
        params.set("df", new String[]{CollectionSchema.text_t.getSolrFieldName()});
        try {
            SolrDocumentList sdl = connector.getDocumentListByParams((ModifiableSolrParams)params);
            Iterator i = sdl.iterator();
            while (i.hasNext()) {
                try {
                    SolrDocument doc = (SolrDocument)i.next();
                    JSONObject result = new JSONObject(true);
                    String url = (String)doc.getFieldValue(CollectionSchema.sku.getSolrFieldName());
                    result.put("url", url);
                    String title = RAGProxyServlet.getOneString(doc, CollectionSchema.title);
                    result.put("title", title == null ? url : title);
                    if (includeSnippet) {
                        String text = (String)doc.getFieldValue(CollectionSchema.text_t.getSolrFieldName());
                        result.put("snippet", text == null ? "" : text);
                    }
                    results.put(result);
                }
                catch (JSONException jSONException) {}
            }
            return results;
        }
        catch (IOException | SolrException e) {
            return results;
        }
    }

    private static String getOneString(SolrDocument doc, CollectionSchema field) {
        assert (field.isMultiValued());
        assert (field.getType() == SolrType.string || field.getType() == SolrType.text_general);
        Object r = doc.getFieldValue(field.getSolrFieldName());
        if (r == null) {
            return "";
        }
        if (r instanceof ArrayList) {
            return (String)((ArrayList)r).get(0);
        }
        return r.toString();
    }

    private String searchWordsForPrompt(String model, String prompt) {
        StringBuilder query2 = new StringBuilder();
        String question = "Make a list of a maximum of four search words for the following question; use a JSON Array: " + prompt;
        try {
            String[] a;
            LLM llm = new LLM(LLM_API_HOST, null, 4096, LLM.LLMType.OLLAMA);
            LLM.Context context = new LLM.Context(LLM_SYSTEM_PREFIX);
            context.addPrompt(question);
            for (String s : a = LLM.stringsFromChat(llm.chat(model, context, LLM.listSchema, 80))) {
                query2.append(s).append(' ');
            }
            return query2.toString().trim();
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static JSONObject responseLine(String payload) {
        JSONObject j = new JSONObject(true);
        try {
            j.put("id", "log");
            j.put("object", "chat.completion.chunk");
            j.put("created", System.currentTimeMillis() / 1000L);
            j.put("model", "log");
            j.put("system_fingerprint", "YaCy");
            JSONArray choices = new JSONArray();
            JSONObject choice = new JSONObject(true);
            choice.put("index", 0);
            JSONObject delta = new JSONObject(true);
            delta.put("role", "assistant");
            delta.put("content", payload);
            choice.put("delta", delta);
            choices.put(choice);
            j.put("choices", choices);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return j;
    }
}

