/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.http;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.retrieval.Response;
import net.yacy.http.AbstractRemoteHandler;
import net.yacy.http.ProxyHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;

public class ProxyCacheHandler
extends AbstractRemoteHandler
implements Handler {
    private void handleRequestFromCache(HttpServletRequest request, HttpServletResponse response, ResponseHeader cachedResponseHeader, byte[] content) throws IOException {
        for (Map.Entry entry2 : cachedResponseHeader.entrySet()) {
            response.addHeader((String)entry2.getKey(), (String)entry2.getValue());
        }
        response.setStatus(203);
        response.getOutputStream().write(content);
    }

    @Override
    public void handleRemote(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getMethod().equals("GET")) {
            String queryString = request.getQueryString() != null ? "?" + request.getQueryString() : "";
            DigestURL url = new DigestURL(request.getRequestURL().toString() + queryString);
            ResponseHeader cachedResponseHeader = Cache.getResponseHeader(url.hash());
            if (cachedResponseHeader != null) {
                RequestHeader proxyHeaders = ProxyHandler.convertHeaderFromJetty(request);
                net.yacy.crawler.retrieval.Request yacyRequest = new net.yacy.crawler.retrieval.Request(null, url, proxyHeaders.referer() == null ? null : new DigestURL(proxyHeaders.referer().toNormalform(true)).hash(), "", cachedResponseHeader.lastModified(), this.sb.crawler.defaultProxyProfile.handle(), 0, this.sb.crawler.defaultProxyProfile.timezoneOffset());
                Response cachedResponse = new Response(yacyRequest, proxyHeaders, cachedResponseHeader, this.sb.crawler.defaultProxyProfile, false, null);
                byte[] cacheContent = Cache.getContent(url.hash());
                if (cacheContent != null && cachedResponse.isFreshForProxy()) {
                    this.handleRequestFromCache(request, response, cachedResponseHeader, cacheContent);
                    baseRequest.setHandled(true);
                }
            }
        }
    }
}

