/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.document.importer.ZimImporter;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class IndexImportZim_p {
    public static serverObjects respond(RequestHeader request, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        if (ZimImporter.job != null && ZimImporter.job.isAlive()) {
            prop.put("import", 1L);
            prop.put("import_thread", "running");
            prop.put("import_zimfile", ZimImporter.job.source());
            prop.put("import_count", ZimImporter.job.count());
            prop.put("import_speed", ZimImporter.job.speed());
            prop.put("import_runningHours", ZimImporter.job.runningTime() / 60L / 60L);
            prop.put("import_runningMinutes", ZimImporter.job.runningTime() / 60L % 60L);
            prop.put("import_remainingHours", ZimImporter.job.remainingTime() / 60L / 60L);
            prop.put("import_remainingMinutes", ZimImporter.job.remainingTime() / 60L % 60L);
            if (post != null && post.containsKey("abort")) {
                ZimImporter.job.quit();
            }
        } else {
            prop.put("import", 0L);
            if (post != null && post.containsKey("file")) {
                String filename = post.get("file");
                String collection = post.get("collection", "user");
                InputStream is = post.getInputStream("file$file");
                if (filename != null && filename.length() > 0) {
                    File sourcefile = new File(filename);
                    if (is != null || sourcefile.exists()) {
                        try {
                            ZimImporter zi = new ZimImporter(sourcefile.getAbsolutePath(), is, collection);
                            zi.start();
                            prop.put("import_thread", "started");
                        }
                        catch (IOException ex) {
                            prop.put("import_thread", "Error: file not found [" + filename + "]");
                        }
                        prop.put("import", 1L);
                        prop.put("import_zimfile", filename);
                    } else {
                        prop.put("import_zimfile", "");
                        prop.put("import_thread", "Error: file not found [" + filename + "]");
                    }
                }
                prop.put("import_count", 0L);
                prop.put("import_speed", 0L);
                prop.put("import_runningHours", 0L);
                prop.put("import_runningMinutes", 0L);
                prop.put("import_remainingHours", 0L);
                prop.put("import_remainingMinutes", 0L);
            }
        }
        return prop;
    }
}

