/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.importer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.zip.GZIPInputStream;
import net.yacy.cora.date.AbstractFormatter;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.language.synonyms.SynonymLibrary;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.Document;
import net.yacy.document.LibraryProvider;
import net.yacy.document.Tokenizer;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.content.XMLPackReader;
import net.yacy.document.importer.Importer;
import net.yacy.search.Switchboard;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.common.SolrInputDocument;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonListImporter
extends Thread
implements Importer {
    private static ConcurrentLog log = new ConcurrentLog("JsonListImporter");
    public static JsonListImporter job = null;
    private InputStream source;
    private final String name;
    private final File inputFile;
    private final long sourceSize;
    private long lineCount = 0L;
    private long startTime;
    private long consumed = 0L;
    private boolean abort;
    private final boolean deletewhendone;

    public JsonListImporter(File inputFile, boolean gz, boolean deletewhendone) throws IOException {
        super("JsonListImporter - from file " + inputFile.getName());
        this.inputFile = inputFile;
        this.name = inputFile.getName();
        this.sourceSize = inputFile.length();
        this.abort = false;
        this.deletewhendone = deletewhendone;
        this.source = new FileInputStream(inputFile);
        if (this.name.endsWith(".gz") || gz) {
            this.source = new GZIPInputStream(this.source);
        }
    }

    @Override
    public void run() {
        try {
            this.proceessPackJson();
        }
        catch (IOException e) {
            log.warn(e);
        }
    }

    public void proceessPackJson() throws IOException {
        int t;
        String line;
        this.startTime = System.currentTimeMillis();
        job = this;
        int concurrency = Runtime.getRuntime().availableProcessors();
        final ArrayBlockingQueue<SolrInputDocument> sidQueue = new ArrayBlockingQueue<SolrInputDocument>(concurrency * 2);
        Thread[] indexer = new Thread[concurrency];
        for (int t2 = 0; t2 < indexer.length; ++t2) {
            indexer[t2] = new Thread(this, "Switchboard.processPackJson-" + t2){
                final /* synthetic */ JsonListImporter this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void run() {
                    VocabularyScraper scraper = new VocabularyScraper();
                    block4: while (true) {
                        try {
                            SolrInputDocument sid;
                            while ((sid = (SolrInputDocument)sidQueue.take()) != XMLPackReader.POISON_DOCUMENT) {
                                String id = (String)sid.getFieldValue(CollectionSchema.id.getSolrFieldName());
                                String text = (String)sid.getFieldValue(CollectionSchema.text_t.getSolrFieldName());
                                if (text == null || text.length() <= 0 || id == null) continue;
                                try {
                                    if (SynonymLibrary.size() > 0 || !LibraryProvider.autotagging.isEmpty()) {
                                        DigestURL rootURL = new DigestURL((String)sid.getFieldValue(CollectionSchema.sku.getSolrFieldName()), ASCII.getBytes(id));
                                        Tokenizer tokenizer = new Tokenizer(rootURL, text, LibraryProvider.dymLib, true, scraper);
                                        Map<String, Set<String>> facets = Document.computeGenericFacets(tokenizer.tags());
                                        Switchboard.getSwitchboard().index.fulltext().getDefaultConfiguration().enrich(sid, tokenizer.synonyms(), facets);
                                    }
                                    Switchboard.getSwitchboard().index.putDocument(sid);
                                    continue block4;
                                }
                                catch (MalformedURLException malformedURLException) {
                                }
                            }
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                }
            };
            indexer[t2].start();
        }
        BufferedInputStream bis = new BufferedInputStream(this.source);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)bis, StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null && !this.abort) {
            JSONTokener jt = new JSONTokener(line);
            JSONObject json = null;
            try {
                json = new JSONObject(jt);
            }
            catch (JSONException e1) {
                throw new IOException(e1.getMessage());
            }
            if (json.opt("index") != null && json.length() == 1 || json.length() == 0) continue;
            SolrInputDocument pack = new SolrInputDocument();
            CollectionSchema.httpstatus_i.add(pack, 200);
            for (String key : json.keySet()) {
                String durls;
                String id;
                DigestURL durl;
                Object o = json.opt(key);
                if (o == null) continue;
                if (o instanceof JSONArray) {
                    AnchorURL b;
                    int i;
                    ArrayList<String> protocol;
                    ArrayList<String> urlstub;
                    JSONArray a = (JSONArray)o;
                    if (key.equals("inboundlinks_sxt")) {
                        urlstub = new ArrayList<String>();
                        protocol = new ArrayList<String>();
                        for (i = 0; i < a.length(); ++i) {
                            b = new AnchorURL((String)a.opt(i));
                            urlstub.add(b.urlstub(true, true));
                            protocol.add(b.getProtocol());
                        }
                        CollectionSchema.inboundlinks_urlstub_sxt.add(pack, urlstub);
                        CollectionSchema.inboundlinks_protocol_sxt.add(pack, protocol);
                        continue;
                    }
                    if (key.equals("outboundlinks_sxt")) {
                        urlstub = new ArrayList();
                        protocol = new ArrayList();
                        for (i = 0; i < a.length(); ++i) {
                            b = new AnchorURL((String)a.opt(i));
                            urlstub.add(b.urlstub(true, true));
                            protocol.add(b.getProtocol());
                        }
                        CollectionSchema.outboundlinks_urlstub_sxt.add(pack, urlstub);
                        CollectionSchema.outboundlinks_protocol_sxt.add(pack, protocol);
                        continue;
                    }
                    if (key.equals("images_sxt")) {
                        urlstub = new ArrayList();
                        protocol = new ArrayList();
                        for (i = 0; i < a.length(); ++i) {
                            b = new AnchorURL((String)a.opt(i));
                            urlstub.add(b.urlstub(true, true));
                            protocol.add(b.getProtocol());
                        }
                        CollectionSchema.images_urlstub_sxt.add(pack, urlstub);
                        CollectionSchema.images_protocol_sxt.add(pack, protocol);
                        continue;
                    }
                    CollectionSchema ctype = null;
                    try {
                        ctype = CollectionSchema.valueOf(key);
                    }
                    catch (Exception e) {
                        log.warn("unknown key for CollectionSchema: " + key);
                        continue;
                    }
                    ArrayList<Object> list2 = new ArrayList<Object>();
                    for (i = 0; i < a.length(); ++i) {
                        list2.add(a.opt(i));
                    }
                    ctype.add(pack, list2);
                    continue;
                }
                if (key.equals("url") || key.equals("url_s") || key.equals("sku")) {
                    durl = new DigestURL(o.toString());
                    id = ASCII.String(durl.hash());
                    pack.setField(CollectionSchema.sku.getSolrFieldName(), (Object)durl.toNormalform(true));
                    pack.setField(CollectionSchema.id.getSolrFieldName(), (Object)id);
                    pack.setField(CollectionSchema.host_s.getSolrFieldName(), (Object)durl.getHost());
                    pack.setField(CollectionSchema.host_id_s.getSolrFieldName(), (Object)id.substring(6));
                    continue;
                }
                if (key.equals("description")) {
                    ArrayList<String> descriptions = new ArrayList<String>();
                    descriptions.add(o.toString());
                    CollectionSchema.description_txt.add(pack, descriptions);
                    continue;
                }
                if (key.equals("referrer_url_s")) {
                    durl = new DigestURL(o.toString());
                    id = ASCII.String(durl.hash());
                    pack.setField(CollectionSchema.referrer_id_s.getSolrFieldName(), (Object)id);
                    continue;
                }
                CollectionSchema ctype = null;
                try {
                    ctype = CollectionSchema.valueOf(key);
                }
                catch (Exception e) {
                    log.warn("unknown key for CollectionSchema: " + key);
                    continue;
                }
                if (ctype != null && ctype.getType() == SolrType.date) {
                    String d = o.toString();
                    Date dd = d == null || d.length() == 0 ? null : AbstractFormatter.parseAny(d);
                    if (dd == null) continue;
                    pack.setField(ctype.getSolrFieldName(), (Object)ISO8601Formatter.FORMATTER.format(dd));
                    continue;
                }
                if (!pack.containsKey((Object)CollectionSchema.host_s.getSolrFieldName()) && (durls = (String)pack.getFieldValue(CollectionSchema.sku.getSolrFieldName())) != null) {
                    DigestURL durl2 = new DigestURL(durls);
                    pack.setField(CollectionSchema.host_s.getSolrFieldName(), (Object)durl2.getHost());
                }
                pack.setField(key, (Object)o.toString());
            }
            try {
                sidQueue.put(pack);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++this.lineCount;
            this.consumed += (long)line.length();
        }
        br.close();
        br = null;
        for (t = 0; t < indexer.length; ++t) {
            try {
                sidQueue.put(XMLPackReader.POISON_DOCUMENT);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (t = 0; t < indexer.length; ++t) {
            try {
                indexer[t].join(10000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.deletewhendone) {
            this.inputFile.delete();
        }
        log.info("finished processing json pack: " + (System.currentTimeMillis() - this.startTime) / 1000L + " seconds");
    }

    public void quit() {
        this.abort = true;
    }

    @Override
    public String source() {
        return this.name;
    }

    @Override
    public int count() {
        return (int)this.lineCount;
    }

    @Override
    public int speed() {
        if (this.lineCount == 0L) {
            return 0;
        }
        return (int)(this.lineCount / Math.max(0L, this.runningTime()));
    }

    @Override
    public long runningTime() {
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    @Override
    public long remainingTime() {
        if (this.consumed == 0L) {
            return 0L;
        }
        long speed = this.consumed / this.runningTime();
        return (this.sourceSize - this.consumed) / speed;
    }

    @Override
    public String status() {
        return "";
    }
}

