/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document;

import com.ibm.icu.util.DateRule;
import com.ibm.icu.util.EasterHoliday;
import com.ibm.icu.util.SimpleDateRule;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.yacy.cora.date.GenericFormatter;

public class DateDetection {
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final String CONPATT = "uuuu/MM/dd";
    private static final DateTimeFormatter CONFORM = DateTimeFormatter.ofPattern("uuuu/MM/dd").withLocale(Locale.US).withZone(ZoneOffset.UTC);
    private static final LinkedHashMap<Language, String[]> Weekdays = new LinkedHashMap();
    private static final LinkedHashMap<Language, String[]> Months = new LinkedHashMap();
    private static final int[] MaxDaysInMonth = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int CURRENT_YEAR;
    private static final String BODNCG = "(?:\\s|^)";
    private static final String EODNCG = "(?:[).:;! ]|$)";
    private static final String SEPARATORNCG = "(?:/|-| - |\\.\\s|,\\s|\\.|,|\\s)";
    private static final String DAYCAPTURE = "(\\d{1,2})";
    private static final String YEARCAPTURE = "(\\d{2}|\\d{4})";
    private static final String MONTHCAPTURE = "(\\p{L}{3,}|\\d{1,2})";
    public static HolidayMap Holidays;
    public static Map<Pattern, Date[]> HolidayPattern;
    private static final LanguageRecognition ENGLISH_LANGUAGE;
    private static final LanguageRecognition GERMAN_LANGUAGE;
    private static final LanguageRecognition FRENCH_LANGUAGE;
    private static final LanguageRecognition ENGLISH_GERMAN_LANGUAGE;
    private static final LanguageRecognition ENGLISH_GERMAN_FRENCH_SPANISH_ITALIAN_LANGUAGE;
    private static final HashMap<String, Long> specialDayOffset;

    public static HolidayMap getHolidays(int currentYear) {
        HolidayMap result = new HolidayMap();
        TimeZone dateRulesTimeZone = TimeZone.getDefault();
        result.put("Neujahr", DateDetection.sameDayEveryYear(0, 1, currentYear));
        result.put("Heilige Drei K\u00f6nige", DateDetection.sameDayEveryYear(0, 6, currentYear));
        result.put("Valentinstag", DateDetection.sameDayEveryYear(1, 14, currentYear));
        result.put("Weiberfastnacht", DateDetection.holiDayEventRule(new EasterHoliday(-52, "Weiberfastnacht").getRule(), currentYear, dateRulesTimeZone));
        result.put("Weiberfasching", (Date[])result.get("Weiberfastnacht"));
        result.put("Rosenmontag", DateDetection.holiDayEventRule(new EasterHoliday(-48, "Rosenmontag").getRule(), currentYear, dateRulesTimeZone));
        result.put("Faschingsdienstag", DateDetection.holiDayEventRule(EasterHoliday.SHROVE_TUESDAY.getRule(), currentYear, dateRulesTimeZone));
        result.put("Fastnacht", (Date[])result.get("Faschingsdienstag"));
        result.put("Aschermittwoch", DateDetection.holiDayEventRule(EasterHoliday.ASH_WEDNESDAY.getRule(), currentYear, dateRulesTimeZone));
        result.put("Palmsonntag", DateDetection.holiDayEventRule(EasterHoliday.PALM_SUNDAY.getRule(), currentYear, dateRulesTimeZone));
        result.put("Gr\u00fcndonnerstag", DateDetection.holiDayEventRule(EasterHoliday.MAUNDY_THURSDAY.getRule(), currentYear, dateRulesTimeZone));
        result.put("Karfreitag", DateDetection.holiDayEventRule(EasterHoliday.GOOD_FRIDAY.getRule(), currentYear, dateRulesTimeZone));
        result.put("Karsamstag", DateDetection.holiDayEventRule(new EasterHoliday(-1, "Karsamstag").getRule(), currentYear, dateRulesTimeZone));
        result.put("Ostersonntag", DateDetection.holiDayEventRule(EasterHoliday.EASTER_SUNDAY.getRule(), currentYear, dateRulesTimeZone));
        result.put("Ostermontag", DateDetection.holiDayEventRule(EasterHoliday.EASTER_MONDAY.getRule(), currentYear, dateRulesTimeZone));
        result.put("Ostern", DateDetection.getOsternEventRule(currentYear, dateRulesTimeZone));
        result.put("Walpurgisnacht", DateDetection.sameDayEveryYear(3, 30, currentYear));
        result.put("Tag der Arbeit", DateDetection.sameDayEveryYear(4, 1, currentYear));
        Date[] mothersDays = new Date[3];
        int year = currentYear - 1;
        for (int i = 0; i < 3; ++i) {
            LocalDate firstMay = LocalDate.of(year, java.time.Month.MAY, 1);
            LocalDate mothersDay = firstMay.with(TemporalAdjusters.firstInMonth(DayOfWeek.SUNDAY)).with(TemporalAdjusters.next(DayOfWeek.SUNDAY));
            mothersDays[i] = DateDetection.toMidnightUTCDate(mothersDay);
            ++year;
        }
        result.put("Muttertag", mothersDays);
        result.put("Christi Himmelfahrt", DateDetection.holiDayEventRule(EasterHoliday.ASCENSION.getRule(), currentYear, dateRulesTimeZone));
        result.put("Pfingstsonntag", DateDetection.holiDayEventRule(EasterHoliday.WHIT_SUNDAY.getRule(), currentYear, dateRulesTimeZone));
        result.put("Pfingstmontag", DateDetection.holiDayEventRule(EasterHoliday.WHIT_MONDAY.getRule(), currentYear, dateRulesTimeZone));
        result.put("Fronleichnam", DateDetection.holiDayEventRule(EasterHoliday.CORPUS_CHRISTI.getRule(), currentYear, dateRulesTimeZone));
        result.put("Mari\u00e4 Himmelfahrt", DateDetection.sameDayEveryYear(7, 15, currentYear));
        result.put("Tag der Deutschen Einheit", DateDetection.sameDayEveryYear(9, 3, currentYear));
        result.put("Reformationstag", DateDetection.sameDayEveryYear(9, 31, currentYear));
        result.put("Allerheiligen", DateDetection.sameDayEveryYear(10, 1, currentYear));
        result.put("Allerseelen", DateDetection.sameDayEveryYear(10, 2, currentYear));
        result.put("Martinstag", DateDetection.sameDayEveryYear(10, 11, currentYear));
        result.put("St. Martin", (Date[])result.get("Martinstag"));
        result.put("Bu\u00df- und Bettag", DateDetection.holiDayEventRule((DateRule)new SimpleDateRule(10, 22, 4, true), currentYear, dateRulesTimeZone));
        result.put("Nikolaus", DateDetection.sameDayEveryYear(11, 6, currentYear));
        result.put("Heiligabend", DateDetection.sameDayEveryYear(11, 24, currentYear));
        result.put("1. Weihnachtsfeiertag", DateDetection.sameDayEveryYear(11, 25, currentYear));
        result.put("2. Weihnachtsfeiertag", DateDetection.sameDayEveryYear(11, 26, currentYear));
        Date[] advents1 = new Date[3];
        Date[] advents2 = new Date[3];
        Date[] advents3 = new Date[3];
        Date[] advents4 = new Date[3];
        Date[] volkstrauertagen = new Date[3];
        Date[] sundaysOfTheDead = new Date[3];
        year = currentYear - 1;
        TemporalAdjuster prevSunday = TemporalAdjusters.previous(DayOfWeek.SUNDAY);
        for (int i = 0; i < 3; ++i) {
            LocalDate christmas = LocalDate.of(year, java.time.Month.DECEMBER, 25);
            LocalDate advent4 = christmas.with(prevSunday);
            LocalDate advent3 = advent4.with(prevSunday);
            LocalDate advent2 = advent3.with(prevSunday);
            LocalDate advent1 = advent2.with(prevSunday);
            LocalDate sundayOfTheDead = advent1.with(prevSunday);
            LocalDate volkstrauertag = sundayOfTheDead.with(prevSunday);
            advents4[i] = DateDetection.toMidnightUTCDate(advent4);
            advents3[i] = DateDetection.toMidnightUTCDate(advent3);
            advents2[i] = DateDetection.toMidnightUTCDate(advent2);
            advents1[i] = DateDetection.toMidnightUTCDate(advent1);
            sundaysOfTheDead[i] = DateDetection.toMidnightUTCDate(sundayOfTheDead);
            volkstrauertagen[i] = DateDetection.toMidnightUTCDate(volkstrauertag);
            ++year;
        }
        result.put("1. Advent", advents1);
        result.put("2. Advent", advents2);
        result.put("3. Advent", advents3);
        result.put("4. Advent", advents4);
        result.put("Totensonntag", sundaysOfTheDead);
        result.put("Volkstrauertag", volkstrauertagen);
        result.put("Silvester", DateDetection.sameDayEveryYear(11, 31, currentYear));
        result.put("Eastern", (Date[])result.get("Ostern"));
        result.put("New Year's Day", (Date[])result.get("Neujahr"));
        result.put("Epiphany", (Date[])result.get("Heilige Drei K\u00f6nige"));
        result.put("Valentine's Day", (Date[])result.get("Valentinstag"));
        result.put("Orthodox Christmas", DateDetection.sameDayEveryYear(0, 7, currentYear));
        result.put("St. Patrick's Day", DateDetection.sameDayEveryYear(2, 17, currentYear));
        result.put("April Fools' Day", DateDetection.sameDayEveryYear(3, 1, currentYear));
        result.put("Independence Day", DateDetection.sameDayEveryYear(6, 4, currentYear));
        result.put("Halloween", (Date[])result.get("Reformationstag"));
        result.put("Thanksgiving", DateDetection.holiDayEventRule((DateRule)new SimpleDateRule(10, 22, 5, true), currentYear, dateRulesTimeZone));
        result.put("Immaculate Conception of the Virgin Mary", DateDetection.sameDayEveryYear(11, 8, currentYear));
        result.put("Christmas Eve", (Date[])result.get("Heiligabend"));
        result.put("Christmas Day", (Date[])result.get("1. Weihnachtsfeiertag"));
        result.put("Boxing Day", (Date[])result.get("2. Weihnachtsfeiertag"));
        result.put("New Year's Eve", (Date[])result.get("Silvester"));
        return result;
    }

    public static Date toMidnightUTCDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(ZonedDateTime.of(localDate, LocalTime.MIDNIGHT, UTC_TIMEZONE.toZoneId()).toInstant());
    }

    private static Date[] sameDayEveryYear(int month, int day, int currentYear) {
        Date[] r = new Date[4];
        GregorianCalendar cal = new GregorianCalendar(UTC_TIMEZONE);
        cal.clear();
        cal.set(currentYear - 1, month, day);
        r[0] = cal.getTime();
        for (int y = 1; y < 4; ++y) {
            ((Calendar)cal).add(1, 1);
            r[y] = cal.getTime();
        }
        return r;
    }

    private static Date[] holiDayEventRule(DateRule holidayrule, int currentYear, TimeZone ruleTimeZone) {
        Date[] r = new Date[3];
        GregorianCalendar january1Calendar = new GregorianCalendar(ruleTimeZone);
        january1Calendar.clear();
        GregorianCalendar utcCalendar = new GregorianCalendar(UTC_TIMEZONE);
        GregorianCalendar ruleCalendar = new GregorianCalendar(ruleTimeZone);
        int year = currentYear - 1;
        for (int y = 0; y < 3; ++y) {
            january1Calendar.set(year, 0, 1);
            Date holiday = holidayrule.firstAfter(january1Calendar.getTime());
            ruleCalendar.setTime(holiday);
            utcCalendar.set(ruleCalendar.get(1), ruleCalendar.get(2), ruleCalendar.get(5));
            r[y] = utcCalendar.getTime();
            ++year;
        }
        return r;
    }

    private static Date[] getOsternEventRule(int currentYear, TimeZone ruleTimeZone) {
        ArrayList osternDates = new ArrayList();
        Collections.addAll(osternDates, DateDetection.holiDayEventRule(EasterHoliday.EASTER_SUNDAY.getRule(), currentYear, ruleTimeZone));
        Collections.addAll(osternDates, DateDetection.holiDayEventRule(EasterHoliday.EASTER_MONDAY.getRule(), currentYear, ruleTimeZone));
        return osternDates.toArray(new Date[osternDates.size()]);
    }

    protected static Date parseDateSafely(String str, DateTimeFormatter formatter) {
        Date res = null;
        if (str != null && !str.isEmpty()) {
            try {
                if (formatter != null) {
                    res = Date.from(LocalDate.parse(str, formatter).atStartOfDay().toInstant(ZoneOffset.UTC));
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return res;
    }

    public static LinkedHashSet<Date> parse(String text, int timezoneOffset) {
        LinkedHashSet<Date> dates = DateDetection.parseRawDate(text);
        for (Map.Entry<Pattern, Date[]> entry2 : HolidayPattern.entrySet()) {
            if (!entry2.getKey().matcher(text).find()) continue;
            for (Date d : entry2.getValue()) {
                dates.add(d);
            }
        }
        return dates;
    }

    public static Date parseLine(String text, int timezoneOffset) {
        Long offset;
        Date[] dd;
        Date d = DateDetection.parseDateSafely(text, CONFORM);
        if (d == null) {
            d = DateDetection.parseDateSafely(text, GenericFormatter.FORMAT_RFC1123_SHORT);
        }
        if (d == null) {
            d = DateDetection.parseDateSafely(text, GenericFormatter.FORMAT_ANSIC);
        }
        if (d == null && (dd = DateDetection.parseRawDate(text)).size() >= 1) {
            d = (Date)dd.iterator().next();
        }
        if (d == null && (offset = specialDayOffset.get(text)) != null) {
            d = new Date(System.currentTimeMillis() / 86400000L * 86400000L + offset);
        }
        if (d == null && (dd = (Date[])Holidays.get(text)) != null) {
            d = dd.length > 1 ? dd[1] : dd[0];
        }
        return d;
    }

    private static LinkedHashSet<Date> parseRawDate(String text) {
        boolean usesLanguageOfMDY;
        LinkedHashSet<Date> YMDDates;
        LinkedHashSet<Date> DMYDates = EndianStyle.DMY.parse(text);
        ShortStyle[] shortStyleCheck = new ShortStyle[]{ShortStyle.DM_GERMAN, ShortStyle.DM_FRENCH, ShortStyle.DM_ITALIAN, ShortStyle.DM_SPANISH};
        LinkedHashSet<Date> DMDates = new LinkedHashSet<Date>();
        for (ShortStyle shortStyle : shortStyleCheck) {
            DMDates.addAll(shortStyle.parse(text));
            if (DMDates.size() > 0) break;
        }
        DMYDates.addAll(DMDates);
        LinkedHashSet<Date> MDYDates = DMYDates.size() == 0 ? EndianStyle.MDY.parse(text) : new LinkedHashSet<Date>(0);
        LinkedHashSet<Date> MDDates = DMYDates.size() == 0 ? ShortStyle.MD_ENGLISH.parse(text) : new LinkedHashSet<Date>(0);
        MDYDates.addAll(MDDates);
        LinkedHashSet<Date> linkedHashSet = YMDDates = DMYDates.size() == 0 && MDYDates.size() == 0 ? EndianStyle.YMD.parse(text) : new LinkedHashSet<Date>(0);
        if (YMDDates.size() > 0 && DMYDates.size() == 0 && MDYDates.size() == 0) {
            return YMDDates;
        }
        if (YMDDates.size() == 0 && DMYDates.size() > 0 && MDYDates.size() == 0) {
            return DMYDates;
        }
        if (YMDDates.size() == 0 && DMYDates.size() == 0 && MDYDates.size() > 0) {
            return MDYDates;
        }
        boolean usesLanguageOfYMD = YMDDates.size() > 0 ? false : EndianStyle.YMD.languageParser.usesLanguageOfNotion(text);
        boolean usesLanguageOfDMY = DMYDates.size() > 0 ? false : EndianStyle.DMY.languageParser.usesLanguageOfNotion(text);
        boolean bl = usesLanguageOfMDY = MDYDates.size() > 0 ? false : EndianStyle.MDY.languageParser.usesLanguageOfNotion(text);
        if (usesLanguageOfYMD && !usesLanguageOfDMY && !usesLanguageOfMDY) {
            return YMDDates;
        }
        if (!usesLanguageOfYMD && usesLanguageOfDMY && !usesLanguageOfMDY) {
            return DMYDates;
        }
        if (!usesLanguageOfYMD && !usesLanguageOfDMY && usesLanguageOfMDY) {
            return MDYDates;
        }
        return DMYDates;
    }

    public static void main(String[] args) {
        Object fill = "";
        for (int i = 0; i < 1000; ++i) {
            fill = (String)fill + "x";
        }
        String[] test2 = new String[]{"\n laden die Stadtwerke \n X am Rosenmontag und am \n Faschingsdienstag zur Disko auf die \n", "kein Datum im Text", " Fastnacht am 4. M\u00e4rz noch", " Fastnacht am 4. April noch\u00ad", "heute 12. Dezember 2014. ", "heute 12. Dezember 2014", "12. Dezember 2014. ", "heute 12. Dezember 2014 ", "heute 12. Dezember 2014. ", "Donnerstag, 18. Dezember 2014 xyz", "Donnerstag, 18 Dezember 2014 xyz", "Donnerstag, 18.Dezember 2014 xyz", "Montag, 8. Dezember 2014 xyz", "Montag, 8.Dezember 2014 xyz", "Donnerstag, 18.12.2014 xyz", "Montag, 8.12.2014 xyz", "Donnerstag, 18.12.14 xyz", "Montag, 8.12.14 xyz", "Mitglied seit: 13. Januar 2007 xyz", "Im Dezember 2014 xyz", "11.12.2014", "11. September 2001", "12.12.2014 08:43", "immer am 1. Dezember abends", "immer am 31. Dezember abends", "immer am 31. dezember abends", "on october 20 every year", " on october 20 every year", "on September 29,", "am Karfreitag um 15:00 Uhr", "11 fevereiro 2001", "12. fevereiro 2002", "13 de fevereiro 2003", "Fevereiro 14, 2004"};
        long t = System.currentTimeMillis();
        for (String s : test2) {
            String parsed = DateDetection.parse((String)fill + " " + s + " " + (String)fill, 0).toString();
            System.out.println("SOURCE: " + s);
            System.out.println("DATE  : " + parsed);
            System.out.println();
        }
        System.out.println("Runtime: " + (System.currentTimeMillis() - t) + " milliseconds.");
    }

    static {
        Weekdays.put(Language.GERMAN, new String[]{"montag", "dienstag", "mittwoch", "donnerstag", "freitag", "samstag", "sonntag"});
        Weekdays.put(Language.ENGLISH, new String[]{"monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"});
        Weekdays.put(Language.FRENCH, new String[]{"lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi", "dimanche"});
        Weekdays.put(Language.SPANISH, new String[]{"lunes", "martes", "mi\u00e9rcoles", "jueves", "viernes", "s\u00e1bado", "domingo"});
        Weekdays.put(Language.ITALIAN, new String[]{"luned\u00ec", "marted\u00ec", "mercoled\u00ec", "gioved\u00ec", "venerd\u00ec", "sabato", "domenica"});
        Months.put(Language.GERMAN, new String[]{"januar", "februar", "m\u00e4rz", "april", "mai", "juni", "juli", "august", "september", "oktober", "november", "dezember"});
        Months.put(Language.ENGLISH, new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"});
        Months.put(Language.FRENCH, new String[]{"janvier", "f\u00e9vrier", "mars", "avril", "mai", "juin", "juillet", "ao\u00fbt", "septembre", "octobre", "novembre", "d\u00e9cembre"});
        Months.put(Language.SPANISH, new String[]{"enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"});
        Months.put(Language.ITALIAN, new String[]{"gennaio", "febbraio", "marzo", "aprile", "maggio", "giugno", "luglio", "agosto", "settembre", "ottobre", "novembre", "dicembre"});
        Months.put(Language.PORTUGUESE, new String[]{"janeiro", "fevereiro", "mar\u00e7o", "abril", "maio", "junho", "julho", "agosto", "setembro", "outubro", "novembro", "dezembro"});
        CURRENT_YEAR = LocalDate.now().getYear();
        Holidays = new HolidayMap();
        HolidayPattern = new HashMap<Pattern, Date[]>();
        Holidays.putAll(DateDetection.getHolidays(CURRENT_YEAR));
        for (Map.Entry holiday : Holidays.entrySet()) {
            HolidayPattern.put(Pattern.compile(BODNCG + (String)holiday.getKey() + EODNCG), (Date[])holiday.getValue());
        }
        ENGLISH_LANGUAGE = new LanguageRecognition(new Language[]{Language.ENGLISH});
        GERMAN_LANGUAGE = new LanguageRecognition(new Language[]{Language.GERMAN});
        FRENCH_LANGUAGE = new LanguageRecognition(new Language[]{Language.FRENCH});
        ENGLISH_GERMAN_LANGUAGE = new LanguageRecognition(new Language[]{Language.GERMAN, Language.ENGLISH});
        ENGLISH_GERMAN_FRENCH_SPANISH_ITALIAN_LANGUAGE = new LanguageRecognition(new Language[]{Language.GERMAN, Language.ENGLISH, Language.FRENCH, Language.SPANISH, Language.ITALIAN, Language.PORTUGUESE});
        specialDayOffset = new HashMap();
        specialDayOffset.put("today", 0L);
        specialDayOffset.put("heute", 0L);
        specialDayOffset.put("tomorrow", 86400000L);
        specialDayOffset.put("morgen", 86400000L);
        specialDayOffset.put("dayaftertomorrow", 172800000L);
        specialDayOffset.put("uebermorgen", 172800000L);
        specialDayOffset.put("yesterday", -86400000L);
        specialDayOffset.put("gestern", -86400000L);
    }

    public static class HolidayMap
    extends TreeMap<String, Date[]> {
        private static final long serialVersionUID = 1L;

        public HolidayMap() {
            super(String.CASE_INSENSITIVE_ORDER);
        }
    }

    public static enum EndianStyle implements StyleParser
    {
        YMD(EntityType.YEAR, EntityType.MONTH, EntityType.DAY, ENGLISH_GERMAN_LANGUAGE, "(?:\\s|^)(\\d{2}|\\d{4})(?:/|-| - |\\.\\s|,\\s|\\.|,|\\s)(\\p{L}{3,}|\\d{1,2})(?:/|-| - |\\.\\s|,\\s|\\.|,|\\s)(\\d{1,2})(?:[).:;! ]|$)"),
        DMY(EntityType.DAY, EntityType.MONTH, EntityType.YEAR, ENGLISH_GERMAN_FRENCH_SPANISH_ITALIAN_LANGUAGE, "(?:\\s|^)(\\d{1,2})(?:/|-| - |\\.\\s|,\\s|\\.|,|\\s)(\\p{L}{3,}|\\d{1,2})(?:/|-| - |\\.\\s|,\\s|\\.|,|\\s)(\\d{2}|\\d{4})(?:[).:;! ]|$)"),
        MDY(EntityType.MONTH, EntityType.DAY, EntityType.YEAR, ENGLISH_LANGUAGE, "(?:\\s|^)(\\p{L}{3,}|\\d{1,2})(?:/|-| - |\\.\\s|,\\s|\\.|,|\\s)(\\d{1,2})(?:/|-| - |\\.\\s|,\\s|\\.|,|\\s)(\\d{2}|\\d{4})(?:[).:;! ]|$)");

        private final Pattern pattern;
        private final EntityType firstEntity;
        private final EntityType secondEntity;
        private final EntityType thirdEntity;
        public final LanguageRecognition languageParser;

        private EndianStyle(EntityType firstEntity, EntityType secondEntity, EntityType thirdEntity, LanguageRecognition languageParser, String patternString) {
            this.firstEntity = firstEntity;
            this.secondEntity = secondEntity;
            this.thirdEntity = thirdEntity;
            this.pattern = Pattern.compile(patternString);
            this.languageParser = languageParser;
        }

        @Override
        public LinkedHashSet<Date> parse(String text) {
            LinkedHashSet<Date> dates = new LinkedHashSet<Date>();
            Matcher matcher = this.pattern.matcher(text);
            while (matcher.find()) {
                int day;
                int i3;
                int i2;
                int i1;
                String entity3;
                String entity2;
                String entity1;
                if (matcher.groupCount() != 3 || (entity1 = matcher.group(1)) == null || (entity2 = matcher.group(2)) == null || (entity3 = matcher.group(3)) == null || (i1 = this.languageParser.parseEntity(this.firstEntity, entity1)) < 0 || (i2 = this.languageParser.parseEntity(this.secondEntity, entity2)) < 0 || (i3 = this.languageParser.parseEntity(this.thirdEntity, entity3)) < 0) continue;
                int n = this.firstEntity == EntityType.DAY ? i1 : (day = this.secondEntity == EntityType.DAY ? i2 : i3);
                int month = this.firstEntity == EntityType.MONTH ? i1 : (this.secondEntity == EntityType.MONTH ? i2 : i3);
                if (day > MaxDaysInMonth[month - 1]) continue;
                int year = this.firstEntity == EntityType.YEAR ? i1 : (this.secondEntity == EntityType.YEAR ? i2 : i3);
                Date parsed = DateDetection.parseDateSafely(year + "/" + (month < 10 ? "0" : "") + month + "/" + (day < 10 ? "0" : "") + day, CONFORM);
                if (parsed != null) {
                    dates.add(parsed);
                }
                if (dates.size() <= 100) continue;
                dates.clear();
                break;
            }
            return dates;
        }
    }

    public static enum ShortStyle implements StyleParser
    {
        MD_ENGLISH(EntityType.MONTH, EntityType.DAY, ENGLISH_LANGUAGE, "(?:\\s|^)on (\\p{L}{3,}|\\d{1,2})(?:/|-| - |\\.\\s|,\\s|\\.|,|\\s)(\\d{1,2})(?:[).:;! ]|$)"),
        DM_GERMAN(EntityType.DAY, EntityType.MONTH, GERMAN_LANGUAGE, "(?:\\s|^)am (\\d{1,2})(?:/|-| - |\\.\\s|,\\s|\\.|,|\\s)(\\p{L}{3,}|\\d{1,2})(?:[).:;! ]|$)"),
        DM_FRENCH(EntityType.DAY, EntityType.MONTH, FRENCH_LANGUAGE, "(?:\\s|^)le (\\d{1,2}) (\\p{L}{3,}|\\d{1,2})(?:[).:;! ]|$)"),
        DM_ITALIAN(EntityType.DAY, EntityType.MONTH, FRENCH_LANGUAGE, "(?:\\s|^)il (\\d{1,2}) (\\p{L}{3,}|\\d{1,2})(?:[).:;! ]|$)"),
        DM_SPANISH(EntityType.DAY, EntityType.MONTH, FRENCH_LANGUAGE, "(?:\\s|^)el (\\d{1,2}) de (\\p{L}{3,}|\\d{1,2})(?:[).:;! ]|$)");

        public final Pattern pattern;
        private final EntityType firstEntity;
        private final EntityType secondEntity;
        public final LanguageRecognition languageParser;

        private ShortStyle(EntityType firstEntity, EntityType secondEntity, LanguageRecognition languageParser, String patternString) {
            this.firstEntity = firstEntity;
            this.secondEntity = secondEntity;
            this.pattern = Pattern.compile(patternString);
            this.languageParser = languageParser;
        }

        @Override
        public LinkedHashSet<Date> parse(String text) {
            LinkedHashSet<Date> dates = new LinkedHashSet<Date>();
            Matcher matcher = this.pattern.matcher(text);
            while (matcher.find()) {
                Date atNextYear;
                int month;
                int i2;
                int i1;
                String entity2;
                String entity1;
                if (matcher.groupCount() != 2 || (entity1 = matcher.group(1)) == null || (entity2 = matcher.group(2)) == null || (i1 = this.languageParser.parseEntity(this.firstEntity, entity1)) < 0 || (i2 = this.languageParser.parseEntity(this.secondEntity, entity2)) < 0) continue;
                int day = this.firstEntity == EntityType.DAY ? i1 : i2;
                int n = month = this.firstEntity == EntityType.MONTH ? i1 : i2;
                if (day > MaxDaysInMonth[month - 1]) continue;
                int thisyear = CURRENT_YEAR;
                int nextyear = CURRENT_YEAR + 1;
                String datestub = "/" + (month < 10 ? "0" : "") + month + "/" + (day < 10 ? "0" : "") + day;
                Date atThisYear = DateDetection.parseDateSafely(thisyear + datestub, CONFORM);
                if (atThisYear != null) {
                    dates.add(atThisYear);
                }
                if ((atNextYear = DateDetection.parseDateSafely(nextyear + datestub, CONFORM)) != null) {
                    dates.add(atNextYear);
                }
                if (dates.size() <= 100) continue;
                dates.clear();
                break;
            }
            return dates;
        }
    }

    public static class LanguageRecognition {
        private final Pattern weekdayMatch;
        private final Pattern monthMatch;
        private final Set<Language> usedInLanguages = new HashSet<Language>();
        private final Map<String, Integer> weekdayIndex = new HashMap<String, Integer>();
        private final Map<String, Integer> monthIndex = new HashMap<String, Integer>();
        private final Map<String, Integer> monthIndexAbbrev = new HashMap<String, Integer>();

        public LanguageRecognition(Language[] languages) {
            StringBuilder weekdayMatchString = new StringBuilder();
            StringBuilder monthMatchString = new StringBuilder();
            for (Language language : languages) {
                String[] months;
                this.usedInLanguages.add(language);
                String[] weekdays = Weekdays.get((Object)language);
                if (weekdays != null) {
                    assert (weekdays.length == 7);
                    for (int i = 0; i < 7; ++i) {
                        this.weekdayIndex.put(weekdays[i], i);
                        weekdayMatchString.append("|(?:").append(DateDetection.BODNCG).append(weekdays[i]).append(DateDetection.SEPARATORNCG).append(DateDetection.EODNCG).append(')');
                    }
                }
                if ((months = Months.get((Object)language)) == null) continue;
                assert (months.length == 12);
                for (int i = 0; i < 12; ++i) {
                    this.monthIndex.put(months[i], i + 1);
                    monthMatchString.append("|(?:").append(DateDetection.BODNCG).append(months[i]).append(DateDetection.SEPARATORNCG).append(DateDetection.EODNCG).append(')');
                    String abbrev = months[i].substring(0, 3);
                    if (this.monthIndexAbbrev.containsKey(abbrev) && this.monthIndexAbbrev.get(abbrev) != i + 1) {
                        this.monthIndexAbbrev.put(abbrev, -1);
                        continue;
                    }
                    this.monthIndexAbbrev.put(abbrev, i + 1);
                }
            }
            this.weekdayMatch = Pattern.compile(weekdayMatchString.length() > 0 ? weekdayMatchString.substring(1) : "");
            this.monthMatch = Pattern.compile(monthMatchString.length() > 0 ? monthMatchString.substring(1) : "");
        }

        public boolean usesLanguageOfNotion(String text) {
            return this.weekdayMatch.matcher(text).matches() || this.monthMatch.matcher(text).matches();
        }

        public int parseEntity(EntityType entity, String object) {
            if (entity == EntityType.YEAR) {
                try {
                    int i = Integer.parseInt((String)object);
                    if (i < 100) {
                        i += 2000;
                    }
                    if (i > CURRENT_YEAR + 10) {
                        return -1;
                    }
                    return i;
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
            if (entity == EntityType.MONTH) {
                try {
                    int i = Integer.parseInt((String)object);
                    if (i >= 1 && i <= 12) {
                        return i;
                    }
                    return -1;
                }
                catch (NumberFormatException e) {
                    Integer i;
                    if (((String)object).length() == 3) {
                        object = ((String)object).substring(0, 1).toUpperCase() + ((String)object).substring(1).toLowerCase();
                        try {
                            Month m = Month.valueOf((String)object);
                            return m.count;
                        }
                        catch (IllegalArgumentException | NoClassDefFoundError m) {
                            // empty catch block
                        }
                    }
                    if ((i = this.monthIndex.get(object = ((String)object).toLowerCase())) != null) {
                        return i;
                    }
                    if (((String)object).length() == 3 && (i = this.monthIndexAbbrev.get(((String)object).substring(0, 3))) != null) {
                        return i;
                    }
                    return -1;
                }
            }
            if (entity == EntityType.DAY) {
                try {
                    int i = Integer.parseInt((String)object);
                    if (i < 1 || i > 31) {
                        return -1;
                    }
                    return i;
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
            return -1;
        }
    }

    public static enum Language {
        GERMAN,
        ENGLISH,
        FRENCH,
        SPANISH,
        ITALIAN,
        PORTUGUESE;

    }

    public static interface StyleParser {
        public LinkedHashSet<Date> parse(String var1);
    }

    public static enum EntityType {
        YEAR(new LinkedHashMap<Language, String[]>()),
        MONTH(Months),
        DAY(new LinkedHashMap<Language, String[]>()),
        WEEKDAYS(Weekdays);

        LinkedHashMap<Language, String[]> languageTerms;

        private EntityType(LinkedHashMap<Language, String[]> languageTerms) {
            this.languageTerms = languageTerms;
        }
    }

    public static enum Month {
        Jan(1),
        Feb(2),
        Mar(3),
        Apr(4),
        May(5),
        Jun(6),
        Jul(7),
        Aug(8),
        Sep(9),
        Oct(10),
        Nov(11),
        Dec(12);

        private final int count;

        private Month(int count) {
            this.count = count;
        }
    }

    public static enum Weekday {
        Mon(Weekdays, 0),
        Tue(Weekdays, 1),
        Wed(Weekdays, 2),
        Thu(Weekdays, 3),
        Fri(Weekdays, 4),
        Sat(Weekdays, 5),
        Sun(Weekdays, 6);

        private final Map<String, Language> inLanguages = new HashMap<String, Language>();
        public final int offset;

        private Weekday(LinkedHashMap<Language, String[]> weekdayMap, int offset) {
            this.offset = offset;
            for (Map.Entry<Language, String[]> entry2 : weekdayMap.entrySet()) {
                this.inLanguages.put(entry2.getValue()[offset], entry2.getKey());
            }
        }
    }
}

