/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class SizeLimitedMap<K, V>
extends LinkedHashMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6088727126150060068L;
    private final int sizeLimit;
    private boolean limitExceeded;

    public SizeLimitedMap(int sizeLimit) {
        this.sizeLimit = sizeLimit;
        this.limitExceeded = false;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean res;
        boolean bl = res = this.size() > this.sizeLimit;
        if (res) {
            this.limitExceeded = true;
        }
        return res;
    }

    public boolean isLimitExceeded() {
        return this.limitExceeded;
    }
}

