/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.order;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.storage.ARC;
import net.yacy.cora.storage.ConcurrentARC;
import net.yacy.cora.util.Memory;

public class Digest {
    public static Queue<MessageDigest> digestPool = new ConcurrentLinkedQueue<MessageDigest>();
    private static final int md5CacheSize = Math.max(1000, Math.min(1000000, (int)(Memory.available() / 50000L)));
    private static ARC<String, byte[]> md5Cache = null;

    public static void cleanup() {
        md5Cache.clear();
    }

    public static String encodeHex(long in, int length) {
        Object s = Long.toHexString(in);
        while (((String)s).length() < length) {
            s = "0" + (String)s;
        }
        return s;
    }

    public static String encodeOctal(byte[] in) {
        if (in == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(in.length * 8 / 3);
        for (byte element : in) {
            if ((0xFF & element) < 8) {
                result.append('0');
            }
            result.append(Integer.toOctalString(0xFF & element));
        }
        return result.toString();
    }

    public static String encodeHex(byte[] in) {
        if (in == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(in.length * 2);
        for (byte element : in) {
            if ((0xFF & element) < 16) {
                result.append('0');
            }
            result.append(Integer.toHexString(0xFF & element));
        }
        return result.toString();
    }

    public static byte[] decodeHex(String hex) {
        byte[] result = new byte[hex.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(16 * Integer.parseInt(Character.toString(hex.charAt(i * 2)), 16) + Integer.parseInt(Character.toString(hex.charAt(i * 2 + 1)), 16));
        }
        return result;
    }

    public static String encodeMD5Hex(String key) {
        return Digest.encodeHex(Digest.encodeMD5Raw(key));
    }

    public static String encodeMD5Hex(File file) throws IOException {
        return Digest.encodeHex(Digest.encodeMD5Raw(file));
    }

    public static String encodeMD5Hex(byte[] b) {
        return Digest.encodeHex(Digest.encodeMD5Raw(b));
    }

    public static byte[] encodeMD5Raw(String key) {
        byte[] h = md5Cache.get(key);
        if (h != null) {
            return h;
        }
        MessageDigest digest = digestPool.poll();
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("MD5");
                digest.reset();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        } else {
            digest.reset();
        }
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        digest.update(keyBytes);
        byte[] result = digest.digest();
        digest.reset();
        digestPool.add(digest);
        md5Cache.insertIfAbsent(key, result);
        return result;
    }

    public static byte[] encodeMD5Raw(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            System.out.println("file not found:" + file.toString());
            e.printStackTrace();
            return null;
        }
        md5FilechunkConsumer md5consumer = new md5FilechunkConsumer(65536, 8);
        ExecutorService service = Executors.newSingleThreadExecutor();
        Future<MessageDigest> md5result = service.submit(md5consumer);
        service.shutdown();
        try {
            while (true) {
                filechunk c;
                if ((c = md5consumer.nextFree()) == null) {
                    throw new IOException("c == null, probably interrupted");
                }
                c.n = in.read(c.b);
                if (c.n <= 0) {
                    break;
                }
                md5consumer.consume(c);
            }
        }
        catch (IOException e) {
            System.out.println("file error with " + file.toString() + ": " + e.getMessage());
            e.printStackTrace();
            md5consumer.consume(md5FilechunkConsumer.poison);
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        md5consumer.consume(md5FilechunkConsumer.poison);
        try {
            return md5result.get().digest();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    public static String fastFingerprintHex(File file, boolean includeDate) {
        try {
            return Digest.encodeHex(Digest.fastFingerprintRaw(file, includeDate));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String fastFingerprintB64(File file, boolean includeDate) {
        try {
            byte[] b = Digest.fastFingerprintRaw(file, includeDate);
            assert (b != null) : "file = " + file.toString();
            if (b == null || b.length == 0) {
                return null;
            }
            assert (b.length != 0) : "file = " + file.toString();
            return Base64Order.enhancedCoder.encode(b);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fastFingerprintRaw(File file, boolean includeDate) throws IOException {
        MessageDigest digest;
        int mb = 16384;
        long fl = file.length();
        if (fl <= 32768L) {
            return Digest.encodeMD5Raw(file);
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        byte[] a = new byte[16384];
        try {
            raf.seek(0L);
            raf.readFully(a, 0, 16384);
            digest.update(a, 0, 16384);
            raf.seek(fl - 16384L);
            raf.readFully(a, 0, 16384);
            digest.update(a, 0, 16384);
            digest.update(NaturalOrder.encodeLong(fl, 8), 0, 8);
            if (includeDate) {
                digest.update(NaturalOrder.encodeLong(file.lastModified(), 8), 0, 8);
            }
        }
        finally {
            raf.close();
            try {
                raf.getChannel().close();
            }
            catch (IOException iOException) {}
        }
        return digest.digest();
    }

    private static byte[] encodeMD5Raw(byte[] b) {
        try {
            int n;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.reset();
            ByteArrayInputStream in = new ByteArrayInputStream(b);
            byte[] buf = new byte[2048];
            while ((n = in.read(buf)) > 0) {
                digest.update(buf, 0, n);
            }
            ((InputStream)in).close();
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Internal Error at md5:" + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("byte[] error: " + e.getMessage());
        }
        return null;
    }

    public static void main(String[] s) {
        File f;
        long start = System.currentTimeMillis();
        if (s.length == 0) {
            System.out.println("usage: -[md5|fingerprint] <arg>");
            System.exit(0);
        }
        if (s[0].equals("-md5")) {
            f = new File(s[1]);
            try {
                System.out.println("MD5 (" + f.getName() + ") = " + Digest.encodeMD5Hex(f));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (s[0].equals("-fhex")) {
            f = new File(s[1]);
            System.out.println("fingerprint hex (" + f.getName() + ") = " + Digest.fastFingerprintHex(f, true));
        }
        if (s[0].equals("-fb64")) {
            f = new File(s[1]);
            System.out.println("fingerprint b64 (" + f.getName() + ") = " + Digest.fastFingerprintB64(f, true));
        }
        if (s[0].equals("-strfhex") && s.length > 1) {
            System.out.println(Digest.encodeMD5Hex(s[1]));
        }
        System.out.println("time: " + (System.currentTimeMillis() - start) + " ms");
    }

    static {
        try {
            md5Cache = new ConcurrentARC<String, byte[]>(md5CacheSize, Math.max(8, 2 * Runtime.getRuntime().availableProcessors()));
        }
        catch (OutOfMemoryError e) {
            md5Cache = new ConcurrentARC<String, byte[]>(1000, Math.max(2, Runtime.getRuntime().availableProcessors()));
        }
    }

    private static class md5FilechunkConsumer
    implements Callable<MessageDigest> {
        private final BlockingQueue<filechunk> empty;
        private final BlockingQueue<filechunk> filed;
        protected static filechunk poison = new filechunk(0);
        private MessageDigest digest;

        public md5FilechunkConsumer(int bufferSize, int bufferCount) {
            this.empty = new ArrayBlockingQueue<filechunk>(bufferCount);
            this.filed = new LinkedBlockingQueue<filechunk>();
            for (int i = 0; i < bufferCount; ++i) {
                this.empty.add(new filechunk(bufferSize));
            }
            try {
                this.digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println("Internal Error at md5:" + e.getMessage());
            }
            this.digest.reset();
        }

        public void consume(filechunk c) {
            try {
                this.filed.put(c);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public filechunk nextFree() throws IOException {
            try {
                return this.empty.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new IOException(e);
            }
        }

        @Override
        public MessageDigest call() {
            try {
                filechunk c;
                while ((c = this.filed.take()) != poison) {
                    this.digest.update(c.b, 0, c.n);
                    this.empty.put(c);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.digest;
        }
    }

    private static class filechunk {
        public byte[] b;
        public int n;

        public filechunk(int len) {
            this.b = new byte[len];
            this.n = 0;
        }
    }
}

