/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.geo;

import java.util.Comparator;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.geo.IntegerGeoPoint;

public class GeoLocation
extends IntegerGeoPoint
implements Comparable<GeoLocation>,
Comparator<GeoLocation> {
    private byte[] name;
    private int population;

    public GeoLocation(double lat, double lon) {
        super(lat, lon);
        this.name = null;
        this.population = 0;
    }

    public GeoLocation(double lat, double lon, String name) {
        super(lat, lon);
        this.name = UTF8.getBytes(name);
    }

    public void setName(String name) {
        this.name = UTF8.getBytes(name);
    }

    public String getName() {
        return UTF8.String(this.name);
    }

    public void setPopulation(int population) {
        this.population = population;
    }

    public int getPopulation() {
        return this.population;
    }

    @Override
    public boolean equals(Object loc) {
        if (!(loc instanceof GeoLocation)) {
            return false;
        }
        if (this.name == null || ((GeoLocation)loc).name == null) {
            return super.equals(loc);
        }
        return super.equals(loc) && this.getName().toLowerCase().equals(((GeoLocation)loc).getName().toLowerCase());
    }

    @Override
    public int compareTo(GeoLocation o) {
        long t;
        if (this.equals(o)) {
            return 0;
        }
        long s = (GeoLocation.ph(this.getPopulation()) << 30) + (long)this.hashCode();
        if (s > (t = (GeoLocation.ph(o.getPopulation()) << 30) + (long)o.hashCode())) {
            return -1;
        }
        if (s < t) {
            return 1;
        }
        return 0;
    }

    private static long ph(int population) {
        if (population > 10000) {
            population -= 10000;
        }
        return population;
    }

    @Override
    public int compare(GeoLocation o1, GeoLocation o2) {
        return o1.compareTo(o2);
    }

    public static int degreeToKm(double degree) {
        return (int)(degree * 111.32);
    }
}

