/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Pattern;
import net.yacy.cora.federate.solr.responsewriter.HTMLResponseWriter;
import net.yacy.cora.federate.solr.responsewriter.SolrjResponseWriter;
import net.yacy.document.SentenceReader;
import net.yacy.search.schema.CollectionSchema;
import org.apache.lucene.document.Document;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XML;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;

public class GrepHTMLResponseWriter
implements QueryResponseWriter,
SolrjResponseWriter {
    private static final Set<String> DEFAULT_FIELD_LIST = new HashSet<String>();
    private static final Pattern dqp = Pattern.compile("\"");

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "text/html";
    }

    public void init(NamedList n) {
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse rsp) throws IOException {
        this.writeHtmlHead(writer);
        SolrParams params = request.getOriginalParams();
        String query2 = this.getQueryParam(params);
        String grep = this.getGrepParam(params, query2);
        Object responseObj = rsp.getResponse();
        if (responseObj instanceof SolrDocumentList) {
            SolrDocumentList docList = (SolrDocumentList)responseObj;
            this.writeSolrDocumentList(writer, params, query2, grep, docList);
        } else if (responseObj instanceof ResultContext) {
            DocList documents = ((ResultContext)responseObj).getDocList();
            int sz = documents.size();
            if (sz > 0) {
                SolrIndexSearcher searcher = request.getSearcher();
                DocIterator iterator = documents.iterator();
                IndexSchema schema2 = request.getSchema();
                this.writeTitleAndHeadeing(writer, grep, query2);
                this.writeApiLink(writer, params);
                for (int i = 0; i < sz; ++i) {
                    int id = iterator.nextDoc();
                    Document doc = searcher.doc(id, DEFAULT_FIELD_LIST);
                    LinkedHashMap<String, String> tdoc = HTMLResponseWriter.translateDoc(schema2, doc);
                    String sku = tdoc.get(CollectionSchema.sku.getSolrFieldName());
                    String title = tdoc.get(CollectionSchema.title.getSolrFieldName());
                    String text = tdoc.get(CollectionSchema.text_t.getSolrFieldName());
                    ArrayList<String> sentences = this.extractSentences(title, text);
                    GrepHTMLResponseWriter.writeDoc(writer, sku, sentences, grep);
                }
            } else {
                writer.write("<title>No Document Found</title>\n</head><body>\n");
            }
        } else {
            writer.write("<title>Unable to process Solr response</title>\n</head><body>\n");
        }
        writer.write("</body></html>\n");
    }

    private void writeSolrDocumentList(Writer writer, SolrParams params, String query2, String grep, SolrDocumentList docList) throws IOException {
        if (docList == null || docList.isEmpty()) {
            writer.write("<title>No Document Found</title>\n</head><body>\n");
        } else {
            this.writeTitleAndHeadeing(writer, grep, query2);
            this.writeApiLink(writer, params);
            SolrReturnFields fieldsToReturn = new SolrReturnFields();
            for (SolrDocument doc : docList) {
                LinkedHashMap<String, String> tdoc = HTMLResponseWriter.translateDoc(doc, (ReturnFields)fieldsToReturn);
                String sku = tdoc.get(CollectionSchema.sku.getSolrFieldName());
                String title = tdoc.get(CollectionSchema.title.getSolrFieldName());
                String text = tdoc.get(CollectionSchema.text_t.getSolrFieldName());
                ArrayList<String> sentences = this.extractSentences(title, text);
                GrepHTMLResponseWriter.writeDoc(writer, sku, sentences, grep);
            }
        }
    }

    private void writeHtmlHead(Writer writer) throws IOException {
        writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n");
        writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n");
        writer.write("<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"../env/base.css\" />\n");
        writer.write("<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"../env/style.css\" />\n");
    }

    private String getGrepParam(SolrParams params, String query2) {
        String grep = params.get("grep");
        if (grep == null) {
            grep = query2.length() > 0 ? query2 : "";
        }
        if (grep.length() > 0) {
            if (grep.charAt(0) == '\"') {
                grep = grep.substring(1);
            }
            if (grep.charAt(grep.length() - 1) == '\"') {
                grep = grep.substring(0, grep.length() - 1);
            }
        }
        return grep;
    }

    private String getQueryParam(SolrParams params) {
        String q = params.get("q", "");
        String query2 = "";
        int p = q.indexOf(58);
        if (p >= 0) {
            int r;
            int n = r = q.charAt(p + 1) == '\"' ? q.indexOf(p + 2, 34) : q.indexOf(32);
            if (r < 0) {
                r = q.length();
            }
            if ((query2 = q.substring(p + 1, r)).length() > 0) {
                if (query2.charAt(0) == '\"') {
                    query2 = query2.substring(1);
                }
                if (query2.charAt(query2.length() - 1) == '\"') {
                    query2 = query2.substring(0, query2.length() - 1);
                }
            }
        }
        return query2;
    }

    private void writeTitleAndHeadeing(Writer writer, String grep, String query2) throws IOException {
        String h1 = "Document Grep for query \"" + query2 + "\" and grep phrase \"" + grep + "\"";
        writer.write("<title>" + h1 + "</title>\n</head><body>\n<h1>" + h1 + "</h1>\n");
    }

    private void writeApiLink(Writer writer, SolrParams solrParams) throws IOException {
        NamedList paramsList = solrParams.toNamedList();
        paramsList.remove("wt");
        String xmlquery = dqp.matcher("select?" + SolrParams.toSolrParams((NamedList)paramsList).toString()).replaceAll("%22");
        writer.write("<div id=\"api\"><a href=\"" + xmlquery + "\"><img src=\"../env/grafics/api.png\" width=\"60\" height=\"40\" alt=\"API\" /></a>\n");
        writer.write("<span>This search result can also be retrieved as XML. Click the API icon to see an example call to the search rss API.</span></div>\n");
    }

    private ArrayList<String> extractSentences(String title, String text) {
        ArrayList<String> sentences = new ArrayList<String>();
        if (title != null) {
            sentences.add(title);
        }
        if (text != null) {
            SentenceReader sr = new SentenceReader(text);
            while (sr.hasNext()) {
                StringBuilder line = sr.next();
                if (line.length() <= 0) continue;
                sentences.add(line.toString());
            }
        }
        return sentences;
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, String coreName, QueryResponse rsp) throws IOException {
        this.writeHtmlHead(writer);
        SolrParams params = request.getOriginalParams();
        String query2 = this.getQueryParam(params);
        String grep = this.getGrepParam(params, query2);
        this.writeSolrDocumentList(writer, params, query2, grep, rsp.getResults());
        writer.write("</body></html>\n");
    }

    private static final void writeDoc(Writer writer, String url, ArrayList<String> sentences, String grep) throws IOException {
        writer.write("<form name=\"yacydoc" + url + "\" method=\"post\" action=\"#\" enctype=\"multipart/form-data\" accept-charset=\"UTF-8\">\n");
        writer.write("<fieldset>\n");
        writer.write("<h1><a href=\"" + url + "\">" + url + "</a></h1>\n");
        writer.write("<dl>\n");
        int c = 0;
        for (String line : sentences) {
            if (grep != null && grep.length() > 0 && line.indexOf(grep) < 0) continue;
            writer.write("<dt>");
            if (c++ == 0) {
                if (grep == null || grep.length() == 0) {
                    writer.write("all lines in document");
                } else {
                    writer.write("matches for grep phrase \"");
                    writer.write(grep);
                    writer.write("\"");
                }
            }
            writer.write("</dt>");
            GrepHTMLResponseWriter.writedd(writer, line, grep);
        }
        writer.write("</dl>\n");
        writer.write("</fieldset>\n");
        writer.write("</form>\n");
    }

    private static void writedd(Writer writer, String line, String grep) throws IOException {
        writer.write("<dd><a href=\"select?q=text_t:%22");
        XML.escapeAttributeValue((String)line, (Writer)writer);
        writer.write("%22&rows=100&grep=%22");
        XML.escapeAttributeValue((String)grep, (Writer)writer);
        writer.write("%22&wt=grephtml\">");
        XML.escapeAttributeValue((String)line, (Writer)writer);
        writer.write("</a></dd>\n");
    }

    static {
        DEFAULT_FIELD_LIST.add(CollectionSchema.id.getSolrFieldName());
        DEFAULT_FIELD_LIST.add(CollectionSchema.sku.getSolrFieldName());
        DEFAULT_FIELD_LIST.add(CollectionSchema.title.getSolrFieldName());
        DEFAULT_FIELD_LIST.add(CollectionSchema.text_t.getSolrFieldName());
    }
}

