/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.LittleEndian;

public class EscherPlaceholder
extends EscherRecord {
    private static final Logger LOG = LogManager.getLogger(EscherPlaceholder.class);
    public static final short RECORD_ID = RecordTypes.OEPlaceholderAtom.typeID;
    public static final String RECORD_DESCRIPTION = "msofbtClientTextboxPlaceholder";
    private int position = -1;
    private byte placementId;
    private byte size;
    private short unused;

    public EscherPlaceholder() {
    }

    public EscherPlaceholder(EscherPlaceholder other) {
        super((EscherRecord)other);
        this.position = other.position;
        this.placementId = other.placementId;
        this.size = other.size;
        this.unused = other.unused;
    }

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        this.position = LittleEndian.getInt((byte[])data, (int)(offset + 8));
        this.placementId = data[offset + 12];
        this.size = data[offset + 13];
        this.unused = LittleEndian.getShort((byte[])data, (int)(offset + 14));
        if (bytesRemaining + 8 != 16) {
            LOG.warn("Invalid header-data received, should have 8 bytes left, but had: {}", (Object)bytesRemaining);
        }
        return bytesRemaining + 8;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), (EscherRecord)this);
        LittleEndian.putShort((byte[])data, (int)offset, (short)this.getOptions());
        LittleEndian.putShort((byte[])data, (int)(offset + 2), (short)this.getRecordId());
        LittleEndian.putInt((byte[])data, (int)(offset + 4), (int)8);
        LittleEndian.putInt((byte[])data, (int)(offset + 8), (int)this.position);
        LittleEndian.putByte((byte[])data, (int)(offset + 12), (int)this.placementId);
        LittleEndian.putByte((byte[])data, (int)(offset + 13), (int)this.size);
        LittleEndian.putShort((byte[])data, (int)(offset + 14), (short)this.unused);
        listener.afterRecordSerialize(offset + this.getRecordSize(), this.getRecordId(), this.getRecordSize(), (EscherRecord)this);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 16;
    }

    public String getRecordName() {
        return "ClientTextboxPlaceholder";
    }

    public int getPosition() {
        return this.position;
    }

    public byte getPlacementId() {
        return this.placementId;
    }

    public byte getSize() {
        return this.size;
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties((String)"base", () -> super.getGenericProperties(), (String)"position", this::getPosition, (String)"placementId", this::getPlacementId, (String)"size", this::getSize);
    }

    public Enum getGenericRecordType() {
        return RecordTypes.OEPlaceholderAtom;
    }

    public EscherPlaceholder copy() {
        return new EscherPlaceholder(this);
    }
}

