/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class RadarPlotter
extends RasterPlotter {
    private final int centerX;
    private final int centerY;
    private final int innerRadius;
    private final int outerRadius;
    private final double[] blipAngles;
    private final int[] blipRadius;
    private final long[] blipColors;

    public RadarPlotter(int width, int height) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 24L);
        this.centerX = width / 2;
        this.centerY = height / 2;
        this.innerRadius = Math.min(width, height) / 6;
        this.outerRadius = Math.min(width, height) / 2 - 20;
        this.blipAngles = new double[]{18.0, 46.0, 102.0, 153.0, 214.0, 276.0, 320.0};
        this.blipRadius = new int[]{this.innerRadius + 30, this.innerRadius + 70, this.innerRadius + 110, this.innerRadius + 160, this.innerRadius + 120, this.innerRadius + 50, this.innerRadius + 90};
        this.blipColors = new long[]{0x44FFAAL, 0x66FFEEL, 0xFF88AAL, 0x88AAFFL, 0xFFFF66L, 0xFF3366L, 0x99FF99L};
    }

    public void renderFrame(int frameIndex) {
        this.clear();
        double sweepAngle = (double)(frameIndex % 8) * 45.0;
        this.drawRadarGrid(sweepAngle);
        this.drawSweepBeam(sweepAngle);
        this.drawBlips(sweepAngle);
        this.drawOverlay();
    }

    private void drawRadarGrid(double sweepAngle) {
        this.setColor(13158L);
        for (int r = this.innerRadius; r <= this.outerRadius; r += 30) {
            this.arc(this.centerX, this.centerY, r - 1, r, 25);
        }
        this.setColor(17544L);
        for (int a = 0; a < 360; a += 15) {
            this.arcLine(this.centerX, this.centerY, this.innerRadius - 10, this.outerRadius, a, true, null, null, -1, -1, -1, false);
        }
        this.setColor(4386L);
        this.arc(this.centerX, this.centerY, this.innerRadius - 15, this.innerRadius - 8, 18);
        this.arc(this.centerX, this.centerY, this.outerRadius + 5, this.outerRadius + 8, 30);
        double pulse = 10.0 + 8.0 * Math.sin(Math.toRadians(sweepAngle));
        this.setColor(43775L);
        this.arc(this.centerX, this.centerY, this.innerRadius + 5, (int)((double)(this.innerRadius + 5) + pulse), 35);
    }

    private void drawSweepBeam(double sweepAngle) {
        int beamWidth = 4;
        long[] colors = new long[]{65484L, 48042L, 34935L, 17459L};
        for (int i = 0; i < 4; ++i) {
            double angle = sweepAngle - (double)i * 2.5;
            this.setColor(colors[i]);
            this.arcLine(this.centerX, this.centerY, this.innerRadius - 4, this.outerRadius + 5, angle, true, null, null, -1, -1, -1, false);
        }
    }

    private void drawBlips(double sweepAngle) {
        for (int i = 0; i < this.blipAngles.length; ++i) {
            double angle = this.blipAngles[i];
            int radius = this.blipRadius[i];
            double diff = Math.abs((sweepAngle - angle + 540.0) % 360.0 - 180.0);
            int intensity = diff < 12.0 ? 90 : (diff < 24.0 ? 60 : 35);
            long color = this.blipColors[i];
            this.setColor(color);
            int x = this.centerX + (int)Math.round(Math.cos(Math.toRadians(angle)) * (double)radius);
            int y = this.centerY - (int)Math.round(Math.sin(Math.toRadians(angle)) * (double)radius);
            this.dot(x, y, diff < 10.0 ? 6 : 4, true, intensity);
            if (!(diff < 18.0)) continue;
            this.setColor(RadarPlotter.lighten(color, 1.4));
            this.dot(x, y, 2, true, 100);
        }
    }

    private void drawOverlay() {
        this.setColor(26265L);
        PrintTool.print5(this, 4, 12, 0, "NEON VECTOR RADAR", -1, 80);
        this.setColor(65535L);
        PrintTool.print5(this, 4, 24, 0, "SCAN ACTIVE", -1, 70);
        this.setColor(17510L);
        PrintTool.print5(this, this.getWidth() - 4, 12, 0, "RANGE:" + this.outerRadius + "px", 1, 70);
    }

    public static void main(String[] args) {
        File target;
        System.setProperty("java.awt.headless", "true");
        File file = target = args.length > 0 ? new File(args[0]) : new File(".");
        if (!target.exists()) {
            target.mkdirs();
        }
        RadarPlotter radar = new RadarPlotter(480, 480);
        for (int frame = 0; frame < 8; ++frame) {
            radar.renderFrame(frame);
            File out = new File(target, String.format("neon_radar_%02d.png", frame));
            try {
                radar.save(out, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save radar frame", e);
            }
        }
    }
}

