/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.server;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ChunkedBytes;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.kelondro.util.Formatter;
import net.yacy.search.Switchboard;
import net.yacy.search.schema.CollectionSchema;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.json.JSONObject;

public class serverObjects
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3999165204849858546L;
    public static final String ACTION_AUTHENTICATE = "AUTHENTICATE";
    public static final String ACTION_LOCATION = "LOCATION";
    public static final String ADMIN_AUTHENTICATE_MSG = "admin log-in. If you don't know the password, set it with {yacyhome}/bin/passwd.sh {newpassword}";
    private boolean localized = true;
    private static final char BOM = '\ufeff';
    private final Map<String, ChunkedBytes[]> map;

    public serverObjects() {
        this.map = new ConcurrentHashMap<String, ChunkedBytes[]>();
    }

    protected serverObjects(serverObjects o) {
        this.map = new ConcurrentHashMap<String, ChunkedBytes[]>(o.map);
        this.localized = o.localized;
    }

    protected serverObjects(Map<String, ChunkedBytes[]> input) {
        this.map = new ConcurrentHashMap<String, ChunkedBytes[]>(input);
    }

    public void authenticationRequired() {
        this.put(ACTION_AUTHENTICATE, ADMIN_AUTHENTICATE_MSG);
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private static final String removeByteOrderMark(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.charAt(0) == '\ufeff') {
            return s.substring(1);
        }
        return s;
    }

    public boolean containsKey(String key) {
        return key != null && this.map.containsKey(key);
    }

    public MultiMapSolrParams getSolrParams() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (String key : this.keySet()) {
            ChunkedBytes[] cbs = this.map.get(key);
            if (cbs == null) continue;
            for (ChunkedBytes cb : cbs) {
                params.add(key, new String[]{UTF8.String(cb.toByteArray())});
            }
        }
        return new MultiMapSolrParams(params.getMap());
    }

    public List<Map.Entry<String, String>> entrySet() {
        ArrayList<Map.Entry<String, String>> set = new ArrayList<Map.Entry<String, String>>(this.map.size() * 2);
        for (Map.Entry<String, ChunkedBytes[]> entry2 : this.map.entrySet()) {
            ChunkedBytes[] vlist;
            for (ChunkedBytes v : vlist = entry2.getValue()) {
                set.add(new AbstractMap.SimpleEntry<String, String>(entry2.getKey(), serverObjects.removeByteOrderMark(UTF8.String(v.toByteArray()))));
            }
        }
        return set;
    }

    public List<String> values() {
        ArrayList<String> list2 = new ArrayList<String>(this.map.size() * 2);
        for (Map.Entry<String, ChunkedBytes[]> entry2 : this.map.entrySet()) {
            for (ChunkedBytes v : entry2.getValue()) {
                list2.add(serverObjects.removeByteOrderMark(UTF8.String(v.toByteArray())));
            }
        }
        return list2;
    }

    public Set<String> keySet() {
        return new HashSet<String>(this.map.keySet());
    }

    public String[] remove(String key) {
        ChunkedBytes[] cbs = this.map.remove(key);
        String[] arr = new String[cbs == null ? 0 : cbs.length];
        if (cbs != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = UTF8.String(cbs[i].toByteArray());
            }
        }
        return arr;
    }

    public void putAll(Map<String, String> m) {
        for (Map.Entry<String, String> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void add(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        ChunkedBytes[] a = this.map.get(key);
        if (a == null) {
            this.map.put(key, new ChunkedBytes[]{new ChunkedBytes(value)});
            return;
        }
        ChunkedBytes nv = new ChunkedBytes(value);
        for (ChunkedBytes cb : a) {
            if (!cb.equals(nv)) continue;
            return;
        }
        ChunkedBytes[] aa = new ChunkedBytes[a.length + 1];
        System.arraycopy(a, 0, aa, 0, a.length);
        aa[a.length] = nv;
        this.map.put(key, aa);
    }

    public void put(String key, boolean value) {
        this.put(key, value ? "1" : "0");
    }

    public void put(String key, ChunkedBytes value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.map.remove(key);
            return;
        }
        this.map.put(key, new ChunkedBytes[]{value});
    }

    public void put(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.map.remove(key);
            return;
        }
        this.map.put(key, new ChunkedBytes[]{new ChunkedBytes(value)});
    }

    public void add(String key, byte[] value) {
        if (value == null) {
            return;
        }
        this.add(key, UTF8.String(value));
    }

    public void put(String key, byte[] value) {
        if (value == null) {
            return;
        }
        this.put(key, UTF8.String(value));
    }

    public void put(String key, String[] values) {
        if (key == null) {
            return;
        }
        if (values == null) {
            this.map.remove(key);
            return;
        }
        ChunkedBytes[] cbs = new ChunkedBytes[values.length];
        for (int i = 0; i < values.length; ++i) {
            cbs[i] = new ChunkedBytes(values[i]);
        }
        this.map.put(key, cbs);
    }

    public void put(String key, float value) {
        this.put(key, Float.toString(value));
    }

    public void put(String key, double value) {
        this.put(key, Double.toString(value));
    }

    public void put(String key, long value) {
        this.put(key, Long.toString(value));
    }

    public void put(String key, Date value) {
        this.put(key, value.toString());
    }

    public void put(String key, InetAddress value) {
        this.put(key, value == null ? "" : value.getHostAddress());
    }

    public void putJSON(String key, String value) {
        if (value == null) {
            this.put(key, "");
            return;
        }
        value = JSONObject.quote(value);
        value = value.substring(1, value.length() - 1);
        this.put(key, value);
    }

    public void putHTML(String key, String value) {
        this.put(key, value == null ? "" : CharacterCoding.unicode2html(UTF8.decodeURL(value), true));
    }

    public void putHTML(String key, byte[] value) {
        this.putHTML(key, value == null ? "" : CharacterCoding.unicode2html(UTF8.decodeURL(UTF8.String(value)), true));
    }

    public void putUrlEncodedHTML(String key, String value) {
        this.put(key, value == null ? "" : CharacterCoding.unicode2html(value, true));
    }

    public void putXML(String key, String value) {
        this.put(key, value == null ? "" : CharacterCoding.unicode2xml(value, true));
    }

    public void put(RequestHeader.FileType fileType, String key, String value) {
        if (fileType == RequestHeader.FileType.JSON) {
            this.putJSON(key, value == null ? "" : value);
        } else if (fileType == RequestHeader.FileType.XML) {
            this.putXML(key, value == null ? "" : value);
        } else {
            this.putHTML(key, value == null ? "" : value);
        }
    }

    public void putUrlEncoded(RequestHeader.FileType fileType, String key, String value) {
        if (fileType == RequestHeader.FileType.JSON) {
            this.putJSON(key, value == null ? "" : value);
        } else if (fileType == RequestHeader.FileType.XML) {
            this.putXML(key, value == null ? "" : value);
        } else {
            this.putUrlEncodedHTML(key, value == null ? "" : value);
        }
    }

    public void putNum(String key, long value) {
        this.put(key, Formatter.number(value, this.localized));
    }

    public void putNum(String key, double value) {
        this.put(key, Formatter.number(value, this.localized));
    }

    public void putNum(String key, String value) {
        this.put(key, value == null ? "" : Formatter.number(value));
    }

    public void putWiki(String hostport, String key, String wikiCode) {
        this.put(key, Switchboard.wikiParser.transform(hostport, wikiCode));
    }

    public void putWiki(String key, String wikiCode) {
        this.putWiki(null, key, wikiCode);
    }

    public void putWiki(String hostport, String key, byte[] wikiCode) {
        try {
            this.put(key, Switchboard.wikiParser.transform(hostport, wikiCode));
        }
        catch (Exception e) {
            this.put(key, "Internal error pasting wiki-code: " + e.getMessage());
        }
    }

    public void putWiki(String key, byte[] wikiCode) {
        this.putWiki(null, key, wikiCode);
    }

    public long inc(String key) {
        String c = this.get(key);
        if (c == null) {
            c = "0";
        }
        long l = Long.parseLong(c) + 1L;
        this.put(key, Long.toString(l));
        return l;
    }

    public String[] getParams(String name) {
        ChunkedBytes[] cbs = this.map.get(name);
        String[] s = new String[cbs == null ? 0 : cbs.length];
        if (cbs != null) {
            for (int i = 0; i < s.length; ++i) {
                s[i] = serverObjects.removeByteOrderMark(cbs[i] == null ? null : UTF8.String(cbs[i].toByteArray()));
            }
        }
        return s;
    }

    public String get(String key) {
        ChunkedBytes[] cbs = this.map.get(key);
        String s = cbs == null || cbs.length == 0 ? null : UTF8.String(cbs[0].toByteArray());
        return serverObjects.removeByteOrderMark(s);
    }

    public byte[] getBytes(String key) {
        ChunkedBytes[] cbs = this.map.get(key);
        return cbs == null || cbs.length == 0 ? null : cbs[0].toByteArray();
    }

    public InputStream getInputStream(String key) {
        ChunkedBytes[] cbs = this.map.get(key);
        return cbs == null || cbs.length == 0 ? null : cbs[0].openStream();
    }

    public String get(String key, String dflt) {
        String result = this.get(key);
        return result == null ? dflt : result;
    }

    public ChunkedBytes get(String key, ChunkedBytes dflt) {
        ChunkedBytes[] cbs = this.map.get(key);
        return cbs == null || cbs.length == 0 ? dflt : cbs[0];
    }

    public int getInt(String key, int dflt) {
        String s = this.get(key);
        if (s == null) {
            return dflt;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public long getLong(String key, long dflt) {
        String s = this.get(key);
        if (s == null) {
            return dflt;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public float getFloat(String key, float dflt) {
        String s = this.get(key);
        if (s == null) {
            return dflt;
        }
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public double getDouble(String key, double dflt) {
        String s = this.get(key);
        if (s == null) {
            return dflt;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public boolean getBoolean(String key) {
        String s = this.get(key);
        if (s == null) {
            return false;
        }
        return (s = s.toLowerCase(Locale.ROOT)).equals("true") || s.equals("on") || s.equals("1");
    }

    public String[] getAll(String keyMapper) throws PatternSyntaxException {
        ArrayList<String> v = new ArrayList<String>();
        Pattern keyPattern = Pattern.compile(keyMapper);
        for (Map.Entry<String, String> entry2 : this.entrySet()) {
            if (!keyPattern.matcher(entry2.getKey()).matches()) continue;
            v.add(entry2.getValue());
        }
        return v.toArray(new String[0]);
    }

    public Map<String, String> getMatchingEntries(String keyMapper) throws PatternSyntaxException {
        Pattern keyPattern = Pattern.compile(keyMapper);
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (Map.Entry<String, String> entry2 : this.entrySet()) {
            if (!keyPattern.matcher(entry2.getKey()).matches()) continue;
            map.put(entry2.getKey(), entry2.getValue());
        }
        return map;
    }

    public void putAll(serverObjects add) {
        for (Map.Entry<String, String> entry2 : add.entrySet()) {
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    public void store(File f) throws IOException {
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));){
            for (Map.Entry<String, String> e : this.entrySet()) {
                String v = e.getValue().replace("\\", "\\\\").replace("\r", "\\r").replace("\n", "\\n").replace("=", "\\=");
                String line = e.getKey() + "=" + v + "\r\n";
                fos.write(UTF8.getBytes(line));
            }
            fos.flush();
        }
    }

    public void setLocalized(boolean loc) {
        this.localized = loc;
    }

    public serverObjects clone() {
        ConcurrentHashMap<String, ChunkedBytes[]> copy = new ConcurrentHashMap<String, ChunkedBytes[]>();
        this.map.forEach((k, arr) -> {
            ChunkedBytes[] arrCopy = new ChunkedBytes[((ChunkedBytes[])arr).length];
            for (int i = 0; i < ((ChunkedBytes[])arr).length; ++i) {
                arrCopy[i] = (ChunkedBytes)arr[i].clone();
            }
            copy.put((String)k, arrCopy);
        });
        serverObjects c = new serverObjects(copy);
        c.localized = this.localized;
        return c;
    }

    public String toString() {
        if (this.map.isEmpty()) {
            return "";
        }
        StringBuilder param = new StringBuilder(this.map.size() * 40);
        for (Map.Entry<String, String> entry2 : this.entrySet()) {
            param.append((CharSequence)MultiProtocolURL.escape(entry2.getKey())).append('=').append((CharSequence)MultiProtocolURL.escape(entry2.getValue())).append('&');
        }
        return param.toString();
    }

    public MultiMapSolrParams toSolrParams(CollectionSchema[] facets) {
        this.map.putIfAbsent("df", new ChunkedBytes[]{new ChunkedBytes(CollectionSchema.text_t.getSolrFieldName())});
        this.map.putIfAbsent("start", new ChunkedBytes[]{new ChunkedBytes("0")});
        this.map.putIfAbsent("rows", new ChunkedBytes[]{new ChunkedBytes("10")});
        if (facets != null && facets.length > 0) {
            this.remove("facet");
            this.put("facet", "true");
            for (int i = 0; i < facets.length; ++i) {
                this.add("facet.field", facets[i].getSolrFieldName());
            }
        }
        return this.getSolrParams();
    }
}

