/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.server.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.server.serverCore;

public final class ChunkedOutputStream
extends FilterOutputStream {
    private boolean finished = false;

    public ChunkedOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.finished) {
            this.finish();
        }
        this.out.close();
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.out.write(48);
            this.out.write(serverCore.CRLF);
            this.out.write(serverCore.CRLF);
            this.out.flush();
            this.finished = true;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.finished) {
            throw new IOException("ChunkedOutputStream already finalized.");
        }
        if (b.length == 0) {
            return;
        }
        this.out.write(ASCII.getBytes(Integer.toHexString(b.length)));
        this.out.write(serverCore.CRLF);
        this.out.write(b);
        this.out.write(serverCore.CRLF);
        this.out.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.finished) {
            throw new IOException("ChunkedOutputStream already finalized.");
        }
        if (len == 0) {
            return;
        }
        this.out.write(ASCII.getBytes(Integer.toHexString(len)));
        this.out.write(serverCore.CRLF);
        this.out.write(b, off, len);
        this.out.write(serverCore.CRLF);
        this.out.flush();
    }

    public void write(ByteBuffer b, int off, int len) throws IOException {
        if (this.finished) {
            throw new IOException("ChunkedOutputStream already finalized.");
        }
        if (len == 0) {
            return;
        }
        this.out.write(ASCII.getBytes(Integer.toHexString(len)));
        this.out.write(serverCore.CRLF);
        this.out.write(b.getBytes(off, len));
        this.out.write(serverCore.CRLF);
        this.out.flush();
    }

    public void write(InputStream b) throws IOException {
        if (this.finished) {
            throw new IOException("ChunkedOutputStream already finalized.");
        }
        int len = b.available();
        if (len == 0) {
            return;
        }
        this.out.write(ASCII.getBytes(Integer.toHexString(len)));
        this.out.write(serverCore.CRLF);
        FileUtils.copy(b, this.out, (long)len);
        this.out.write(serverCore.CRLF);
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.finished) {
            throw new IOException("ChunkedOutputStream already finalized.");
        }
        this.out.write(UTF8.getBytes("1"));
        this.out.write(serverCore.CRLF);
        this.out.write(b);
        this.out.write(serverCore.CRLF);
        this.out.flush();
    }
}

