/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.yacy.cora.sorting.ConcurrentScoreMap;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.navigator.Navigator;
import net.yacy.search.navigator.NavigatorSort;
import net.yacy.search.navigator.NavigatorSortDirection;
import net.yacy.search.navigator.NavigatorSortType;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.schema.CollectionSchema;

public class StringNavigator
extends ConcurrentScoreMap<String>
implements Navigator {
    public String title;
    protected final CollectionSchema field;
    private final NavigatorSort sort;

    public StringNavigator(String title, CollectionSchema field) {
        this(title, field, NavigatorSort.COUNT_DESC);
    }

    public StringNavigator(String title, CollectionSchema field, NavigatorSort sort) {
        this.title = title;
        this.field = field;
        this.sort = sort == null ? NavigatorSort.COUNT_DESC : sort;
    }

    @Override
    public String getDisplayName() {
        return this.title;
    }

    @Override
    public String getElementDisplayName(String e) {
        return e;
    }

    @Override
    public String getQueryModifier(String key) {
        Object mod;
        if (this.field != null) {
            switch (this.field) {
                case author_sxt: {
                    if (key.indexOf(32) > 0) {
                        mod = "author:(" + key + ")";
                        break;
                    }
                    mod = "author:" + key;
                    break;
                }
                case keywords: {
                    mod = "keyword:" + key;
                    break;
                }
                case url_protocol_s: {
                    mod = "/" + key;
                    break;
                }
                case url_file_ext_s: {
                    mod = "filetype:" + key;
                    break;
                }
                case collection_sxt: {
                    mod = "collection:" + key;
                    break;
                }
                case host_s: {
                    mod = "site:" + key;
                    break;
                }
                case language_s: {
                    mod = "/language/" + key;
                    break;
                }
                default: {
                    mod = key;
                    break;
                }
            }
        } else {
            mod = "";
        }
        return mod;
    }

    @Override
    public void incDocList(List<URIMetadataNode> docs) {
        if (this.field != null) {
            for (URIMetadataNode doc : docs) {
                this.incDoc(doc);
            }
        }
    }

    @Override
    public void incFacet(Map<String, ReversibleScoreMap<String>> facets) {
        ReversibleScoreMap<String> fcts;
        if (this.field != null && facets != null && !facets.isEmpty() && (fcts = facets.get(this.field.getSolrFieldName())) != null) {
            this.inc(fcts);
        }
    }

    @Override
    public void incDoc(URIMetadataNode doc) {
        Object val;
        if (this.field != null && (val = doc.getFieldValue(this.field.getSolrFieldName())) != null) {
            if (val instanceof Collection) {
                Collection ll = (Collection)val;
                for (Object obj : ll) {
                    String s;
                    if (!(obj instanceof String) || (s = (String)obj).isEmpty()) continue;
                    this.inc(s);
                }
            } else {
                this.inc((String)val);
            }
        }
    }

    @Override
    public boolean modifieractive(QueryModifier modifier, String name) {
        return modifier.toString().contains(this.getQueryModifier(name));
    }

    @Override
    public String getIndexFieldName() {
        if (this.field != null) {
            return this.field.getSolrFieldName();
        }
        return "";
    }

    @Override
    public Iterator<String> navigatorKeys() {
        if (this.sort.getSortType() == NavigatorSortType.LABEL) {
            ArrayList keys = new ArrayList(this.map.keySet());
            Comparator<String> keyComparator = Comparator.comparing(this::getElementDisplayName);
            if (this.sort.getSortDir() == NavigatorSortDirection.DESC) {
                keyComparator = keyComparator.reversed();
            }
            Collections.sort(keys, keyComparator);
            return keys.iterator();
        }
        return this.keys(this.sort.getSortDir() == NavigatorSortDirection.ASC);
    }

    @Override
    public NavigatorSort getSort() {
        return this.sort;
    }
}

