/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.graphics;

public class BannerData {
    private final int width;
    private final int height;
    private final long bgcolor;
    private final long textcolor;
    private final long bordercolor;
    private final String name;
    private final long links;
    private final long words;
    private final String type;
    private final int ppm;
    private final String network;
    private final int peers;
    private final long nlinks;
    private final long nwords;
    private final double nqph;
    private final long nppm;

    public BannerData(int width, int height, String bgcolor, String textcolor, String bordercolor, String name, long links, long words, String type, int ppm, String network, int peers, long nlinks, long nwords, double nqph, long nppm) {
        this.width = width;
        this.height = height;
        try {
            this.bgcolor = Long.parseLong(bgcolor, 16);
            this.textcolor = Long.parseLong(textcolor, 16);
            this.bordercolor = Long.parseLong(bordercolor, 16);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid color definition.", ex);
        }
        this.name = name;
        this.links = links;
        this.words = words;
        this.type = type;
        this.ppm = ppm;
        this.network = network;
        this.peers = peers;
        this.nlinks = nlinks;
        this.nwords = nwords;
        this.nqph = nqph;
        this.nppm = nppm;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final long getBgcolor() {
        return this.bgcolor;
    }

    public final long getTextcolor() {
        return this.textcolor;
    }

    public final long getBordercolor() {
        return this.bordercolor;
    }

    public final String getName() {
        return this.name;
    }

    public final long getLinks() {
        return this.links;
    }

    public final long getWords() {
        return this.words;
    }

    public final String getType() {
        return this.type;
    }

    public final int getPpm() {
        return this.ppm;
    }

    public final String getNetwork() {
        return this.network;
    }

    public final int getPeers() {
        return this.peers;
    }

    public final long getNlinks() {
        return this.nlinks;
    }

    public final long getNwords() {
        return this.nwords;
    }

    public final double getNqph() {
        return this.nqph;
    }

    public final long getNppm() {
        return this.nppm;
    }
}

